/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.objects_api;

import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.objects_api.utils.Filter;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.Limiter;
import com.pubnub.api.endpoints.objects_api.utils.Pager;
import com.pubnub.api.endpoints.objects_api.utils.ParameterEnricher;
import com.pubnub.api.endpoints.objects_api.utils.Sorter;
import com.pubnub.api.endpoints.objects_api.utils.TotalCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CompositeParameterEnricher
implements ParameterEnricher {
    private final Include include;
    private final Sorter sorter;
    private final Pager pager;
    private final Filter filter;
    private final TotalCounter totalCounter;
    private final Limiter limiter;

    public static CompositeParameterEnricher createDefault() {
        Include include = new Include();
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        Filter filter = new Filter();
        Limiter limiter = new Limiter();
        TotalCounter totalCounter = new TotalCounter();
        return new CompositeParameterEnricher(include, sorter, pager, filter, totalCounter, limiter);
    }

    public CompositeParameterEnricher(Include include, Sorter sorter, Pager pager, Filter filter, TotalCounter totalCounter, Limiter limiter) {
        this.include = include;
        this.sorter = sorter;
        this.pager = pager;
        this.filter = filter;
        this.totalCounter = totalCounter;
        this.limiter = limiter;
    }

    @Override
    public Map<String, String> enrichParameters(Map<String, String> baseParams) {
        Map<String, String> enrichedMap = new HashMap<String, String>(baseParams);
        ArrayList<ParameterEnricher> parameterEnrichers = new ArrayList<ParameterEnricher>();
        for (ParameterEnricher enricher : Arrays.asList(this.include, this.sorter, this.pager, this.filter, this.totalCounter, this.limiter)) {
            if (enricher == null) continue;
            parameterEnrichers.add(enricher);
        }
        for (ParameterEnricher parameterEnricher : parameterEnrichers) {
            enrichedMap = parameterEnricher.enrichParameters(enrichedMap);
        }
        return enrichedMap;
    }

    @Override
    public void validateParameters() throws PubNubException {
        for (ParameterEnricher parameterEnricher : Arrays.asList(this.include, this.sorter, this.pager, this.filter, this.totalCounter, this.limiter)) {
            parameterEnricher.validateParameters();
        }
    }

    public Include getInclude() {
        return this.include;
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public Pager getPager() {
        return this.pager;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public TotalCounter getTotalCounter() {
        return this.totalCounter;
    }

    public Limiter getLimiter() {
        return this.limiter;
    }
}

