/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.json.ObjectMapperProvider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class JsonCodecFactory {
    private final Provider<ObjectMapper> objectMapperProvider;
    private final boolean prettyPrint;

    public JsonCodecFactory() {
        this(new ObjectMapperProvider());
    }

    @Inject
    public JsonCodecFactory(Provider<ObjectMapper> objectMapperProvider) {
        this(objectMapperProvider, false);
    }

    public JsonCodecFactory(Provider<ObjectMapper> objectMapperProvider, boolean prettyPrint) {
        this.objectMapperProvider = objectMapperProvider;
        this.prettyPrint = prettyPrint;
    }

    public JsonCodecFactory prettyPrint() {
        return new JsonCodecFactory(this.objectMapperProvider, true);
    }

    public <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new JsonCodec(this.createObjectMapper(), type);
    }

    public <T> JsonCodec<T> jsonCodec(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return new JsonCodec(this.createObjectMapper(), type);
    }

    public <T> JsonCodec<T> jsonCodec(TypeToken<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new JsonCodec(this.createObjectMapper(), type.getType());
    }

    public <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new JsonCodec<List<T>>(this.createObjectMapper(), listType);
    }

    public <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new JsonCodec<List<T>>(this.createObjectMapper(), listType);
    }

    public <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new JsonCodec<Map<K, V>>(this.createObjectMapper(), mapType);
    }

    public <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new JsonCodec<Map<K, V>>(this.createObjectMapper(), mapType);
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = null;
        RuntimeException lastException = null;
        for (int i = 0; objectMapper == null && i < 10; ++i) {
            try {
                objectMapper = (ObjectMapper)this.objectMapperProvider.get();
                continue;
            }
            catch (RuntimeException e) {
                lastException = e;
            }
        }
        if (objectMapper == null) {
            throw lastException;
        }
        if (this.prettyPrint) {
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        } else {
            objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
        return objectMapper;
    }
}

