/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.CommentWrappingRule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiCommentImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\u000e\u0010\u0012\u001a\u00020\b*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\b*\u0004\u0018\u00010\u0006H\u0002J\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/CommentWrappingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isKtlintSuppressionDirective", "isWhitespaceWithNewlineOrNull", "replaceWithEndOfLineComment", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nCommentWrappingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/CommentWrappingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class CommentWrappingRule
extends StandardRule {
    public CommentWrappingRule() {
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()};
        super("comment-wrapping", null, SetsKt.setOf((Object[])objectArray), 2, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block15: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            ASTNode afterBlockComment2;
            ASTNode aSTNode3;
            ASTNode beforeBlockComment2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) break block15;
            ASTNode aSTNode4 = (ASTNode)SequencesKt.firstOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.leaves((ASTNode)node, (boolean)false), (Function1)beforeVisitChildNodes.beforeBlockComment.1.INSTANCE));
            if (aSTNode4 == null) {
                aSTNode4 = beforeBlockComment2 = ASTNodeExtensionKt.firstChildLeafOrSelf((ASTNode)node);
            }
            if ((aSTNode3 = (ASTNode)SequencesKt.firstOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.leaves$default((ASTNode)node, (boolean)false, (int)1, null), (Function1)beforeVisitChildNodes.afterBlockComment.1.INSTANCE))) == null) {
                aSTNode3 = afterBlockComment2 = ASTNodeExtensionKt.lastChildLeafOrSelf((ASTNode)node);
            }
            if (!node.textContains('\n') && !this.isKtlintSuppressionDirective(node) && this.isWhitespaceWithNewlineOrNull(ASTNodeExtensionKt.prevLeaf$default((ASTNode)beforeBlockComment2, (boolean)false, (int)1, null)) && this.isWhitespaceWithNewlineOrNull(ASTNodeExtensionKt.nextLeaf$default((ASTNode)afterBlockComment2, (boolean)false, (boolean)false, (int)3, null))) {
                emit.invoke((Object)node.getStartOffset(), (Object)"A single line block comment must be replaced with an EOL comment", (Object)true);
                if (autoCorrect) {
                    this.replaceWithEndOfLineComment(node);
                }
            }
            if (!this.isWhitespaceWithNewlineOrNull(ASTNodeExtensionKt.prevLeaf$default((ASTNode)beforeBlockComment2, (boolean)false, (int)1, null)) && !this.isWhitespaceWithNewlineOrNull(ASTNodeExtensionKt.nextLeaf$default((ASTNode)afterBlockComment2, (boolean)false, (boolean)false, (int)3, null))) {
                if (ASTNodeExtensionKt.hasNewLineInClosedRange((ASTNode)beforeBlockComment2, (ASTNode)afterBlockComment2)) {
                    emit.invoke((Object)node.getStartOffset(), (Object)"A block comment starting on same line as another element and ending on another line before another element is disallowed", (Object)false);
                } else {
                    ASTNode aSTNode5 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)beforeBlockComment2, (boolean)false, (int)1, null);
                    if (Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)ElementType.INSTANCE.getLBRACE())) {
                        ASTNode aSTNode6 = ASTNodeExtensionKt.nextLeaf$default((ASTNode)afterBlockComment2, (boolean)false, (boolean)false, (int)3, null);
                        if (Intrinsics.areEqual((Object)(aSTNode6 != null ? aSTNode6.getElementType() : null), (Object)ElementType.INSTANCE.getRBRACE())) {
                            return;
                        }
                    }
                    emit.invoke((Object)node.getStartOffset(), (Object)"A block comment in between other elements on the same line is disallowed", (Object)false);
                }
                return;
            }
            ASTNode it = aSTNode2 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)beforeBlockComment2, (boolean)false, (int)1, null);
            boolean bl = false;
            Object object = aSTNode = !this.isWhitespaceWithNewlineOrNull(it) ? aSTNode2 : null;
            if (aSTNode != null) {
                it = aSTNode;
                boolean bl2 = false;
                if (node.textContains('\n')) {
                    emit.invoke((Object)node.getStartOffset(), (Object)"A block comment after any other element on the same line must be separated by a new line", (Object)false);
                } else {
                    emit.invoke((Object)node.getStartOffset(), (Object)"A single line block comment after a code element on the same line must be replaced with an EOL comment", (Object)true);
                    if (autoCorrect) {
                        ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)node, (String)" ");
                        this.replaceWithEndOfLineComment(node);
                    }
                }
            }
            it = aSTNode2 = ASTNodeExtensionKt.nextLeaf$default((ASTNode)afterBlockComment2, (boolean)false, (boolean)false, (int)3, null);
            boolean bl3 = false;
            Object object2 = aSTNode = !this.isWhitespaceWithNewlineOrNull(it) ? aSTNode2 : null;
            if (aSTNode != null) {
                ASTNode nextLeaf2 = aSTNode;
                boolean bl4 = false;
                emit.invoke((Object)nextLeaf2.getStartOffset(), (Object)"A block comment may not be followed by any other element on that same line", (Object)true);
                if (autoCorrect) {
                    ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)nextLeaf2, (String)ASTNodeExtensionKt.indent$default((ASTNode)node, (boolean)false, (int)1, null));
                }
            }
        }
    }

    private final void replaceWithEndOfLineComment(ASTNode $this$replaceWithEndOfLineComment) {
        String string = $this$replaceWithEndOfLineComment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String content = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSurrounding((String)string, (CharSequence)"/*", (CharSequence)"*/"))).toString();
        PsiCommentImpl eolComment = new PsiCommentImpl(ElementType.INSTANCE.getEOL_COMMENT(), (CharSequence)("// " + content));
        Intrinsics.checkNotNull((Object)$this$replaceWithEndOfLineComment, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        ((LeafPsiElement)$this$replaceWithEndOfLineComment).rawInsertBeforeMe((TreeElement)eolComment);
        ((LeafPsiElement)$this$replaceWithEndOfLineComment).rawRemove();
    }

    private final boolean isWhitespaceWithNewlineOrNull(ASTNode $this$isWhitespaceWithNewlineOrNull) {
        return $this$isWhitespaceWithNewlineOrNull == null || ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)$this$isWhitespaceWithNewlineOrNull);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKtlintSuppressionDirective(ASTNode $this$isKtlintSuppressionDirective) {
        if ($this$isKtlintSuppressionDirective == null) return false;
        String string = $this$isKtlintSuppressionDirective.getText();
        if (string == null) return false;
        String string2 = StringsKt.removePrefix((String)string, (CharSequence)"/*");
        if (string2 == null) return false;
        String string3 = StringsKt.removeSuffix((String)string2, (CharSequence)"*/");
        if (string3 == null) return false;
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (string4 == null) return false;
        String it = string4;
        boolean bl = false;
        if (StringsKt.startsWith$default((String)it, (String)"ktlint-enable", (boolean)false, (int)2, null)) return true;
        if (!StringsKt.startsWith$default((String)it, (String)"ktlint-disable", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

