/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.ChainWrappingRule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016Je\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132K\u0010\u0014\u001aG\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\f\u0010\u001d\u001a\u00020\u0013*\u00020\u0011H\u0002J\f\u0010\u001e\u001a\u00020\u0013*\u00020\u0011H\u0002J\f\u0010\u001f\u001a\u00020\u0013*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ChainWrappingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "indentConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "nextLineTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "noSpaceAroundTokens", "prefixTokens", "sameLineTokens", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isElvisOperatorAndComment", "isInPrefixPosition", "isPartOfSpread", "ktlint-ruleset-standard"})
public final class ChainWrappingRule
extends StandardRule {
    @NotNull
    private final TokenSet sameLineTokens;
    @NotNull
    private final TokenSet prefixTokens;
    @NotNull
    private final TokenSet nextLineTokens;
    @NotNull
    private final TokenSet noSpaceAroundTokens;
    @NotNull
    private IndentConfig indentConfig;

    public ChainWrappingRule() {
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()};
        super("chain-wrapping", null, SetsKt.setOf((Object[])objectArray), 2, null);
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getPERC(), ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getOROR()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(MUL, DIV, PERC, ANDAND, OROR)");
        this.sameLineTokens = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getMINUS()};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(PLUS, MINUS)");
        this.prefixTokens = tokenSet2;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getELVIS()};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(DOT, SAFE_ACCESS, ELVIS)");
        this.nextLineTokens = tokenSet3;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS()};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(DOT, SAFE_ACCESS)");
        this.noSpaceAroundTokens = tokenSet4;
        this.indentConfig = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.indentConfig = new IndentConfig((PropertyType.IndentStyleValue)editorConfig.get(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)editorConfig.get(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        if (this.nextLineTokens.contains(elementType)) {
            ASTNode nextLeaf2;
            if (ASTNodeExtensionKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = ASTNodeExtensionKt.nextCodeLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            ASTNode aSTNode2 = nextLeaf2 = aSTNode != null ? ASTNodeExtensionKt.prevLeaf$default((ASTNode)aSTNode, (boolean)false, (int)1, null) : null;
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)nextLeaf2) && !this.isElvisOperatorAndComment(node)) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not end with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getELVIS())) {
                        ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)node, (String)(ASTNodeExtensionKt.indent$default((ASTNode)node, (boolean)false, (int)1, null) + this.indentConfig.getIndent()));
                        ASTNodeExtensionKt.upsertWhitespaceAfterMe((ASTNode)node, (String)" ");
                    } else {
                        node.getTreeParent().removeChild(node);
                        Intrinsics.checkNotNull((Object)nextLeaf2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                        ((LeafElement)nextLeaf2).rawInsertAfterMe((TreeElement)((LeafElement)node));
                    }
                }
            }
        } else if (this.sameLineTokens.contains(elementType) || this.prefixTokens.contains(elementType)) {
            ASTNode prevLeaf2;
            if (ASTNodeExtensionKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = prevLeaf2 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            if (!(!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || !prevLeaf2.textContains('\n') || Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getMUL()) && this.isPartOfSpread(prevLeaf2) || this.prefixTokens.contains(elementType) && this.isInPrefixPosition(node))) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not begin with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode nextLeaf3 = ASTNodeExtensionKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
                    if (nextLeaf3 instanceof PsiWhiteSpace) {
                        ((PsiWhiteSpace)nextLeaf3).getNode().getTreeParent().removeChild(((PsiWhiteSpace)nextLeaf3).getNode());
                    }
                    ASTNode aSTNode3 = ASTNodeExtensionKt.prevCodeLeaf$default((ASTNode)prevLeaf2, (boolean)false, (int)1, null);
                    Intrinsics.checkNotNull((Object)aSTNode3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    LeafPsiElement insertionPoint = (LeafPsiElement)aSTNode3;
                    ((LeafPsiElement)node).getTreeParent().removeChild(node);
                    insertionPoint.rawInsertAfterMe((TreeElement)node);
                    ASTNodeExtensionKt.upsertWhitespaceAfterMe((ASTNode)((ASTNode)insertionPoint), (String)" ");
                }
            }
        }
    }

    private final boolean isPartOfSpread(ASTNode $this$isPartOfSpread) {
        boolean bl;
        ASTNode aSTNode = ASTNodeExtensionKt.prevCodeLeaf$default((ASTNode)$this$isPartOfSpread, (boolean)false, (int)1, null);
        if (aSTNode != null) {
            ASTNode leaf = aSTNode;
            boolean bl2 = false;
            IElementType iElementType = leaf.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"leaf.elementType");
            IElementType type = iElementType;
            bl = Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLPAR()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getCOMMA()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLBRACE()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getELSE_KEYWORD()) || KtTokens.OPERATIONS.contains(type);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isInPrefixPosition(ASTNode $this$isInPrefixPosition) {
        ASTNode aSTNode = $this$isInPrefixPosition.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getPREFIX_EXPRESSION());
    }

    private final boolean isElvisOperatorAndComment(ASTNode $this$isElvisOperatorAndComment) {
        return Intrinsics.areEqual((Object)$this$isElvisOperatorAndComment.getElementType(), (Object)ElementType.INSTANCE.getELVIS()) && SequencesKt.any((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.leaves$default((ASTNode)$this$isElvisOperatorAndComment, (boolean)false, (int)1, null), (Function1)isElvisOperatorAndComment.1.INSTANCE));
    }
}

