/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules.functions;

import com.palantir.computemodules.functions.Context;
import com.palantir.computemodules.functions.Function;
import com.palantir.computemodules.functions.results.Failed;
import com.palantir.computemodules.functions.results.Ok;
import com.palantir.computemodules.functions.results.Result;
import com.palantir.computemodules.functions.serde.Deserializer;
import com.palantir.computemodules.functions.serde.Serializer;
import java.io.InputStream;

public final class FunctionRunner<I, O> {
    private final Function<I, O> function;
    private final Class<I> inputType;
    private final Class<O> outputType;
    private final Deserializer<I> deserializer;
    private final Serializer<O> serializer;

    public FunctionRunner(Function<I, O> function, Class<I> inputType, Class<O> outputType, Deserializer<I> deserializer, Serializer<O> serializer) {
        this.function = function;
        this.inputType = inputType;
        this.outputType = outputType;
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    public Result run(Context context, Object input) {
        I deserializedInput = this.deserializer.deserialize(input, this.inputType);
        try {
            O result = this.function.run(context, deserializedInput);
            if (InputStream.class.isAssignableFrom(this.outputType)) {
                return new Ok(context.jobId(), (InputStream)result);
            }
            return this.serializer.serialize(context.jobId(), result);
        }
        catch (Exception e) {
            return new Failed(context.jobId(), e);
        }
    }
}

