/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules.client.config;

import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

public final class EnvVars {
    private EnvVars() {
    }

    private static String readAsString(String envVar) {
        return Optional.ofNullable(System.getenv(envVar)).orElseThrow(() -> new RuntimeException("Required environment variable not found: " + envVar));
    }

    private record FileEnvVar(String name) implements EnvVarType
    {
        private static FileEnvVar of(String name) {
            return new FileEnvVar(name);
        }

        @Override
        public String get() {
            try {
                return Files.readString(Path.of(EnvVars.readAsString(this.name), new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file pointed to by EnvVar: " + this.name, e);
            }
        }
    }

    private record StringEnvVar(String name) implements EnvVarType
    {
        private static StringEnvVar of(String name) {
            return new StringEnvVar(name);
        }

        @Override
        public String get() {
            return EnvVars.readAsString(this.name);
        }
    }

    @Immutable
    private static sealed interface EnvVarType
    permits StringEnvVar, FileEnvVar {
        public String get();
    }

    public static enum Reserved {
        GET_JOB_URI(StringEnvVar.of("GET_JOB_URI")),
        POST_RESULT_URI(StringEnvVar.of("POST_RESULT_URI")),
        DEFAULT_CA_PATH(StringEnvVar.of("DEFAULT_CA_PATH")),
        MODULE_AUTH_TOKEN(FileEnvVar.of("MODULE_AUTH_TOKEN"));

        private final EnvVarType type;

        public String get() {
            return this.type.get();
        }

        private Reserved(EnvVarType type) {
            this.type = type;
        }
    }
}

