/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules.client;

import com.palantir.computemodules.client.Client;
import com.palantir.computemodules.client.ComputeModuleJob;
import com.palantir.computemodules.client.TaggedJobDeserializer;
import com.palantir.computemodules.client.config.EnvVars;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;

public final class ComputeModuleClient
implements Client {
    private static final SafeLogger log = SafeLoggerFactory.get(ComputeModuleClient.class);
    private final HttpClient client;
    private final HttpRequest getRequest;
    private final HttpRequest.Builder postRequest;
    private final TaggedJobDeserializer deserializer = new TaggedJobDeserializer();

    public ComputeModuleClient() {
        String moduleAuthToken = EnvVars.Reserved.MODULE_AUTH_TOKEN.get();
        this.getRequest = HttpRequest.newBuilder().uri(URI.create("http://127.0.0.1:8946/job")).header("Module-Auth-Token", moduleAuthToken).build();
        this.postRequest = HttpRequest.newBuilder().header("Module-Auth-Token", moduleAuthToken).header("Content-Type", "application/octet-stream");
        this.client = HttpClient.newBuilder().build();
    }

    @Override
    public Optional<ComputeModuleJob> getJob() {
        try {
            HttpResponse<String> response = this.client.send(this.getRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return this.deserializer.deserialize(response.body());
            }
            if (response.statusCode() == 204) {
                return Optional.empty();
            }
            log.error("Failed to request job", (Arg)SafeArg.of((String)"response", response));
            Thread.sleep(1000L);
        }
        catch (IOException e) {
            log.error("Connection error while requesting job", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to request job", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public void postResult(String jobId, InputStream result) {
        HttpRequest request = this.postRequest.copy().uri(URI.create("http://127.0.0.1:8946/results/" + jobId)).POST(HttpRequest.BodyPublishers.ofInputStream(() -> result)).build();
        try {
            this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            log.error("Failed to post result", (Arg)SafeArg.of((String)"jobId", (Object)jobId), (Throwable)e);
        }
    }
}

