/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.palantir.computemodules.client.Client;
import com.palantir.computemodules.client.ComputeModuleClient;
import com.palantir.computemodules.client.ComputeModuleJob;
import com.palantir.computemodules.functions.Context;
import com.palantir.computemodules.functions.Function;
import com.palantir.computemodules.functions.FunctionRunner;
import com.palantir.computemodules.functions.results.Failed;
import com.palantir.computemodules.functions.results.Ok;
import com.palantir.computemodules.functions.results.Result;
import com.palantir.computemodules.functions.serde.DefaultDeserializer;
import com.palantir.computemodules.functions.serde.DefaultSerializer;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ComputeModule {
    private static final SafeLogger log = SafeLoggerFactory.get(ComputeModule.class);
    private final Map<String, FunctionRunner<?, ?>> functions;
    private final Client client;
    private final ListeningExecutorService executor;

    public static ComputeModuleBuilder builder() {
        return new ComputeModuleBuilder();
    }

    public Void start() {
        while (true) {
            this.client.getJob().ifPresent(job -> {
                ListenableFuture future = this.executor.submit(() -> this.execute((ComputeModuleJob)job));
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Result>(){

                    public void onSuccess(Result result) {
                        Result result2 = result;
                        Objects.requireNonNull(result2);
                        Result result3 = result2;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ok.class, Failed.class}, (Object)result3, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Ok ok = (Ok)result3;
                                ComputeModule.this.client.postResult(ok.jobId(), ok.result());
                                break;
                            }
                            case 1: {
                                Failed failed = (Failed)result3;
                                ComputeModule.this.client.postResult(failed.jobId(), ComputeModule.this.serializeException(failed));
                            }
                        }
                    }

                    public void onFailure(Throwable throwable) {
                        Failed failed = new Failed(job.jobId(), new Exception(throwable));
                        ComputeModule.this.client.postResult(failed.jobId(), ComputeModule.this.serializeException(failed));
                    }
                }, (Executor)this.executor);
            });
        }
    }

    private Result execute(ComputeModuleJob job) {
        if (this.functions.containsKey(job.queryType())) {
            return this.functions.get(job.queryType()).run(new Context(job.jobId()), job.query());
        }
        return new Failed(job.jobId(), (Exception)new SafeRuntimeException("Requested function not found", new Arg[]{SafeArg.of((String)"requested", (Object)job.queryType()), SafeArg.of((String)"known", this.functions.keySet())}));
    }

    private InputStream serializeException(Failed failed) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8)));){
            pw.println("JobId: " + failed.jobId());
            failed.e().printStackTrace(pw);
        }
        catch (Exception e) {
            log.error("Failed to serialized exception", (Arg)SafeArg.of((String)"jobId", (Object)failed.jobId()), (Throwable)e);
            String message = "Exception serializing exception for job, check logs: " + failed.jobId();
            return new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private ComputeModule(Client client, ListeningExecutorService executor, Map<String, FunctionRunner<?, ?>> functions) {
        this.client = client;
        this.executor = executor;
        this.functions = functions;
    }

    public static final class ComputeModuleBuilder {
        private final Map<String, FunctionRunner<?, ?>> functions;
        private Optional<Client> client = Optional.empty();
        private ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newVirtualThreadPerTaskExecutor());

        private ComputeModuleBuilder() {
            this.functions = new HashMap();
        }

        public <I, O> ComputeModuleBuilder add(Function<I, O> function, Class<I> inputType, Class<O> outputType, String name) {
            this.functions.put(name, new FunctionRunner<I, O>(function, inputType, outputType, new DefaultDeserializer(), new DefaultSerializer()));
            return this;
        }

        public <I, O> ComputeModuleBuilder add(FunctionRunner<I, O> runner, String name) {
            this.functions.put(name, runner);
            return this;
        }

        public ComputeModuleBuilder withClient(Client newClient) {
            this.client = Optional.of(newClient);
            return this;
        }

        public ComputeModuleBuilder withExecutor(ExecutorService newExecutor) {
            this.executor = MoreExecutors.listeningDecorator((ExecutorService)newExecutor);
            return this;
        }

        public ComputeModule build() {
            return new ComputeModule(this.client.orElseGet(() -> new ComputeModuleClient()), this.executor, this.functions);
        }
    }
}

