/*
 * Decompiled with CFR 0.152.
 */
package com.outbrain.ci.friendly.flatten.maven.plugin;

import com.outbrain.ci.friendly.flatten.maven.plugin.VersionProvider;
import com.outbrain.ci.friendly.flatten.maven.plugin.VersionUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.plugin.AbstractScmMojo;

@Mojo(name="version", aggregator=true, requiresProject=true, requiresDirectInvocation=true, executionStrategy="once-per-session", threadSafe=true, defaultPhase=LifecyclePhase.VALIDATE)
public class VersionMojo
extends AbstractScmMojo {
    private static final String DEFAULT_PREFIX_REGEX = ".*-";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="tag.fetch", defaultValue="true")
    private Boolean tagFetch;
    @Parameter(property="command", defaultValue="git describe --abbrev=0 --tags")
    private String command;
    @Inject
    private VersionProvider versionProvider;
    @Parameter(defaultValue="${reactorProjects}", required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="file.name", defaultValue="revision.txt")
    private String fileName;
    @Parameter(property="default.tag", defaultValue="${project.artifactId}-0.0.0.1")
    private String defaultTag;
    @Parameter(property="prefix.regex", defaultValue=".*-")
    private String prefixRegex;

    public void execute() throws MojoExecutionException {
        super.execute();
        String version = this.versionProvider.getVersion(this.command);
        if (version == null || version.equals("")) {
            this.getLog().info((CharSequence)("Failed to retrieve version tag, continuing with default tag:" + this.defaultTag));
            version = this.defaultTag;
        }
        this.getLog().info((CharSequence)("Current version:" + version));
        String revision = this.removePrefix(version);
        this.getLog().info((CharSequence)("revision without prefix:" + revision));
        String nextRevision = this.incrementRevision(revision);
        this.project.getProperties().put("internal.revision", nextRevision);
        this.writeVersionToFile(nextRevision);
        this.getLog().info((CharSequence)("Next revision: " + nextRevision));
    }

    private void writeVersionToFile(String nextRevision) throws MojoExecutionException {
        File file = new File(this.fileName);
        try {
            if (!file.createNewFile()) {
                this.getLog().info((CharSequence)("Overwrite file: " + file.getAbsolutePath()));
            } else {
                this.getLog().info((CharSequence)("Write to new file: " + file.getAbsolutePath()));
            }
            Files.write(file.toPath(), Collections.singletonList(nextRevision), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private String incrementRevision(String revision) {
        String[] splitRevision = revision.split("\\.");
        Integer incremented = Integer.parseInt(splitRevision[splitRevision.length - 1]) + 1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < splitRevision.length - 1; ++i) {
            builder.append(splitRevision[i]).append(".");
        }
        builder.append(incremented);
        return builder.toString();
    }

    private String removePrefix(String prefixedVersion) throws MojoExecutionException {
        String resolvedPrefixRegex = this.prefixRegex == null ? DEFAULT_PREFIX_REGEX : this.prefixRegex;
        return VersionUtil.getVersion(prefixedVersion, resolvedPrefixRegex);
    }
}

