/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcesearch.model.ResourceType;
import com.oracle.bmc.resourcesearch.requests.GetResourceTypeRequest;
import com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetResourceTypeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetResourceTypeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetResourceTypeRequest interceptRequest(GetResourceTypeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetResourceTypeRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180409").path("resourceTypes").path(HttpUtils.encodePathSegment((String)request.getName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetResourceTypeResponse> fromResponse() {
        Function<Response, GetResourceTypeResponse> transformer = new Function<Response, GetResourceTypeResponse>(){

            public GetResourceTypeResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ResourceType.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetResourceTypeResponse.Builder builder = GetResourceTypeResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.resourceType((ResourceType)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetResourceTypeResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

