/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.queue.model.UpdateMessagesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateMessagesRequest
extends BmcRequest<UpdateMessagesDetails> {
    private String queueId;
    private UpdateMessagesDetails updateMessagesDetails;
    private String opcRequestId;

    public String getQueueId() {
        return this.queueId;
    }

    public UpdateMessagesDetails getUpdateMessagesDetails() {
        return this.updateMessagesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateMessagesDetails getBody$() {
        return this.updateMessagesDetails;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).updateMessagesDetails(this.updateMessagesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",updateMessagesDetails=").append(String.valueOf((Object)this.updateMessagesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMessagesRequest)) {
            return false;
        }
        UpdateMessagesRequest other = (UpdateMessagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals((Object)this.updateMessagesDetails, (Object)other.updateMessagesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.updateMessagesDetails == null ? 43 : this.updateMessagesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMessagesRequest, UpdateMessagesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private UpdateMessagesDetails updateMessagesDetails = null;
        private String opcRequestId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder updateMessagesDetails(UpdateMessagesDetails updateMessagesDetails) {
            this.updateMessagesDetails = updateMessagesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMessagesRequest o) {
            this.queueId(o.getQueueId());
            this.updateMessagesDetails(o.getUpdateMessagesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMessagesRequest build() {
            UpdateMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMessagesDetails body) {
            this.updateMessagesDetails(body);
            return this;
        }

        public UpdateMessagesRequest buildWithoutInvocationCallback() {
            UpdateMessagesRequest request = new UpdateMessagesRequest();
            request.queueId = this.queueId;
            request.updateMessagesDetails = this.updateMessagesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

