/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.queue.model.PurgeQueueDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PurgeQueueRequest
extends BmcRequest<PurgeQueueDetails> {
    private String queueId;
    private PurgeQueueDetails purgeQueueDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getQueueId() {
        return this.queueId;
    }

    public PurgeQueueDetails getPurgeQueueDetails() {
        return this.purgeQueueDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PurgeQueueDetails getBody$() {
        return this.purgeQueueDetails;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).purgeQueueDetails(this.purgeQueueDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",purgeQueueDetails=").append(String.valueOf((Object)this.purgeQueueDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PurgeQueueRequest)) {
            return false;
        }
        PurgeQueueRequest other = (PurgeQueueRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals((Object)this.purgeQueueDetails, (Object)other.purgeQueueDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.purgeQueueDetails == null ? 43 : this.purgeQueueDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PurgeQueueRequest, PurgeQueueDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private PurgeQueueDetails purgeQueueDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder purgeQueueDetails(PurgeQueueDetails purgeQueueDetails) {
            this.purgeQueueDetails = purgeQueueDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PurgeQueueRequest o) {
            this.queueId(o.getQueueId());
            this.purgeQueueDetails(o.getPurgeQueueDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PurgeQueueRequest build() {
            PurgeQueueRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PurgeQueueDetails body) {
            this.purgeQueueDetails(body);
            return this;
        }

        public PurgeQueueRequest buildWithoutInvocationCallback() {
            PurgeQueueRequest request = new PurgeQueueRequest();
            request.queueId = this.queueId;
            request.purgeQueueDetails = this.purgeQueueDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

