/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.queue.model.DeleteMessagesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteMessagesRequest
extends BmcRequest<DeleteMessagesDetails> {
    private String queueId;
    private DeleteMessagesDetails deleteMessagesDetails;
    private String opcRequestId;

    public String getQueueId() {
        return this.queueId;
    }

    public DeleteMessagesDetails getDeleteMessagesDetails() {
        return this.deleteMessagesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DeleteMessagesDetails getBody$() {
        return this.deleteMessagesDetails;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).deleteMessagesDetails(this.deleteMessagesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",deleteMessagesDetails=").append(String.valueOf((Object)this.deleteMessagesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteMessagesRequest)) {
            return false;
        }
        DeleteMessagesRequest other = (DeleteMessagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals((Object)this.deleteMessagesDetails, (Object)other.deleteMessagesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.deleteMessagesDetails == null ? 43 : this.deleteMessagesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteMessagesRequest, DeleteMessagesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private DeleteMessagesDetails deleteMessagesDetails = null;
        private String opcRequestId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder deleteMessagesDetails(DeleteMessagesDetails deleteMessagesDetails) {
            this.deleteMessagesDetails = deleteMessagesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteMessagesRequest o) {
            this.queueId(o.getQueueId());
            this.deleteMessagesDetails(o.getDeleteMessagesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteMessagesRequest build() {
            DeleteMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DeleteMessagesDetails body) {
            this.deleteMessagesDetails(body);
            return this;
        }

        public DeleteMessagesRequest buildWithoutInvocationCallback() {
            DeleteMessagesRequest request = new DeleteMessagesRequest();
            request.queueId = this.queueId;
            request.deleteMessagesDetails = this.deleteMessagesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

