/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.queue.model.MessageMetadata;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GetMessage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Long id;
    @JsonProperty(value="content")
    private final String content;
    @JsonProperty(value="receipt")
    private final String receipt;
    @JsonProperty(value="deliveryCount")
    private final Integer deliveryCount;
    @JsonProperty(value="visibleAfter")
    private final Date visibleAfter;
    @JsonProperty(value="expireAfter")
    private final Date expireAfter;
    @JsonProperty(value="metadata")
    private final MessageMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"id", "content", "receipt", "deliveryCount", "visibleAfter", "expireAfter", "metadata"})
    public GetMessage(Long id, String content, String receipt, Integer deliveryCount, Date visibleAfter, Date expireAfter, MessageMetadata metadata) {
        this.id = id;
        this.content = content;
        this.receipt = receipt;
        this.deliveryCount = deliveryCount;
        this.visibleAfter = visibleAfter;
        this.expireAfter = expireAfter;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public String getReceipt() {
        return this.receipt;
    }

    public Integer getDeliveryCount() {
        return this.deliveryCount;
    }

    public Date getVisibleAfter() {
        return this.visibleAfter;
    }

    public Date getExpireAfter() {
        return this.expireAfter;
    }

    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GetMessage(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", content=").append(String.valueOf(this.content));
        sb.append(", receipt=").append(String.valueOf(this.receipt));
        sb.append(", deliveryCount=").append(String.valueOf(this.deliveryCount));
        sb.append(", visibleAfter=").append(String.valueOf(this.visibleAfter));
        sb.append(", expireAfter=").append(String.valueOf(this.expireAfter));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMessage)) {
            return false;
        }
        GetMessage other = (GetMessage)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.content, other.content) && Objects.equals(this.receipt, other.receipt) && Objects.equals(this.deliveryCount, other.deliveryCount) && Objects.equals(this.visibleAfter, other.visibleAfter) && Objects.equals(this.expireAfter, other.expireAfter) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.receipt == null ? 43 : this.receipt.hashCode());
        result = result * 59 + (this.deliveryCount == null ? 43 : this.deliveryCount.hashCode());
        result = result * 59 + (this.visibleAfter == null ? 43 : this.visibleAfter.hashCode());
        result = result * 59 + (this.expireAfter == null ? 43 : this.expireAfter.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Long id;
        @JsonProperty(value="content")
        private String content;
        @JsonProperty(value="receipt")
        private String receipt;
        @JsonProperty(value="deliveryCount")
        private Integer deliveryCount;
        @JsonProperty(value="visibleAfter")
        private Date visibleAfter;
        @JsonProperty(value="expireAfter")
        private Date expireAfter;
        @JsonProperty(value="metadata")
        private MessageMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Long id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder receipt(String receipt) {
            this.receipt = receipt;
            this.__explicitlySet__.add("receipt");
            return this;
        }

        public Builder deliveryCount(Integer deliveryCount) {
            this.deliveryCount = deliveryCount;
            this.__explicitlySet__.add("deliveryCount");
            return this;
        }

        public Builder visibleAfter(Date visibleAfter) {
            this.visibleAfter = visibleAfter;
            this.__explicitlySet__.add("visibleAfter");
            return this;
        }

        public Builder expireAfter(Date expireAfter) {
            this.expireAfter = expireAfter;
            this.__explicitlySet__.add("expireAfter");
            return this;
        }

        public Builder metadata(MessageMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public GetMessage build() {
            GetMessage model = new GetMessage(this.id, this.content, this.receipt, this.deliveryCount, this.visibleAfter, this.expireAfter, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GetMessage model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("receipt")) {
                this.receipt(model.getReceipt());
            }
            if (model.wasPropertyExplicitlySet("deliveryCount")) {
                this.deliveryCount(model.getDeliveryCount());
            }
            if (model.wasPropertyExplicitlySet("visibleAfter")) {
                this.visibleAfter(model.getVisibleAfter());
            }
            if (model.wasPropertyExplicitlySet("expireAfter")) {
                this.expireAfter(model.getExpireAfter());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

