/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.queue.Queue;
import com.oracle.bmc.queue.model.ChannelCollection;
import com.oracle.bmc.queue.model.DeleteMessagesResult;
import com.oracle.bmc.queue.model.GetMessages;
import com.oracle.bmc.queue.model.PutMessages;
import com.oracle.bmc.queue.model.QueueStats;
import com.oracle.bmc.queue.model.UpdateMessagesResult;
import com.oracle.bmc.queue.model.UpdatedMessage;
import com.oracle.bmc.queue.requests.DeleteMessageRequest;
import com.oracle.bmc.queue.requests.DeleteMessagesRequest;
import com.oracle.bmc.queue.requests.GetMessagesRequest;
import com.oracle.bmc.queue.requests.GetStatsRequest;
import com.oracle.bmc.queue.requests.ListChannelsRequest;
import com.oracle.bmc.queue.requests.PutMessagesRequest;
import com.oracle.bmc.queue.requests.UpdateMessageRequest;
import com.oracle.bmc.queue.requests.UpdateMessagesRequest;
import com.oracle.bmc.queue.responses.DeleteMessageResponse;
import com.oracle.bmc.queue.responses.DeleteMessagesResponse;
import com.oracle.bmc.queue.responses.GetMessagesResponse;
import com.oracle.bmc.queue.responses.GetStatsResponse;
import com.oracle.bmc.queue.responses.ListChannelsResponse;
import com.oracle.bmc.queue.responses.PutMessagesResponse;
import com.oracle.bmc.queue.responses.UpdateMessageResponse;
import com.oracle.bmc.queue.responses.UpdateMessagesResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueClient
extends BaseSyncClient
implements Queue {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUEUE").serviceEndpointPrefix("").serviceEndpointTemplate("https://messaging.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(QueueClient.class);

    QueueClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public DeleteMessageResponse deleteMessage(DeleteMessageRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMessageReceipt(), (String)"messageReceipt must not be blank", (Object[])new Object[0]);
        return (DeleteMessageResponse)this.clientCall(request, DeleteMessageResponse::builder).logger(LOG, "deleteMessage").serviceDetails("Queue", "DeleteMessage", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/DeleteMessage").method(Method.DELETE).requestBuilder(DeleteMessageRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam(request.getMessageReceipt()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteMessageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteMessagesResponse deleteMessages(DeleteMessagesRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteMessagesDetails(), "deleteMessagesDetails is required");
        return (DeleteMessagesResponse)this.clientCall(request, DeleteMessagesResponse::builder).logger(LOG, "deleteMessages").serviceDetails("Queue", "DeleteMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/DeleteMessages").method(Method.POST).requestBuilder(DeleteMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam("actions").appendPathParam("deleteMessages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeleteMessagesResult.class, DeleteMessagesResponse.Builder::deleteMessagesResult).handleResponseHeaderString("opc-request-id", DeleteMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMessagesResponse getMessages(GetMessagesRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return (GetMessagesResponse)this.clientCall(request, GetMessagesResponse::builder).logger(LOG, "getMessages").serviceDetails("Queue", "GetMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/GetMessages").method(Method.GET).requestBuilder(GetMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendQueryParam("visibilityInSeconds", (Object)request.getVisibilityInSeconds()).appendQueryParam("timeoutInSeconds", (Object)request.getTimeoutInSeconds()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("channelFilter", (Object)request.getChannelFilter()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GetMessages.class, GetMessagesResponse.Builder::getMessages).handleResponseHeaderString("opc-request-id", GetMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetStatsResponse getStats(GetStatsRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return (GetStatsResponse)this.clientCall(request, GetStatsResponse::builder).logger(LOG, "getStats").serviceDetails("Queue", "GetStats", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/QueueStats/GetStats").method(Method.GET).requestBuilder(GetStatsRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("stats").appendQueryParam("channelId", (Object)request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(QueueStats.class, GetStatsResponse.Builder::queueStats).handleResponseHeaderString("opc-request-id", GetStatsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return (ListChannelsResponse)this.clientCall(request, ListChannelsResponse::builder).logger(LOG, "listChannels").serviceDetails("Queue", "ListChannels", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/ChannelCollection/ListChannels").method(Method.GET).requestBuilder(ListChannelsRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("channels").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("channelFilter", (Object)request.getChannelFilter()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ChannelCollection.class, ListChannelsResponse.Builder::channelCollection).handleResponseHeaderString("opc-request-id", ListChannelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListChannelsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PutMessagesResponse putMessages(PutMessagesRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutMessagesDetails(), "putMessagesDetails is required");
        return (PutMessagesResponse)this.clientCall(request, PutMessagesResponse::builder).logger(LOG, "putMessages").serviceDetails("Queue", "PutMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/PutMessage/PutMessages").method(Method.POST).requestBuilder(PutMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PutMessages.class, PutMessagesResponse.Builder::putMessages).handleResponseHeaderString("opc-request-id", PutMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateMessageResponse updateMessage(UpdateMessageRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMessageReceipt(), (String)"messageReceipt must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMessageDetails(), "updateMessageDetails is required");
        return (UpdateMessageResponse)this.clientCall(request, UpdateMessageResponse::builder).logger(LOG, "updateMessage").serviceDetails("Queue", "UpdateMessage", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/UpdatedMessage/UpdateMessage").method(Method.PUT).requestBuilder(UpdateMessageRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam(request.getMessageReceipt()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(UpdatedMessage.class, UpdateMessageResponse.Builder::updatedMessage).handleResponseHeaderString("opc-request-id", UpdateMessageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateMessagesResponse updateMessages(UpdateMessagesRequest request) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMessagesDetails(), "updateMessagesDetails is required");
        return (UpdateMessagesResponse)this.clientCall(request, UpdateMessagesResponse::builder).logger(LOG, "updateMessages").serviceDetails("Queue", "UpdateMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/UpdateMessages").method(Method.POST).requestBuilder(UpdateMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam("actions").appendPathParam("updateMessages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(UpdateMessagesResult.class, UpdateMessagesResponse.Builder::updateMessagesResult).handleResponseHeaderString("opc-request-id", UpdateMessagesResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public QueueClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)QueueClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(QueueClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)QueueClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)QueueClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)QueueClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)QueueClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QueueClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QueueClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "queue";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"queue");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public QueueClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new QueueClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

