/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.queue.QueueAdminAsync;
import com.oracle.bmc.queue.model.Queue;
import com.oracle.bmc.queue.model.QueueCollection;
import com.oracle.bmc.queue.model.WorkRequest;
import com.oracle.bmc.queue.model.WorkRequestErrorCollection;
import com.oracle.bmc.queue.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.queue.model.WorkRequestSummaryCollection;
import com.oracle.bmc.queue.requests.ChangeQueueCompartmentRequest;
import com.oracle.bmc.queue.requests.CreateQueueRequest;
import com.oracle.bmc.queue.requests.DeleteQueueRequest;
import com.oracle.bmc.queue.requests.GetQueueRequest;
import com.oracle.bmc.queue.requests.GetWorkRequestRequest;
import com.oracle.bmc.queue.requests.ListQueuesRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestsRequest;
import com.oracle.bmc.queue.requests.PurgeQueueRequest;
import com.oracle.bmc.queue.requests.UpdateQueueRequest;
import com.oracle.bmc.queue.responses.ChangeQueueCompartmentResponse;
import com.oracle.bmc.queue.responses.CreateQueueResponse;
import com.oracle.bmc.queue.responses.DeleteQueueResponse;
import com.oracle.bmc.queue.responses.GetQueueResponse;
import com.oracle.bmc.queue.responses.GetWorkRequestResponse;
import com.oracle.bmc.queue.responses.ListQueuesResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestsResponse;
import com.oracle.bmc.queue.responses.PurgeQueueResponse;
import com.oracle.bmc.queue.responses.UpdateQueueResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueAdminAsyncClient
extends BaseAsyncClient
implements QueueAdminAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUEUEADMIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://messaging.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(QueueAdminAsyncClient.class);

    QueueAdminAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeQueueCompartmentResponse> changeQueueCompartment(ChangeQueueCompartmentRequest request, AsyncHandler<ChangeQueueCompartmentRequest, ChangeQueueCompartmentResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeQueueCompartmentDetails(), "changeQueueCompartmentDetails is required");
        return this.clientCall(request, ChangeQueueCompartmentResponse::builder).logger(LOG, "changeQueueCompartment").serviceDetails("QueueAdmin", "ChangeQueueCompartment", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/Queue/ChangeQueueCompartment").method(Method.POST).requestBuilder(ChangeQueueCompartmentRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeQueueCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeQueueCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateQueueResponse> createQueue(CreateQueueRequest request, AsyncHandler<CreateQueueRequest, CreateQueueResponse> handler) {
        Objects.requireNonNull(request.getCreateQueueDetails(), "createQueueDetails is required");
        return this.clientCall(request, CreateQueueResponse::builder).logger(LOG, "createQueue").serviceDetails("QueueAdmin", "CreateQueue", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/Queue/CreateQueue").method(Method.POST).requestBuilder(CreateQueueRequest::builder).basePath("/20210201").appendPathParam("queues").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateQueueResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateQueueResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteQueueResponse> deleteQueue(DeleteQueueRequest request, AsyncHandler<DeleteQueueRequest, DeleteQueueResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteQueueResponse::builder).logger(LOG, "deleteQueue").serviceDetails("QueueAdmin", "DeleteQueue", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/Queue/DeleteQueue").method(Method.DELETE).requestBuilder(DeleteQueueRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteQueueResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteQueueResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetQueueResponse> getQueue(GetQueueRequest request, AsyncHandler<GetQueueRequest, GetQueueResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetQueueResponse::builder).logger(LOG, "getQueue").serviceDetails("QueueAdmin", "GetQueue", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/Queue/GetQueue").method(Method.GET).requestBuilder(GetQueueRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Queue.class, GetQueueResponse.Builder::queue).handleResponseHeaderString("etag", GetQueueResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetQueueResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("QueueAdmin", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210201").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListQueuesResponse> listQueues(ListQueuesRequest request, AsyncHandler<ListQueuesRequest, ListQueuesResponse> handler) {
        return this.clientCall(request, ListQueuesResponse::builder).logger(LOG, "listQueues").serviceDetails("QueueAdmin", "ListQueues", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/QueueCollection/ListQueues").method(Method.GET).requestBuilder(ListQueuesRequest::builder).basePath("/20210201").appendPathParam("queues").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueueCollection.class, ListQueuesResponse.Builder::queueCollection).handleResponseHeaderString("opc-request-id", ListQueuesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListQueuesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("QueueAdmin", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210201").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("QueueAdmin", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210201").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("QueueAdmin", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210201").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PurgeQueueResponse> purgeQueue(PurgeQueueRequest request, AsyncHandler<PurgeQueueRequest, PurgeQueueResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPurgeQueueDetails(), "purgeQueueDetails is required");
        return this.clientCall(request, PurgeQueueResponse::builder).logger(LOG, "purgeQueue").serviceDetails("QueueAdmin", "PurgeQueue", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/Queue/PurgeQueue").method(Method.POST).requestBuilder(PurgeQueueRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("actions").appendPathParam("purge").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", PurgeQueueResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PurgeQueueResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateQueueResponse> updateQueue(UpdateQueueRequest request, AsyncHandler<UpdateQueueRequest, UpdateQueueResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateQueueDetails(), "updateQueueDetails is required");
        return this.clientCall(request, UpdateQueueResponse::builder).logger(LOG, "updateQueue").serviceDetails("QueueAdmin", "UpdateQueue", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/Queue/UpdateQueue").method(Method.PUT).requestBuilder(UpdateQueueRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateQueueResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateQueueResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public QueueAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)QueueAdminAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(QueueAdminAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)QueueAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)QueueAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)QueueAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)QueueAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QueueAdminAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QueueAdminAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "queue";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"queue");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public QueueAdminAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new QueueAdminAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

