/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VolumeMount
extends ExplicitlySetBmcModel {
    @JsonProperty(value="mountPath")
    private final String mountPath;
    @JsonProperty(value="volumeName")
    private final String volumeName;
    @JsonProperty(value="subPath")
    private final String subPath;
    @JsonProperty(value="isReadOnly")
    private final Boolean isReadOnly;
    @JsonProperty(value="partition")
    private final Integer partition;

    @Deprecated
    @ConstructorProperties(value={"mountPath", "volumeName", "subPath", "isReadOnly", "partition"})
    public VolumeMount(String mountPath, String volumeName, String subPath, Boolean isReadOnly, Integer partition) {
        this.mountPath = mountPath;
        this.volumeName = volumeName;
        this.subPath = subPath;
        this.isReadOnly = isReadOnly;
        this.partition = partition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VolumeMount(");
        sb.append("super=").append(super.toString());
        sb.append("mountPath=").append(String.valueOf(this.mountPath));
        sb.append(", volumeName=").append(String.valueOf(this.volumeName));
        sb.append(", subPath=").append(String.valueOf(this.subPath));
        sb.append(", isReadOnly=").append(String.valueOf(this.isReadOnly));
        sb.append(", partition=").append(String.valueOf(this.partition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VolumeMount)) {
            return false;
        }
        VolumeMount other = (VolumeMount)((Object)o);
        return Objects.equals(this.mountPath, other.mountPath) && Objects.equals(this.volumeName, other.volumeName) && Objects.equals(this.subPath, other.subPath) && Objects.equals(this.isReadOnly, other.isReadOnly) && Objects.equals(this.partition, other.partition) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mountPath == null ? 43 : this.mountPath.hashCode());
        result = result * 59 + (this.volumeName == null ? 43 : this.volumeName.hashCode());
        result = result * 59 + (this.subPath == null ? 43 : this.subPath.hashCode());
        result = result * 59 + (this.isReadOnly == null ? 43 : this.isReadOnly.hashCode());
        result = result * 59 + (this.partition == null ? 43 : this.partition.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mountPath")
        private String mountPath;
        @JsonProperty(value="volumeName")
        private String volumeName;
        @JsonProperty(value="subPath")
        private String subPath;
        @JsonProperty(value="isReadOnly")
        private Boolean isReadOnly;
        @JsonProperty(value="partition")
        private Integer partition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            this.__explicitlySet__.add("mountPath");
            return this;
        }

        public Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            this.__explicitlySet__.add("volumeName");
            return this;
        }

        public Builder subPath(String subPath) {
            this.subPath = subPath;
            this.__explicitlySet__.add("subPath");
            return this;
        }

        public Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            this.__explicitlySet__.add("isReadOnly");
            return this;
        }

        public Builder partition(Integer partition) {
            this.partition = partition;
            this.__explicitlySet__.add("partition");
            return this;
        }

        public VolumeMount build() {
            VolumeMount model = new VolumeMount(this.mountPath, this.volumeName, this.subPath, this.isReadOnly, this.partition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VolumeMount model) {
            if (model.wasPropertyExplicitlySet("mountPath")) {
                this.mountPath(model.getMountPath());
            }
            if (model.wasPropertyExplicitlySet("volumeName")) {
                this.volumeName(model.getVolumeName());
            }
            if (model.wasPropertyExplicitlySet("subPath")) {
                this.subPath(model.getSubPath());
            }
            if (model.wasPropertyExplicitlySet("isReadOnly")) {
                this.isReadOnly(model.getIsReadOnly());
            }
            if (model.wasPropertyExplicitlySet("partition")) {
                this.partition(model.getPartition());
            }
            return this;
        }
    }
}

