/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances;

import com.oracle.bmc.containerinstances.ContainerInstance;
import com.oracle.bmc.containerinstances.model.Container;
import com.oracle.bmc.containerinstances.model.ContainerInstance;
import com.oracle.bmc.containerinstances.requests.GetContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerRequest;
import com.oracle.bmc.containerinstances.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerinstances.responses.GetContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerResponse;
import com.oracle.bmc.containerinstances.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ContainerInstanceWaiters {
    private final ExecutorService executorService;
    private final ContainerInstance client;

    public ContainerInstanceWaiters(ExecutorService executorService, ContainerInstance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetContainerRequest, GetContainerResponse> forContainer(GetContainerRequest request, Container.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainer(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerRequest, GetContainerResponse> forContainer(GetContainerRequest request, Container.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainer(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerRequest, GetContainerResponse> forContainer(GetContainerRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Container.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainer(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerRequest, GetContainerResponse> forContainer(BmcGenericWaiter waiter, GetContainerRequest request, Container.LifecycleState ... targetStates) {
        final HashSet<Container.LifecycleState> targetStatesSet = new HashSet<Container.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerRequest, GetContainerResponse>(){

            @Override
            public GetContainerResponse apply(GetContainerRequest request) {
                return ContainerInstanceWaiters.this.client.getContainer(request);
            }
        }, (Predicate)new Predicate<GetContainerResponse>(){

            @Override
            public boolean test(GetContainerResponse response) {
                return targetStatesSet.contains((Object)response.getContainer().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Container.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetContainerInstanceRequest, GetContainerInstanceResponse> forContainerInstance(GetContainerInstanceRequest request, ContainerInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerInstanceRequest, GetContainerInstanceResponse> forContainerInstance(GetContainerInstanceRequest request, ContainerInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerInstanceRequest, GetContainerInstanceResponse> forContainerInstance(GetContainerInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ContainerInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainerInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerInstanceRequest, GetContainerInstanceResponse> forContainerInstance(BmcGenericWaiter waiter, GetContainerInstanceRequest request, ContainerInstance.LifecycleState ... targetStates) {
        final HashSet<ContainerInstance.LifecycleState> targetStatesSet = new HashSet<ContainerInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerInstanceRequest, GetContainerInstanceResponse>(){

            @Override
            public GetContainerInstanceResponse apply(GetContainerInstanceRequest request) {
                return ContainerInstanceWaiters.this.client.getContainerInstance(request);
            }
        }, (Predicate)new Predicate<GetContainerInstanceResponse>(){

            @Override
            public boolean test(GetContainerInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getContainerInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ContainerInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ContainerInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

