/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.containerinstances.ContainerInstance;
import com.oracle.bmc.containerinstances.ContainerInstancePaginators;
import com.oracle.bmc.containerinstances.ContainerInstanceWaiters;
import com.oracle.bmc.containerinstances.model.Container;
import com.oracle.bmc.containerinstances.model.ContainerCollection;
import com.oracle.bmc.containerinstances.model.ContainerInstanceCollection;
import com.oracle.bmc.containerinstances.model.ContainerInstanceShapeCollection;
import com.oracle.bmc.containerinstances.model.WorkRequest;
import com.oracle.bmc.containerinstances.model.WorkRequestErrorCollection;
import com.oracle.bmc.containerinstances.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.containerinstances.model.WorkRequestSummaryCollection;
import com.oracle.bmc.containerinstances.requests.ChangeContainerInstanceCompartmentRequest;
import com.oracle.bmc.containerinstances.requests.CreateContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.DeleteContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.GetContainerRequest;
import com.oracle.bmc.containerinstances.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstanceShapesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainerInstancesRequest;
import com.oracle.bmc.containerinstances.requests.ListContainersRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerinstances.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerinstances.requests.RestartContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.RetrieveLogsRequest;
import com.oracle.bmc.containerinstances.requests.StartContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.StopContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.UpdateContainerInstanceRequest;
import com.oracle.bmc.containerinstances.requests.UpdateContainerRequest;
import com.oracle.bmc.containerinstances.responses.ChangeContainerInstanceCompartmentResponse;
import com.oracle.bmc.containerinstances.responses.CreateContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.DeleteContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.GetContainerResponse;
import com.oracle.bmc.containerinstances.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstanceShapesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainerInstancesResponse;
import com.oracle.bmc.containerinstances.responses.ListContainersResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerinstances.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerinstances.responses.RestartContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.RetrieveLogsResponse;
import com.oracle.bmc.containerinstances.responses.StartContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.StopContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.UpdateContainerInstanceResponse;
import com.oracle.bmc.containerinstances.responses.UpdateContainerResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerInstanceClient
extends BaseSyncClient
implements ContainerInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONTAINERINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://compute-containers.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ContainerInstanceClient.class);
    private final ContainerInstanceWaiters waiters;
    private final ContainerInstancePaginators paginators;

    ContainerInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    ContainerInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ContainerInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ContainerInstanceWaiters(executorService, this);
        this.paginators = new ContainerInstancePaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ContainerInstanceClient", (String)"retrieveLogs"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeContainerInstanceCompartmentResponse changeContainerInstanceCompartment(ChangeContainerInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeContainerInstanceCompartmentDetails(), "changeContainerInstanceCompartmentDetails is required");
        return (ChangeContainerInstanceCompartmentResponse)this.clientCall(request, ChangeContainerInstanceCompartmentResponse::builder).logger(LOG, "changeContainerInstanceCompartment").serviceDetails("ContainerInstance", "ChangeContainerInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/ChangeContainerInstanceCompartment").method(Method.POST).requestBuilder(ChangeContainerInstanceCompartmentRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeContainerInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeContainerInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateContainerInstanceResponse createContainerInstance(CreateContainerInstanceRequest request) {
        Objects.requireNonNull(request.getCreateContainerInstanceDetails(), "createContainerInstanceDetails is required");
        return (CreateContainerInstanceResponse)this.clientCall(request, CreateContainerInstanceResponse::builder).logger(LOG, "createContainerInstance").serviceDetails("ContainerInstance", "CreateContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/CreateContainerInstance").method(Method.POST).requestBuilder(CreateContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.containerinstances.model.ContainerInstance.class, CreateContainerInstanceResponse.Builder::containerInstance).handleResponseHeaderString("etag", CreateContainerInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteContainerInstanceResponse deleteContainerInstance(DeleteContainerInstanceRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteContainerInstanceResponse)this.clientCall(request, DeleteContainerInstanceResponse::builder).logger(LOG, "deleteContainerInstance").serviceDetails("ContainerInstance", "DeleteContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/DeleteContainerInstance").method(Method.DELETE).requestBuilder(DeleteContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetContainerResponse getContainer(GetContainerRequest request) {
        Validate.notBlank((String)request.getContainerId(), (String)"containerId must not be blank", (Object[])new Object[0]);
        return (GetContainerResponse)this.clientCall(request, GetContainerResponse::builder).logger(LOG, "getContainer").serviceDetails("ContainerInstance", "GetContainer", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/Container/GetContainer").method(Method.GET).requestBuilder(GetContainerRequest::builder).basePath("/20210415").appendPathParam("containers").appendPathParam(request.getContainerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Container.class, GetContainerResponse.Builder::container).handleResponseHeaderString("etag", GetContainerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetContainerInstanceResponse getContainerInstance(GetContainerInstanceRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return (GetContainerInstanceResponse)this.clientCall(request, GetContainerInstanceResponse::builder).logger(LOG, "getContainerInstance").serviceDetails("ContainerInstance", "GetContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/GetContainerInstance").method(Method.GET).requestBuilder(GetContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.containerinstances.model.ContainerInstance.class, GetContainerInstanceResponse.Builder::containerInstance).handleResponseHeaderString("etag", GetContainerInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ContainerInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListContainerInstanceShapesResponse listContainerInstanceShapes(ListContainerInstanceShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListContainerInstanceShapesResponse)this.clientCall(request, ListContainerInstanceShapesResponse::builder).logger(LOG, "listContainerInstanceShapes").serviceDetails("ContainerInstance", "ListContainerInstanceShapes", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstanceShapeCollection/ListContainerInstanceShapes").method(Method.GET).requestBuilder(ListContainerInstanceShapesRequest::builder).basePath("/20210415").appendPathParam("containerInstanceShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ContainerInstanceShapeCollection.class, ListContainerInstanceShapesResponse.Builder::containerInstanceShapeCollection).handleResponseHeaderString("opc-request-id", ListContainerInstanceShapesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerInstanceShapesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListContainerInstancesResponse listContainerInstances(ListContainerInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListContainerInstancesResponse)this.clientCall(request, ListContainerInstancesResponse::builder).logger(LOG, "listContainerInstances").serviceDetails("ContainerInstance", "ListContainerInstances", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstanceCollection/ListContainerInstances").method(Method.GET).requestBuilder(ListContainerInstancesRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ContainerInstanceCollection.class, ListContainerInstancesResponse.Builder::containerInstanceCollection).handleResponseHeaderString("opc-request-id", ListContainerInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerInstancesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListContainersResponse listContainers(ListContainersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListContainersResponse)this.clientCall(request, ListContainersResponse::builder).logger(LOG, "listContainers").serviceDetails("ContainerInstance", "ListContainers", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerCollection/ListContainers").method(Method.GET).requestBuilder(ListContainersRequest::builder).basePath("/20210415").appendPathParam("containers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("containerInstanceId", (Object)request.getContainerInstanceId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ContainerCollection.class, ListContainersResponse.Builder::containerCollection).handleResponseHeaderString("opc-request-id", ListContainersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ContainerInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ContainerInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ContainerInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210415").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("resourceId", (Object)request.getResourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RestartContainerInstanceResponse restartContainerInstance(RestartContainerInstanceRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return (RestartContainerInstanceResponse)this.clientCall(request, RestartContainerInstanceResponse::builder).logger(LOG, "restartContainerInstance").serviceDetails("ContainerInstance", "RestartContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/RestartContainerInstance").method(Method.POST).requestBuilder(RestartContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", RestartContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RestartContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RetrieveLogsResponse retrieveLogs(RetrieveLogsRequest request) {
        Validate.notBlank((String)request.getContainerId(), (String)"containerId must not be blank", (Object[])new Object[0]);
        return (RetrieveLogsResponse)this.clientCall(request, RetrieveLogsResponse::builder).logger(LOG, "retrieveLogs").serviceDetails("ContainerInstance", "RetrieveLogs", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/Container/RetrieveLogs").method(Method.POST).requestBuilder(RetrieveLogsRequest::builder).basePath("/20210415").appendPathParam("containers").appendPathParam(request.getContainerId()).appendPathParam("actions").appendPathParam("retrieveLogs").accept(new String[]{"application/json", "text/plain"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, RetrieveLogsResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", RetrieveLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StartContainerInstanceResponse startContainerInstance(StartContainerInstanceRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return (StartContainerInstanceResponse)this.clientCall(request, StartContainerInstanceResponse::builder).logger(LOG, "startContainerInstance").serviceDetails("ContainerInstance", "StartContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/StartContainerInstance").method(Method.POST).requestBuilder(StartContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", StartContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopContainerInstanceResponse stopContainerInstance(StopContainerInstanceRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        return (StopContainerInstanceResponse)this.clientCall(request, StopContainerInstanceResponse::builder).logger(LOG, "stopContainerInstance").serviceDetails("ContainerInstance", "StopContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/StopContainerInstance").method(Method.POST).requestBuilder(StopContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", StopContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateContainerResponse updateContainer(UpdateContainerRequest request) {
        Validate.notBlank((String)request.getContainerId(), (String)"containerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerDetails(), "updateContainerDetails is required");
        return (UpdateContainerResponse)this.clientCall(request, UpdateContainerResponse::builder).logger(LOG, "updateContainer").serviceDetails("ContainerInstance", "UpdateContainer", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/Container/UpdateContainer").method(Method.PUT).requestBuilder(UpdateContainerRequest::builder).basePath("/20210415").appendPathParam("containers").appendPathParam(request.getContainerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateContainerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateContainerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateContainerInstanceResponse updateContainerInstance(UpdateContainerInstanceRequest request) {
        Validate.notBlank((String)request.getContainerInstanceId(), (String)"containerInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerInstanceDetails(), "updateContainerInstanceDetails is required");
        return (UpdateContainerInstanceResponse)this.clientCall(request, UpdateContainerInstanceResponse::builder).logger(LOG, "updateContainerInstance").serviceDetails("ContainerInstance", "UpdateContainerInstance", "https://docs.oracle.com/iaas/api/#/en/container-instances/20210415/ContainerInstance/UpdateContainerInstance").method(Method.PUT).requestBuilder(UpdateContainerInstanceRequest::builder).basePath("/20210415").appendPathParam("containerInstances").appendPathParam(request.getContainerInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateContainerInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateContainerInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ContainerInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ContainerInstancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ContainerInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ContainerInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ContainerInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ContainerInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ContainerInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ContainerInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ContainerInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ContainerInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ContainerInstanceClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "containerinstances";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"containerinstances");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ContainerInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ContainerInstanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

