/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetJAEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterJAEUC";
    static final transient short MAX_7BIT = 127;
    static final transient short LEADINGCODE = 143;
    static Class m_charConvSuperclass;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    CharacterSetJAEUC(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSetJAEUC getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 2) {
            return new CharacterSetJAEUC(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 127) {
            if (n2 != 143) {
                if (characterWalker.bytes.length > characterWalker.next) {
                    n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                    ++characterWalker.next;
                }
            } else {
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (characterWalker.bytes.length <= characterWalker.next) continue;
                    n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                    ++characterWalker.next;
                }
            }
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = 0;
        int n4 = 1;
        while (n2 >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        CharacterSetJAEUC.need(characterBuffer, n4);
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = CharacterSetJAEUC.class.getDeclaredConstructor(Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetJAEUC.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetJAEUC.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetJAEUC.class.getDeclaredMethod("getInstance", Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

