/*
 * Decompiled with CFR 0.152.
 */
package oracle.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import oracle.jdbc.logging.annotations.DisableTrace;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@DisableTrace
@AutomaticFeature
final class NativeImageFeature
implements Feature {
    private ResourcesRegistry resourcesRegistry;

    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        Class clazz;
        Class clazz2 = beforeAnalysisAccess.findClassByName("oracle.i18n.text.converter.CharacterConverterOGS");
        if (clazz2 != null) {
            this.initializeAtBuildTime(beforeAnalysisAccess, "oracle.i18n.text.converter.CharacterConverterOGS");
            this.initializeAtBuildTime(beforeAnalysisAccess, "oracle.i18n.text.converter.CharacterConverterSJIS");
            this.initializeAtBuildTime(beforeAnalysisAccess, "oracle.i18n.text.converter.CharacterConverter12Byte");
        }
        if ((clazz = beforeAnalysisAccess.findClassByName("oracle.xml.jaxp.JXSAXParserFactory")) != null) {
            this.getResourceRegistry().addResourceBundles("oracle.xml.mesg.XMLResourceBundle");
        }
    }

    private void initializeAtBuildTime(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{clazz});
        }
    }

    private void registerAll(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        this.registerClass(beforeAnalysisAccess, string);
        this.registerAllConstructor(beforeAnalysisAccess, string);
        this.registerAllMethods(beforeAnalysisAccess, string);
        this.registerAllFields(beforeAnalysisAccess, string);
    }

    private void registerClass(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
    }

    private void registerAllConstructor(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{constructor});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            for (Method method : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
        }
    }

    private void registerAllFields(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            for (Field field : clazz.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{field});
            }
        }
    }

    private ResourcesRegistry getResourceRegistry() {
        if (this.resourcesRegistry == null) {
            this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        }
        return this.resourcesRegistry;
    }
}

