/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.xa.client.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAConnection
extends oracle.jdbc.xa.OracleXAConnection {
    protected boolean isXAResourceTransLoose = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public OracleXAConnection() throws XAException {
    }

    public OracleXAConnection(Connection connection) throws XAException {
        super(connection);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            try {
                if (this.xaResource == null) {
                    this.xaResource = new OracleXAResource(this.physicalConn, this);
                    ((OracleXAResource)this.xaResource).isTransLoose = this.isXAResourceTransLoose;
                    if (this.logicalHandle != null) {
                        ((oracle.jdbc.xa.OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                    }
                }
            }
            catch (XAException xAException) {
                this.xaResource = null;
                if (xAException.getCause() instanceof SQLException) {
                    throw (SQLException)xAException.getCause();
                }
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xAException);
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = OracleXAConnection.class.getDeclaredConstructor(Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAConnection.class.getDeclaredMethod("getXAResource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

