/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXid
implements Xid,
Serializable {
    private int formatId;
    private byte[] gtrid = null;
    private byte[] bqual = null;
    private byte[] txctx = null;
    private int m_hashCode = 0;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private int state;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public OracleXid(int n2, byte[] byArray, byte[] byArray2) throws XAException {
        this(n2, byArray, byArray2, null);
    }

    public OracleXid(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws XAException {
        this.formatId = n2;
        if (byArray != null && byArray.length > 64) {
            throw (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
        }
        this.gtrid = byArray;
        if (byArray2 != null && byArray2.length > 64) {
            throw (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
        }
        this.bqual = byArray2;
        this.txctx = byArray3;
        this.state = 0;
        this.m_hashCode = this.computeHashCode();
    }

    public void setState(int n2) {
        this.state = n2;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public byte[] getTxContext() {
        return this.txctx;
    }

    public void setTxContext(byte[] byArray) {
        this.txctx = byArray;
    }

    public static final boolean isLocalTransaction(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        if (byArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) continue;
            return false;
        }
        return true;
    }

    @DefaultLevel(value=Logging.FINEST)
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)object;
        return this.getFormatId() == xid.getFormatId() && Arrays.equals(this.getGlobalTransactionId(), xid.getGlobalTransactionId()) && Arrays.equals(this.getBranchQualifier(), xid.getBranchQualifier());
    }

    @DisableTrace
    public int hashCode() {
        return this.m_hashCode;
    }

    private int computeHashCode() {
        int n2;
        int n3 = 0;
        byte[] byArray = this.getGlobalTransactionId();
        byte[] byArray2 = this.getBranchQualifier();
        n3 += this.getFormatId();
        if (byArray == null) {
            n3 += 0;
        } else {
            for (n2 = 0; n2 < byArray.length; ++n2) {
                n3 += byArray[n2];
            }
        }
        if (byArray2 == null) {
            n3 += 0;
        } else {
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                n3 += byArray2[n2];
            }
        }
        return n3;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$12 = OracleXid.class.getDeclaredConstructor(Integer.TYPE, byte[].class, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXid.class.getDeclaredConstructor(Integer.TYPE, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXid.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXid.class.getDeclaredMethod("computeHashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXid.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXid.class.getDeclaredMethod("isLocalTransaction", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXid.class.getDeclaredMethod("setTxContext", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXid.class.getDeclaredMethod("getTxContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXid.class.getDeclaredMethod("getBranchQualifier", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXid.class.getDeclaredMethod("getGlobalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXid.class.getDeclaredMethod("getFormatId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXid.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXid.class.getDeclaredMethod("setState", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

