/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.RAW;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonBinaryImpl
implements OracleJsonBinary {
    protected static final char[] HEX_UPPER;
    protected static final char[] HEX_LOWER;
    private byte[] bytes;
    boolean isId;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleJsonBinaryImpl(byte[] byArray, boolean bl) {
        this.bytes = byArray;
        this.isId = bl;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.BINARY;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonBinary)) {
            return false;
        }
        OracleJsonBinary oracleJsonBinary = (OracleJsonBinary)object;
        byte[] byArray = this.getBytes();
        byte[] byArray2 = oracleJsonBinary.getBytes();
        return Arrays.equals(byArray, byArray2);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getString() {
        return OracleJsonBinaryImpl.getString(this.bytes, this.isId);
    }

    public static String getString(byte[] byArray, boolean bl) {
        return new String(OracleJsonBinaryImpl.serializeBinary(byArray, bl ? HEX_LOWER : HEX_UPPER));
    }

    @Override
    public RAW getRAW() {
        return new RAW(this.getBytes());
    }

    private static char[] serializeBinary(byte[] byArray, char[] cArray) {
        char[] cArray2 = new char[byArray.length * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2++];
            cArray2[n3++] = cArray[by >> 4 & 0xF];
            cArray2[n3++] = cArray[by & 0xF];
        }
        return cArray2;
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        if (Jsonp.isJakartaJson(clazz)) {
            return clazz.cast(new JakartaPrimitive.JakartaBinaryImpl(this.bytes, this.isId));
        }
        return clazz.cast(new JsonpPrimitive.JsonpBinaryImpl(this.bytes, this.isId));
    }

    static {
        try {
            $$$methodRef$$$11 = OracleJsonBinaryImpl.class.getDeclaredConstructor(byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJsonBinaryImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJsonBinaryImpl.class.getDeclaredMethod("serializeBinary", byte[].class, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJsonBinaryImpl.class.getDeclaredMethod("getRAW", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonBinaryImpl.class.getDeclaredMethod("getString", byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonBinaryImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonBinaryImpl.class.getDeclaredMethod("getBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonBinaryImpl.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonBinaryImpl.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonBinaryImpl.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonBinaryImpl.class.getDeclaredMethod("isId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonBinaryImpl.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        HEX_UPPER = "0123456789ABCDEF".toCharArray();
        HEX_LOWER = "0123456789abcdef".toCharArray();
    }
}

