/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C7Oversion
extends T4CTTIfun {
    static final long VSN_BANNER_FORMAT_BASE = 0L;
    static final long VSN_BANNER_FORMAT_FULL = 1L;
    byte[] rdbmsVersion = new byte[]{78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116};
    private final boolean rdbmsVersionO2U = true;
    private final int bufLen = 256;
    private final boolean retVerLenO2U = true;
    int retVerLen = 0;
    private final boolean retVerNumO2U = true;
    long retVerNum = 0L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    T4C7Oversion(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)59);
    }

    void doOVERSION() throws SQLException, IOException {
        this.doRPC();
    }

    final CompletionStage<Void> doOVERSIONAsync() {
        return this.doRPCAsync();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.retVerLen = this.meg.unmarshalUB2();
        this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
        this.retVerNum = this.meg.unmarshalUB4();
    }

    @Override
    void processRPA() throws SQLException {
        if (this.rdbmsVersion == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
        }
    }

    byte[] getVersion() {
        return this.rdbmsVersion;
    }

    private static final int serverReleaseRel(long l2) {
        return (int)(l2 >>> 24 & 0xFFL);
    }

    private static final int serverReleaseRelUpd(long l2) {
        int n2 = T4C7Oversion.serverReleaseRel(l2) < 18 ? (int)(l2 >>> 20 & 0xFL) : (int)(l2 >>> 16 & 0xFFL);
        return n2;
    }

    private static final int serverReleaseRelUpdRev(long l2) {
        int n2 = T4C7Oversion.serverReleaseRel(l2) < 18 ? (int)(l2 >>> 12 & 0xFFL) : (int)(l2 >>> 12 & 0xFL);
        return n2;
    }

    private static final int serverReleaseRelUpdInc(long l2) {
        int n2 = T4C7Oversion.serverReleaseRel(l2) < 18 ? (int)(l2 >>> 8 & 0xFL) : (int)(l2 >>> 4 & 0xFFL);
        return n2;
    }

    short getVersionNumber() {
        int n2 = 0;
        if ((n2 += T4C7Oversion.serverReleaseRel(this.retVerNum) * 1000) < 18000) {
            n2 += T4C7Oversion.serverReleaseRelUpd(this.retVerNum) * 100;
        }
        return (short)n2;
    }

    long getVersionNumberasIs() {
        return this.retVerNum;
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalO2U(true);
        this.meg.marshalSWORD(256);
        this.meg.marshalO2U(true);
        this.meg.marshalO2U(true);
        if (this.connection.getTTCVersion() >= 11) {
            this.meg.marshalUB4(1L);
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    static {
        try {
            $$$methodRef$$$13 = T4C7Oversion.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4C7Oversion.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4C7Oversion.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4C7Oversion.class.getDeclaredMethod("getVersionNumberasIs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4C7Oversion.class.getDeclaredMethod("getVersionNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4C7Oversion.class.getDeclaredMethod("serverReleaseRelUpdInc", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4C7Oversion.class.getDeclaredMethod("serverReleaseRelUpdRev", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4C7Oversion.class.getDeclaredMethod("serverReleaseRelUpd", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4C7Oversion.class.getDeclaredMethod("serverReleaseRel", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4C7Oversion.class.getDeclaredMethod("getVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4C7Oversion.class.getDeclaredMethod("processRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4C7Oversion.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4C7Oversion.class.getDeclaredMethod("doOVERSIONAsync", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4C7Oversion.class.getDeclaredMethod("doOVERSION", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

