/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalConnectionPoolStatisticsImpl;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.tuners.PoolSizeTuner;
import oracle.ucp.util.UCPErrorHandler;

public class UniversalConnectionPoolImpl
extends UniversalConnectionPoolBase {
    static final String CLASS_NAME = UniversalConnectionPoolImpl.class.getName();
    private boolean isNoWaitBorrow = false;
    private static final long WAITING_INTERVAL_ON_BORROW_SEMAPHORE = 200L;
    private static final long WAITING_INTERVAL_ON_BORROW_SEMAPHORE_FOR_LABELED_REQUEST = 100L;
    private static final long BETTER_COST_REATTEMPT_TIMEOUT = 100L;

    public UniversalConnectionPoolImpl(ConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
    }

    public UniversalConnectionPoolImpl(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public CompletionStage<UniversalPooledConnection> borrowConnectionAsync(ConnectionRetrievalInfo connectionRetrievalInfo, Executor executor) {
        try {
            void executor2;
            JDBCConnectionRetrievalInfo jdbcCri;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "borrowConnectionAsync", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, executor);
            CompletableFuture<UniversalPooledConnection> cf = new CompletableFuture<UniversalPooledConnection>();
            if (Objects.isNull(cri)) {
                UniversalConnectionPoolException e = UCPErrorHandler.newUniversalConnectionPoolException(203);
                this.trace(Level.WARNING, CLASS_NAME, "borrowConnectionAsync", "", null, e, new Object[0]);
                cf.completeExceptionally(e);
                CompletableFuture<UniversalPooledConnection> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "borrowConnectionAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            PoolSizeTuner.trigger();
            Object criCopy = cri instanceof JDBCConnectionRetrievalInfo ? (Objects.isNull((jdbcCri = (JDBCConnectionRetrievalInfo)cri).getServiceName()) ? jdbcCri.getCopyWithService(this.getServiceName()) : cri) : cri;
            this.pendingRequestsCount.increment();
            this.borrowConnectionAndLabelingSearchAsync((ConnectionRetrievalInfo)criCopy, (Executor)executor2).whenCompleteAsync((arg_0, arg_1) -> this.lambda$borrowConnectionAsync$0(cf, (ConnectionRetrievalInfo)criCopy, arg_0, arg_1), (Executor)executor2);
            CompletableFuture<UniversalPooledConnection> completableFuture = cf;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "borrowConnectionAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "borrowConnectionAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        JDBCConnectionRetrievalInfo jdbcCri;
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        PoolSizeTuner.trigger();
        ConnectionRetrievalInfo criCopy = connectionRetrievalInfo;
        if (this.isOraclePool() && connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo && (jdbcCri = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo).getServiceName() == null) {
            criCopy = jdbcCri.getCopyWithService(this.getServiceName());
        }
        UniversalPooledConnection conn = null;
        this.pendingRequestsCount.increment();
        try {
            conn = this.borrowConnectionAndValidate(criCopy);
            this.borrowedAccumulator.add(this.getBorrowedConnectionsCount());
            this.borrowedSamples.increment();
            if (conn != null) {
                ((UniversalPooledConnectionImpl)conn).setBorrowCRI(criCopy);
            }
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "borrowConnection", "", null, e, new Object[0]);
            throw e;
        }
        finally {
            this.pendingRequestsCount.decrement();
        }
        ((UniversalPooledConnectionImpl)conn).connectionReuseCounter.incrementAndGet();
        return conn;
    }

    private CompletionStage<UniversalPooledConnection> borrowConnectionAndLabelingSearchAsync(ConnectionRetrievalInfo cri, Executor executor) {
        Properties requestedLabels = cri.getLabels();
        boolean isLabeledRequest = requestedLabels != null;
        this.debug(Level.FINEST, CLASS_NAME, "borrowConnectionAndLabelingSearchAsync", "about to borrow a connection", null, null, new Object[0]);
        return this.borrowConnectionAndLabelingConfigureAsync(cri, null, executor).thenComposeAsync(upc -> {
            this.trace(Level.FINEST, CLASS_NAME, "borrowConnectionAndLabelingSearchAsync", "upc={0}", null, null, upc);
            if (isLabeledRequest && Objects.isNull(upc)) {
                ConnectionRetrievalInfo criNoLabels = cri.getCopyWithNoLabels();
                return this.borrowConnectionAndLabelingConfigureAsync(criNoLabels, requestedLabels, executor);
            }
            return CompletableFuture.completedFuture(upc);
        });
    }

    private UniversalPooledConnection borrowConnectionAndValidate(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc = this.borrowConnectionAndValidate(cri, null);
        if (null != upc) {
            return upc;
        }
        Properties requestedLabels = cri.getLabels();
        if (null == requestedLabels) {
            return null;
        }
        return this.borrowConnectionAndValidate(cri.getCopyWithNoLabels(), requestedLabels);
    }

    private CompletionStage<UniversalPooledConnection> borrowConnectionAndLabelingConfigureAsync(ConnectionRetrievalInfo cri, Properties requestedLabelsForRetry, Executor executor) {
        this.debug(Level.FINEST, CLASS_NAME, "borrowConnectionAndLabelingConfigureAsync", "about to borrow a connection", null, null, new Object[0]);
        CompletableFuture cf = new CompletableFuture();
        return this.borrowConnectionAndValidateAsync(cri, executor).thenComposeAsync(upc -> {
            boolean toConfigure;
            boolean needToConfigure;
            this.debug(Level.FINEST, CLASS_NAME, "borrowConnectionAndLabelingConfigureAsync", "upc=", null, null, upc);
            if (Objects.isNull(upc)) {
                cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(56));
                return cf;
            }
            Properties criLabels = cri.getLabels();
            boolean isLabeledRequest = criLabels != null || requestedLabelsForRetry != null;
            Properties requestedLabels = criLabels != null ? criLabels : requestedLabelsForRetry;
            try {
                needToConfigure = this.needToConfigureConnection((UniversalPooledConnection)upc, requestedLabels);
            }
            catch (UniversalConnectionPoolException ucpe) {
                cf.completeExceptionally(ucpe);
                return cf;
            }
            boolean bl = toConfigure = isLabeledRequest && (needToConfigure || upc.labelingCost(requestedLabels) > 0);
            if (toConfigure || Objects.nonNull(requestedLabelsForRetry)) {
                ConnectionLabelingCallback callback = Objects.requireNonNull(this.getConnectionLabelingCallback());
                return callback.configureAsync(requestedLabels, this.getConnectionObjectForLabelingConfigure((UniversalPooledConnection)upc)).thenComposeAsync(successfullyConfigured -> {
                    if (!successfullyConfigured.booleanValue()) {
                        this.retrieveAndClose((UniversalPooledConnection)upc);
                        return this.borrowConnectionAndLabelingConfigureAsync(cri, requestedLabelsForRetry, executor);
                    }
                    cf.complete(upc);
                    return cf;
                }, executor);
            }
            cf.complete(upc);
            return cf;
        }, executor).whenCompleteAsync((upc, e) -> {
            if (Objects.nonNull(e) && Objects.nonNull(upc)) {
                this.retrieveAndClose((UniversalPooledConnection)upc);
                this.trace(Level.WARNING, CLASS_NAME, "borrowConnectionAndLabelingConfigureAsync", "exception thrown", null, e, new Object[0]);
            }
        }, executor);
    }

    private CompletionStage<UniversalPooledConnection> borrowConnectionAndValidateAsync(ConnectionRetrievalInfo cri, Executor executor) {
        CompletableFuture cf = new CompletableFuture();
        return this.borrowConnectionWithoutCountingRequestsAsync(cri, executor).thenComposeAsync(upc -> {
            if (Objects.isNull(upc)) {
                cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(56));
                return cf;
            }
            UniversalPooledConnectionStatus connStatus = upc.getStatus();
            boolean connNormal = UniversalPooledConnectionStatus.STATUS_NORMAL.equals(upc.getStatus());
            if (!connNormal || !upc.isReusable() && this.core.expiredConnectionDrainPermitted()) {
                this.retrieveAndClose((UniversalPooledConnection)upc);
                return this.borrowConnectionAndValidateAsync(cri, executor);
            }
            if (!upc.isValid(UniversalPooledConnection.ValidationType.INBAND_DOWN, this.getConnectionValidationTimeout())) {
                this.retrieveAndClose((UniversalPooledConnection)upc);
                return this.borrowConnectionAndValidateAsync(cri, executor);
            }
            if (this.getValidateConnectionOnBorrow()) {
                int stt = this.getSecondsToTrustIdleConnection();
                assert (stt >= 0);
                if (stt > 0) {
                    long delta = Clock.clock() - upc.getLastNetworkAccessTime();
                    if (delta < (long)stt * 1000L) {
                        return this.validateConnectionAndBorrowNextIfInvalid(false, (UniversalPooledConnection)upc, cri, executor);
                    }
                    return this.validateConnectionAndBorrowNextIfInvalid(true, (UniversalPooledConnection)upc, cri, executor);
                }
                return this.validateConnectionAndBorrowNextIfInvalid(true, (UniversalPooledConnection)upc, cri, executor);
            }
            cf.complete(upc);
            return cf;
        }, executor);
    }

    private CompletionStage<UniversalPooledConnection> validateConnectionAndBorrowNextIfInvalid(boolean hardValidation, UniversalPooledConnection upc, ConnectionRetrievalInfo cri, Executor executor) {
        CompletableFuture cf = new CompletableFuture();
        UniversalPooledConnection.ValidationType validationType = hardValidation ? null : UniversalPooledConnection.ValidationType.SOCKET;
        return upc.isValidAsync(validationType, this.getConnectionValidationTimeout(), executor).thenComposeAsync(isValid -> {
            this.debug(Level.FINEST, CLASS_NAME, "borrowConnectionAndValidateAsync", "connection validated, isValid={0}", null, null, isValid);
            if (isValid.booleanValue()) {
                cf.complete(upc);
                return cf;
            }
            this.retrieveAndClose(upc);
            return this.borrowConnectionAndValidateAsync(cri, executor);
        }, executor);
    }

    private void retrieveAndClose(UniversalPooledConnection upc) {
        CoreConnection conn = upc.getDelegator();
        this.core.retrieve(conn);
        UniversalConnectionPoolManagerBase.getShrinkingExecutor().execute(() -> {
            conn.close();
            this.core.kickAdjuster();
        });
    }

    private UniversalPooledConnection borrowConnectionAndValidate(ConnectionRetrievalInfo cri, Properties requestedLabelsForRetry) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc = null;
        try {
            boolean needToValidate = this.getValidateConnectionOnBorrow();
            boolean successfullyConfigured = true;
            while (true) {
                ConnectionLabelingCallback callback;
                boolean toConfigure;
                Properties criLabels;
                if (null != (upc = this.borrowConnectionWithoutCountingRequests(cri))) {
                    UniversalPooledConnectionStatus connStatus = upc.getStatus();
                    boolean connNormal = UniversalPooledConnectionStatus.STATUS_NORMAL.equals(upc.getStatus());
                    if (!connNormal || !upc.isReusable() && this.core.expiredConnectionDrainPermitted()) {
                        this.retrieveAndClose(upc);
                        upc = null;
                        continue;
                    }
                    if (!needToValidate) {
                        if (!upc.isValid(UniversalPooledConnection.ValidationType.INBAND_DOWN, this.getConnectionValidationTimeout())) {
                            this.retrieveAndClose(upc);
                            upc = null;
                            continue;
                        }
                    } else {
                        long delta;
                        int stt = this.getSecondsToTrustIdleConnection();
                        if (!(stt > 0 ? ((delta = Clock.clock() - upc.getLastNetworkAccessTime()) < (long)stt * 1000L ? upc.isValid(UniversalPooledConnection.ValidationType.SOCKET, this.getConnectionValidationTimeout()) : upc.isValid(this.getConnectionValidationTimeout())) : upc.isValid(this.getConnectionValidationTimeout()))) {
                            this.retrieveAndClose(upc);
                            upc = null;
                            continue;
                        }
                    }
                }
                if (null == upc) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(56);
                }
                boolean isLabeledRequest = (criLabels = cri.getLabels()) != null || requestedLabelsForRetry != null;
                Properties requestedLabels = criLabels != null ? criLabels : requestedLabelsForRetry;
                boolean bl = toConfigure = isLabeledRequest && (this.needToConfigureConnection(upc, requestedLabels) || upc.labelingCost(requestedLabels) > 0);
                if ((toConfigure || Objects.nonNull(requestedLabelsForRetry)) && !(successfullyConfigured = (callback = Objects.requireNonNull(this.getConnectionLabelingCallback())).configure(requestedLabels, this.getConnectionObjectForLabelingConfigure(upc)))) {
                    this.retrieveAndClose(upc);
                    upc = null;
                }
                if (successfullyConfigured) break;
            }
            return upc;
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "borrowConnectionAndValidateHelper", "got unchecked exception from user-defined connection labeling callback", null, e, new Object[0]);
            if (null != upc) {
                this.retrieveAndClose(upc);
            }
            upc = null;
            throw e;
        }
    }

    protected long computeBorrowGiveUpTimestamp(ConnectionRetrievalInfo cri) {
        if (this.isNoWaitBorrow) {
            return Clock.clock();
        }
        Long cwd = null;
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            cwd = ((JDBCConnectionRetrievalInfo)cri).getConnectionWaitDurationInMillis();
        }
        if (null == cwd) {
            cwd = this.getConnectionWaitDurationInMillis();
        }
        assert (null != cwd) : "the connectionWaitDurationInMillis field is of trivial long type";
        long adjustedCwd = this.isCreateConnectionInBorrowThread() ? Math.max(cwd, this.core.connectionSource().getOutboundConnectTimeout()) : cwd;
        return Clock.clock() + adjustedCwd;
    }

    protected boolean isStillOkayToBorrow(long giveUp) {
        return Clock.clock() < giveUp;
    }

    private CompletionStage<UniversalPooledConnection> borrowConnectionWithoutCountingRequestsAsync(ConnectionRetrievalInfo cri, Executor executor) {
        UniversalPooledConnection upcForDroppedAffinity;
        UniversalPooledConnection upc;
        assert (Objects.nonNull(cri));
        Properties reqLabels = cri.getLabels();
        CompletableFuture<UniversalPooledConnection> cf = new CompletableFuture<UniversalPooledConnection>();
        if (Objects.nonNull(reqLabels) && Objects.isNull(this.getConnectionLabelingCallback())) {
            cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(92));
            return cf;
        }
        long begTime = Clock.clock();
        long giveUp = this.computeBorrowGiveUpTimestamp(cri);
        if (!this.isLifecycleRunning()) {
            this.trace(Level.WARNING, CLASS_NAME, "borrowConnectionWithoutCountingRequestsAsync", "connection borrow operation is not permitted when lifecycle state is {0}", null, null, new Object[]{this.getLifeCycleState()});
            cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(60));
            return cf;
        }
        try {
            this.validatePoolSizes();
        }
        catch (UniversalConnectionPoolException e2) {
            cf.completeExceptionally(e2);
            return cf;
        }
        ConnectionSource cs = this.connectionSource();
        CriStats criMetadata = cs.getCriMetadata(cri);
        AtomicInteger pendingBorrowWaits = criMetadata.getPendingBorrowWaits();
        int iPendingBorrowWaits = pendingBorrowWaits.incrementAndGet();
        int availCount = criMetadata.totalConnCount().get() - criMetadata.borrowedConnCount().get();
        if (iPendingBorrowWaits > availCount || !cs.available(cri)) {
            pendingBorrowWaits.decrementAndGet();
            long timeToRetry = Math.max(0L, giveUp - Clock.clock());
            return this.helpGrowBorrowedAsync(cri, timeToRetry, executor).thenComposeAsync(upcGrown -> {
                if (Objects.nonNull(upcGrown)) {
                    return CompletableFuture.completedFuture(this.postBorrow((UniversalPooledConnection)upcGrown, begTime));
                }
                return this.getAvailableConnectionAsync(cri, begTime, timeToRetry, executor);
            }, executor);
        }
        try {
            upc = this.getAvailableConnection(cri, 0L);
        }
        catch (UniversalConnectionPoolException e3) {
            cf.completeExceptionally(e3);
            return cf;
        }
        if (Objects.nonNull(upc)) {
            pendingBorrowWaits.decrementAndGet();
            return CompletableFuture.completedFuture(this.postBorrow(upc, begTime));
        }
        ConnectionAffinityCallback callback = this.getConnectionAffinityCallback();
        if (Objects.nonNull(callback) && Objects.nonNull(callback.getConnectionAffinityContext())) {
            callback.setConnectionAffinityContext(null);
        }
        try {
            upcForDroppedAffinity = this.getAvailableConnection(cri, 0L);
        }
        catch (UniversalConnectionPoolException e4) {
            cf.completeExceptionally(e4);
            return cf;
        }
        if (Objects.nonNull(upcForDroppedAffinity)) {
            pendingBorrowWaits.decrementAndGet();
            return CompletableFuture.completedFuture(this.postBorrow(upcForDroppedAffinity, begTime));
        }
        long timeToWait = Math.max(0L, giveUp - Clock.clock());
        this.getAvailableConnectionAsync(cri, begTime, timeToWait, executor).whenComplete((conn, e) -> {
            pendingBorrowWaits.decrementAndGet();
            if (Objects.nonNull(e)) {
                cf.completeExceptionally((Throwable)e);
            } else {
                cf.complete((UniversalPooledConnection)conn);
            }
        });
        return cf;
    }

    private CompletionStage<UniversalPooledConnection> helpGrowBorrowedAsync(ConnectionRetrievalInfo cri, long timeToRetry, Executor executor) {
        timeToRetry = Math.max(0L, timeToRetry);
        long started = Clock.clock();
        return this.core.growBorrowedAsync(cri, timeToRetry, executor).thenApplyAsync(conn -> {
            this.insertToCreatedHistogram(cri, Clock.clock() - started);
            return Objects.isNull(conn) ? null : (UniversalPooledConnection)conn.getDelegate();
        });
    }

    private CompletionStage<UniversalPooledConnection> getAvailableConnectionAsync(ConnectionRetrievalInfo cri, long begTime, long timeToWait, Executor executor) {
        CompletableFuture cf = new CompletableFuture();
        return this.core.waitForAvailableAsync(cri, timeToWait).thenComposeAsync(connReleased -> {
            if (Objects.nonNull(connReleased)) {
                return CompletableFuture.completedFuture(this.postBorrow((UniversalPooledConnection)connReleased.getDelegate(), begTime));
            }
            this.updateConnectionWaitCounters(false, begTime);
            if (this.core.noMoreGrows()) {
                cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(65));
            } else if (this.getTotalConnectionsCount() == 0) {
                cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(69));
            } else {
                cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(64, this.getStatistics().shortForm()));
            }
            return cf;
        }, executor);
    }

    private UniversalPooledConnection borrowConnectionWithoutCountingRequests(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        boolean labeledRequest;
        assert (cri != null);
        Properties reqLabels = cri.getLabels();
        boolean bl = labeledRequest = null != reqLabels && !reqLabels.isEmpty();
        if (reqLabels != null && this.getConnectionLabelingCallback() == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(92);
        }
        long begTime = Clock.clock();
        long giveUp = this.computeBorrowGiveUpTimestamp(cri);
        int ITERATIONS_TO_YIELD = 5;
        int iteration = 0;
        boolean[] growContext = new boolean[]{false};
        do {
            long waitingSemaphoreInterval;
            long timeForAvailableConnectionToAppear;
            UniversalPooledConnection upc;
            if (!this.isLifecycleRunning()) {
                this.trace(Level.WARNING, CLASS_NAME, "borrowConnectionWithoutCountingRequests", "connection borrow operation is not permitted when lifecycle state is {0}", null, null, new Object[]{this.getLifeCycleState()});
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            this.validatePoolSizes();
            boolean labeledRequestNextIteration = iteration > 0 && labeledRequest;
            boolean availableForThisCri = this.connectionSource().available(cri);
            if (labeledRequestNextIteration || 0 == this.getAvailableConnectionsCount() || !availableForThisCri) {
                long timeToRetry = Math.max(0L, giveUp - Clock.clock());
                UniversalPooledConnection upc2 = this.helpGrowBorrowed(cri, timeToRetry, growContext);
                if (null != upc2) {
                    return this.postBorrow(upc2, begTime);
                }
                if (this.isNoWaitBorrow) {
                    return null;
                }
            }
            if (0 == ++iteration % 5) {
                Thread.yield();
            }
            if (labeledRequestNextIteration && availableForThisCri) {
                long timeout = Math.min(100L, Math.max(0L, giveUp - Clock.clock()));
                this.core.waitForPoolUpdate(cri, timeout);
            }
            if ((upc = this.getAvailableConnection(cri, timeForAvailableConnectionToAppear = Math.min(waitingSemaphoreInterval = labeledRequest ? 100L : 200L, Math.max(0L, giveUp - Clock.clock())))) != null) {
                return this.postBorrow(upc, begTime);
            }
            ConnectionAffinityCallback callback = this.getConnectionAffinityCallback();
            if (null == callback || null == callback.getConnectionAffinityContext()) continue;
            callback.setConnectionAffinityContext(null);
        } while (this.isStillOkayToBorrow(giveUp));
        UniversalPooledConnection upc = this.getAvailableConnection(cri, 0L);
        if (null != upc) {
            return this.postBorrow(upc, begTime);
        }
        long timeToRetry = Math.max(0L, giveUp - Clock.clock());
        upc = this.helpGrowBorrowed(cri, timeToRetry, growContext);
        if (null != upc) {
            return this.postBorrow(upc, begTime);
        }
        this.updateConnectionWaitCounters(false, begTime);
        if (this.isNoWaitBorrow) {
            return null;
        }
        long cwd = this.getConnectionWaitDurationInMillis();
        int errorCode = this.core.noMoreGrows() ? 65 : (this.getTotalConnectionsCount() == 0 ? 69 : 64);
        UCPErrorHandler.throwUniversalConnectionPoolException(errorCode, this.core.getConnectionCreationCause(cwd), this.getStatistics().shortForm());
        return null;
    }

    private UniversalPooledConnection helpGrowBorrowed(ConnectionRetrievalInfo cri, long timeToRetry, boolean[] growContext) throws UniversalConnectionPoolException {
        timeToRetry = Math.max(0L, timeToRetry);
        long started = Clock.clock();
        CoreConnection conn = this.core.growForBorrow(cri, timeToRetry, growContext);
        this.insertToCreatedHistogram(cri, Clock.clock() - started);
        return null == conn ? null : (UniversalPooledConnection)conn.getDelegate();
    }

    private UniversalPooledConnection postBorrow(UniversalPooledConnection upc, long begTime) {
        if (null == upc) {
            throw new IllegalArgumentException("no upc");
        }
        upc.setBorrowedStartTime();
        upc.heartbeat();
        this.updateConnectionWaitCounters(true, begTime);
        return upc;
    }

    protected UniversalPooledConnection createOnePooledConnection() {
        UniversalPooledConnection upc = null;
        try {
            ConnectionRetrievalInfo cri = this.getConnectionRetrievalInfo();
            if (null == cri) {
                UCPErrorHandler.throwUniversalConnectionPoolException(4);
            }
            upc = this.createOnePooledConnection(cri);
        }
        catch (UniversalConnectionPoolException exc) {
            this.trace(Level.WARNING, CLASS_NAME, "createOnePooledConnection", "", null, exc, new Object[0]);
            upc = null;
        }
        this.trace(Level.FINEST, CLASS_NAME, "createOnePooledConnection", "upc={0}", null, null, upc);
        return upc;
    }

    private void updateConnectionWaitCounters(boolean success, long begTime) {
        long waitTime = Clock.clock() - begTime;
        (success ? this.cumulativeSuccessfulConnectionWaitCount : this.cumulativeFailedConnectionWaitCount).increment();
        if (0L == waitTime) {
            return;
        }
        (success ? this.cumulativeSuccessfulConnectionWaitTime : this.cumulativeFailedConnectionWaitTime).add(waitTime);
        this.peakConnectionWaitTime.accumulate(waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "createOnePooledConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            assert (cri != null);
            this.checkLifecycle();
            Object connection = null;
            UniversalPooledConnection pooledConnection = null;
            try {
                ConnectionFactoryAdapter cfa = this.getConnectionFactoryAdapter();
                connection = cfa.createConnection((ConnectionRetrievalInfo)cri);
                if (null == connection) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(100);
                }
                pooledConnection = cfa.createPooledConnection(connection, cri.getCopyWithNoLabels());
                this.incrementConnectionsCreatedCount();
                this.m_cumulativeConnectionsCreated.incrementAndGet();
            }
            finally {
                if (null != connection && null == pooledConnection) {
                    this.closePhysicalConnection(connection);
                }
            }
            UniversalPooledConnection universalPooledConnection = pooledConnection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "createOnePooledConnection", "returning {0}", null, null, universalPooledConnection);
            return universalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "createOnePooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void returnConnection(UniversalPooledConnection upc) throws UniversalConnectionPoolException {
        if (null == upc) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        if (!this.isLifecycleRunning()) {
            this.trace(Level.WARNING, CLASS_NAME, "returnConnection", "connection return operation is not permitted when lifecycle state is {0}", null, null, new Object[]{this.getLifeCycleState()});
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        if (upc.isAvailable()) {
            return;
        }
        this.core.reclaim(upc.getDelegator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void closeConnection(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        try {
            CoreConnection conn;
            void pooledConnection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "closeConnection", "entering args ({0})", null, null, universalPooledConnection);
            this.checkLifecycle();
            if (Objects.isNull(pooledConnection)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(150);
            }
            if (UniversalPooledConnectionStatus.STATUS_RECONNECTING != pooledConnection.getStatus() && this.core.retrieve(conn = pooledConnection.getDelegator())) {
                conn.close();
            }
            this.trace(Level.FINEST, CLASS_NAME, "closeConnection", "pooledConnection={0}", null, null, pooledConnection);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "closeConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "closeConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void purge() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "purge", "entering args ()", null, null, new Object[0]);
            this.checkLifecycle();
            this.core.closeAll();
            this.trace(Level.FINEST, CLASS_NAME, "purge", "purged", null, null, new Object[0]);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "purge", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "purge", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void refresh() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "refresh", "entering args ()", null, null, new Object[0]);
            this.checkLifecycle();
            this.core.replaceAvailable();
            this.trace(Level.FINEST, CLASS_NAME, "refresh", "refreshed", null, null, new Object[0]);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "refresh", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "refresh", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void recycle() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "recycle", "entering args ()", null, null, new Object[0]);
            this.checkLifecycle();
            this.core.replaceInvalidAvailable();
            this.trace(Level.FINEST, CLASS_NAME, "recycle", "recycled", null, null, new Object[0]);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "recycle", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalConnectionPoolImpl", "recycle", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    void processConnectionHarvesting() {
        this.core.harvest(this.getConnectionHarvestTriggerCount(), this.getConnectionHarvestMaxCount());
    }

    protected void setConnectionHarvestable(UniversalPooledConnection pooledConnection, boolean isConnectionHarvestable) {
        try {
            pooledConnection.setConnectionHarvestable(isConnectionHarvestable);
            this.trace(Level.FINEST, CLASS_NAME, "setConnectionHarvestable", "isConnectionHarvestable={0}", null, null, isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "setConnectionHarvestable", "", null, e, new Object[0]);
        }
    }

    @Override
    protected void closePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    public UniversalConnectionPoolStatistics getStatistics() {
        return new UniversalConnectionPoolStatisticsImpl(this);
    }

    @Override
    protected UniversalPooledConnection getUsedConnection(Object physicalConnection) {
        CoreConnection coreConn = this.core.findSpecificConnection(physicalConnection);
        return null == coreConn ? null : (UniversalPooledConnection)coreConn.getDelegate();
    }

    @Override
    protected boolean returnUsedPhysicalConnection(Object physicalConnection) throws UniversalConnectionPoolException {
        UniversalPooledConnection pooledConnection = this.getUsedConnection(physicalConnection);
        if (pooledConnection == null) {
            return false;
        }
        if (this.isCommitOnConnectionReturn()) {
            pooledConnection.getDelegator().commit();
        } else {
            pooledConnection.getDelegator().rollback();
        }
        this.returnConnection(pooledConnection);
        return true;
    }

    private UniversalPooledConnection getAvailableConnection(ConnectionRetrievalInfo cri, long timeout) throws UniversalConnectionPoolException {
        assert (cri != null);
        CoreConnection coreConn = this.core.borrow(cri, timeout);
        return null == coreConn ? null : (UniversalPooledConnection)coreConn.getDelegate();
    }

    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection upc) {
        return upc.getPhysicalConnection();
    }

    protected void incrementCumulativeConnectionsCreated() {
        this.m_cumulativeConnectionsCreated.incrementAndGet();
    }

    private void checkLifecycle() throws UniversalConnectionPoolException {
        if (this.isLifecycleFailed() || this.isLifecycleStopped()) {
            this.trace(Level.WARNING, CLASS_NAME, "checkLifecycle", "pool operations are not permitted when lifecycle state is {0}", null, null, new Object[]{this.getLifeCycleState()});
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
    }

    protected boolean needToConfigureConnection(UniversalPooledConnection pc, Properties requestedLabels) throws UniversalConnectionPoolException {
        return false;
    }

    private /* synthetic */ void lambda$borrowConnectionAsync$0(CompletableFuture cf, ConnectionRetrievalInfo criCopy, UniversalPooledConnection upc, Throwable e) {
        if (Objects.isNull(e)) {
            this.borrowedAccumulator.add(this.getBorrowedConnectionsCount());
            this.borrowedSamples.increment();
        } else {
            this.trace(Level.WARNING, CLASS_NAME, "borrowConnectionAsync", "", null, e, new Object[0]);
            cf.completeExceptionally(e);
        }
        if (Objects.nonNull(upc)) {
            ((UniversalPooledConnectionImpl)upc).setBorrowCRI(criCopy);
            this.debug(Level.FINEST, CLASS_NAME, "borrowConnectionAsync", "connection is borrowed, upc={0}", null, e, upc);
            ((UniversalPooledConnectionImpl)upc).connectionReuseCounter.incrementAndGet();
            cf.complete(upc);
        }
        this.pendingRequestsCount.decrement();
    }
}

