/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.MappedGetter;

class BorrowSemaphoreMap {
    private final MappedGetter<ConnectionRetrievalInfo, ShrinkableSemaphore> semaphoreMap = new MappedGetter();
    private final ThreadLocal<Boolean> insideTryAcquire = ThreadLocal.withInitial(() -> false);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    BorrowSemaphoreMap() {
    }

    private ShrinkableSemaphore getSemaphore(ConnectionRetrievalInfo cri) {
        return this.semaphoreMap.computeIfAbsent(cri, p -> new ShrinkableSemaphore());
    }

    void release(ConnectionRetrievalInfo cri) {
        if (!this.insideTryAcquire.get().booleanValue()) {
            this.getSemaphore(cri).release();
        }
    }

    void reducePermit(ConnectionRetrievalInfo cri) {
        if (!this.insideTryAcquire.get().booleanValue()) {
            this.getSemaphore(cri).reducePermits(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    <T> T tryAcquire(ConnectionRetrievalInfo connectionRetrievalInfo, long l, Callable<T> callable) throws InterruptedException {
        void millisTimeout;
        void cri;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        T res = null;
        if (this.getSemaphore((ConnectionRetrievalInfo)cri).tryAcquire((long)millisTimeout, TimeUnit.MILLISECONDS)) {
            this.insideTryAcquire.set(true);
            try {
                void todo;
                res = (T)todo.call();
            }
            catch (Exception e) {
                if (bl) {
                    ClioSupport.ilogThrowing($$$loggerRef$$$3, BorrowSemaphoreMap.class, $$$methodRef$$$3, this, e);
                }
            }
            finally {
                this.insideTryAcquire.set(false);
                if (null == res) {
                    this.release((ConnectionRetrievalInfo)cri);
                }
            }
        }
        return res;
    }

    int availablePermits(ConnectionRetrievalInfo cri) {
        return this.getSemaphore(cri).availablePermits();
    }

    static {
        try {
            $$$methodRef$$$7 = BorrowSemaphoreMap.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = BorrowSemaphoreMap.class.getDeclaredMethod("lambda$new$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = BorrowSemaphoreMap.class.getDeclaredMethod("lambda$getSemaphore$1", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = BorrowSemaphoreMap.class.getDeclaredMethod("availablePermits", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = BorrowSemaphoreMap.class.getDeclaredMethod("tryAcquire", ConnectionRetrievalInfo.class, Long.TYPE, Callable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = BorrowSemaphoreMap.class.getDeclaredMethod("reducePermit", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = BorrowSemaphoreMap.class.getDeclaredMethod("release", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = BorrowSemaphoreMap.class.getDeclaredMethod("getSemaphore", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    private static class ShrinkableSemaphore
    extends Semaphore {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private ShrinkableSemaphore() {
            super(0, true);
        }

        @Override
        protected void reducePermits(int permits) {
            super.reducePermits(permits);
        }

        static {
            try {
                $$$methodRef$$$2 = ShrinkableSemaphore.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = ShrinkableSemaphore.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = ShrinkableSemaphore.class.getDeclaredMethod("reducePermits", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

