/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOConnectPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.TimeoutInterruptHandler;

public class NSProtocolNIO
extends NSProtocol {
    private static final String CLASS_NAME = NSProtocolNIO.class.getName();
    private static final long SEND_BREAK_TIMEOUT_MS = 30L;
    private final AtomicBoolean isWriting = new AtomicBoolean(false);
    private final AtomicBoolean isBreakPending = new AtomicBoolean(false);
    private NIONSDataChannel probePacket;
    static final int MAX_RETRIES = 10;
    DMSFactory.DMSNoun dmsParent = null;
    private boolean isResending = false;
    private TraceEventListener traceEventListener;
    private Object userContext;

    public NSProtocolNIO(String connection, @Blind(value=PropertiesBlinder.class) Properties userProperties, SSLContext sslContext, OracleHostnameResolver hostnameResolver, boolean useDirectBuffers, Diagnosable diagnosable, TraceEventListener traceEventListener) throws NetException {
        super(connection, userProperties, sslContext, hostnameResolver, useDirectBuffers, diagnosable, traceEventListener);
        this.traceEventListener = traceEventListener;
    }

    @Override
    void negotiateConnection(NVFactory nvf, NVNavigator nvn, boolean disableOOB, boolean useZeroCopyIO, DMSFactory.DMSNoun _dmsParent) throws IOException, NetException, InterruptedIOException {
        IOException stashedException;
        int responseType;
        NIOPacket packet;
        boolean isConnectionAccepted;
        NIOConnectPacket cnPkt = new NIOConnectPacket(this.sAtts);
        this.dmsParent = _dmsParent;
        do {
            stashedException = null;
            packet = null;
            long connectStartTime = System.currentTimeMillis();
            responseType = 0;
            try {
                this.begin(this.isResending ? Metrics.ConnectionEvent.NS_CONNECT_SEND2 : Metrics.ConnectionEvent.NS_CONNECT_SEND1);
                cnPkt.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !disableOOB, useZeroCopyIO, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
                if (this.isResending) {
                    this.end(Metrics.ConnectionEvent.NS_CONNECT_SEND2);
                    this.begin(Metrics.ConnectionEvent.NS_CONNECT_RECEIVE2);
                } else {
                    this.end(Metrics.ConnectionEvent.NS_CONNECT_SEND1);
                    this.begin(Metrics.ConnectionEvent.NS_CONNECT_RECEIVE1);
                }
                packet = NIOPacket.readNIOPacket(this.sAtts);
                responseType = packet.header.type;
                if (this.isResending) {
                    this.end(Metrics.ConnectionEvent.NS_CONNECT_RECEIVE2);
                    this.isResending = false;
                } else {
                    this.end(Metrics.ConnectionEvent.NS_CONNECT_RECEIVE1);
                }
            }
            catch (TimeoutInterruptHandler.IOReadTimeoutException ioTimeoutInterrupt) {
                this.handleIOTimeoutInterrupt();
                stashedException = ioTimeoutInterrupt;
            }
            catch (InterruptedIOException ioInterrupt) {
                if (this.handleOutboundTimeoutInterrupt(ioInterrupt)) {
                    String port = Integer.toString(this.sAtts.cOption.port);
                    stashedException = new NetException(12170, null, false, "Outbound connect", this.sAtts.cOption.getOriginalConnOption().connectTimeout + "ms", "host " + this.sAtts.cOption.host + " port " + port);
                    this.lastConnectException(stashedException);
                }
                throw ioInterrupt;
            }
            catch (IOException ioException) {
                this.handleIOException();
                stashedException = ioException;
                this.lastConnectException(stashedException);
            }
            if (stashedException == null) continue;
            if (!(stashedException instanceof NetException)) {
                String stashedExceptionMessage = String.format("%s, connect lapse %d ms.", stashedException.getMessage(), System.currentTimeMillis() - connectStartTime);
                stashedException = new IOException(stashedExceptionMessage, stashedException);
            }
            responseType = 4;
        } while (!(isConnectionAccepted = this.handleConnectPacketResponse(nvf, nvn, packet, responseType, stashedException)));
    }

    private void handleIOTimeoutInterrupt() {
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleIOTimeoutInterrupt", "Connection establishment interrupted by IO Read Timout mechanism, will be trying with next available connect option.", null, null, new Object[0]);
        Thread.interrupted();
    }

    private boolean handleOutboundTimeoutInterrupt(InterruptedIOException interruptException) {
        assert (!(interruptException instanceof TimeoutInterruptHandler.IOReadTimeoutException)) : "IO timeout is being handled as an outbound timeout";
        TimeoutInterruptHandler.InterruptTask outBoundInterruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        if (outBoundInterruptTask != null && outBoundInterruptTask.isInterrupted()) {
            Thread.interrupted();
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutboundTimeoutInterrupt", "Connection establishment interrupted by Outbound Timout mechanism, will be trying with next available connect option.", null, null, new Object[0]);
            return true;
        }
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutboundTimeoutInterrupt", "Connection establishment interrupted externally, exiting.", null, null, new Object[0]);
        return false;
    }

    private void handleIOException() {
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleIOException", "Connection establishment failed due to IOException, will be trying with next available connect option.", null, null, new Object[0]);
        TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
    }

    private final boolean handleConnectPacketResponse(NVFactory nvf, NVNavigator nvn, NIOPacket packet, int responseType, IOException stashedException) throws IOException, NetException, InterruptedIOException {
        switch (responseType) {
            case 2: {
                this.handleAcceptPacket((NIOAcceptPacket)packet);
                return true;
            }
            case 5: {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleConnectPacketResponse", "Got Redirect, SessionTraceId = {0}", null, null, this.sAtts.traceId);
                ConnOption origConnOption = this.sAtts.cOption.getOriginalConnOption();
                this.handleRedirectPacket((NIORedirectPacket)packet);
                this.redirectConnection((NIORedirectPacket)packet, origConnOption);
                return false;
            }
            case 4: {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleConnectPacketResponse", "Got Refused, SessionTraceId = {0}", null, null, this.sAtts.traceId);
                String errCode = this.errorCode(nvf, nvn, (NIORefusePacket)packet);
                if (errCode != null) {
                    this.sAtts.cOption.lastConnectError(Integer.parseInt(errCode));
                }
                this.userContext = ConnStrategy.fireConnectionFailureEvent(this.traceEventListener, this.userContext, this.sAtts.cOption, errCode == null ? "ORA-12564" : "ORA-" + errCode);
                ConnOption origConnOption = this.sAtts.cOption.getOriginalConnOption();
                if (this.establishConnectionAfterRefusePacket()) {
                    this.lastConnectException(this.createRefusePacketException(nvf, nvn, errCode, origConnOption));
                    return false;
                }
                if (stashedException != null) {
                    throw stashedException;
                }
                throw this.createRefusePacketException(nvf, nvn, errCode, origConnOption);
            }
            case 11: {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleConnectPacketResponse", "Got Resend, SessionTraceId = {0}", null, null, this.sAtts.traceId);
                this.handleResendPacket((NIOResendPacket)packet);
                return false;
            }
        }
        this.sAtts.cOption.nt.disconnect();
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleConnectPacketResponse", "Got Unexpected packet from server. Packet Type = {0}, SessionTraceId = {1}", null, null, responseType, this.sAtts.traceId);
        throw new NetException(17905);
    }

    private final void redirectConnection(NIORedirectPacket rdPkt, ConnOption origConnOption) throws NetException, IOException, InterruptedIOException {
        this.begin(Metrics.ConnectionEvent.NS_REDIRECT);
        String rdAddress = rdPkt.redirectData;
        String redirectConnectData = null;
        if ((rdPkt.header.flags & 2) == 2 && rdPkt.redirectData.indexOf(0) != -1) {
            rdAddress = rdPkt.redirectData.substring(0, rdPkt.redirectData.indexOf(0));
            this.sAtts.redirecting = true;
            redirectConnectData = rdPkt.redirectData.substring(rdPkt.redirectData.indexOf(0) + 1, rdPkt.redirectData.length());
        }
        this.validateRedirectResponse(rdAddress);
        if ("WSS".equalsIgnoreCase(this.sAtts.cOption.protocol)) {
            rdAddress = this.getWSSRedirectAddress(rdAddress, this.sAtts.cOption.addr);
        }
        this.addrRes.setRedirectConnectData(redirectConnectData == null ? this.sAtts.cOption.conn_data.toString() : redirectConnectData);
        this.establishConnection(rdAddress, this.dmsParent);
        this.addrRes.setRedirectConnectData(null);
        this.sAtts.cOption.setOriginalConnOption(origConnOption);
        this.end(Metrics.ConnectionEvent.NS_REDIRECT);
    }

    private final boolean establishConnectionAfterRefusePacket() throws IOException, InterruptedIOException {
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.cOption = null;
        TimeoutInterruptHandler.InterruptTask it = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "establishConnectionAfterRefusePacket", "Outbound interrupt timer cancelled {0}", null, null, it);
        if (it != null && it.isInterrupted()) {
            Thread.interrupted();
        }
        try {
            this.establishConnection(null, true, this.dmsParent);
        }
        catch (NetException netException) {
            // empty catch block
        }
        return this.sAtts.cOption != null;
    }

    @Override
    final CompletionStage<Void> negotiateConnectionAsync(NVFactory nvf, NVNavigator nvn, boolean disableOOB, boolean useZeroCopyIO, DMSFactory.DMSNoun _dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        return this.chainAsyncNegotiationIO(nvf, nvn, disableOOB, useZeroCopyIO, _dmsParent, new NIOConnectPacket(this.sAtts), outboundTimeoutHandler, asyncExecutor);
    }

    private final CompletionStage<Void> chainAsyncNegotiationIO(NVFactory nvf, NVNavigator nvn, boolean disableOOB, boolean useZeroCopyIO, DMSFactory.DMSNoun dmsParent, NIOConnectPacket cnPkt, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        class ConnectResponse {
            final int packetType;
            final NIOPacket packet;
            final IOException failure;

            ConnectResponse(int packetType, NIOPacket packet, IOException failure) {
                this.packetType = packetType;
                this.packet = packet;
                this.failure = failure;
            }
        }
        CompletableFuture ioFuture = new CompletableFuture();
        try {
            cnPkt.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !disableOOB, useZeroCopyIO, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
            this.sAtts.cOption.nt.registerForNonBlockingRead(ioFailure -> asyncExecutor.execute(() -> {
                if (ioFailure == null) {
                    ioFuture.complete(null);
                } else {
                    ioFuture.completeExceptionally((Throwable)ioFailure);
                }
            }));
        }
        catch (IOException ea2) {
            ioFuture.completeExceptionally(ea2);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)ioFuture.thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
            NIOPacket packet = NIOPacket.readNIOPacket(this.sAtts);
            int packetType = packet.header.type;
            return new ConnectResponse(packetType, packet, null);
        }))).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, ea -> {
            outboundTimeoutHandler.cancelTimeout();
            int packetType = 4;
            return new ConnectResponse(packetType, null, (IOException)ea);
        }))).thenCompose(response -> this.handleConnectPacketResponseAsync(nvf, nvn, response.packet, response.packetType, response.failure, outboundTimeoutHandler, asyncExecutor))).thenCompose(isConnectionAccepted -> {
            if (isConnectionAccepted.booleanValue()) {
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }
            return this.chainAsyncNegotiationIO(nvf, nvn, disableOOB, useZeroCopyIO, dmsParent, cnPkt, outboundTimeoutHandler, asyncExecutor);
        });
    }

    private final CompletionStage<Boolean> handleConnectPacketResponseAsync(NVFactory nvf, NVNavigator nvn, NIOPacket packet, int responseType, IOException stashedException, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        try {
            switch (responseType) {
                case 2: {
                    this.handleAcceptPacket((NIOAcceptPacket)packet);
                    return CompletionStageUtil.completedStage(Boolean.TRUE);
                }
                case 5: {
                    ConnOption origConnOption = this.sAtts.cOption.getOriginalConnOption();
                    this.handleRedirectPacket((NIORedirectPacket)packet);
                    return this.redirectConnectionAsync((NIORedirectPacket)packet, origConnOption, outboundTimeoutHandler, asyncExecutor).thenApply(nil -> Boolean.FALSE);
                }
                case 4: {
                    ConnOption origConnOption = this.sAtts.cOption.getOriginalConnOption();
                    return this.establishConnectionAfterRefusePacketAsync(outboundTimeoutHandler, asyncExecutor).thenApply(CompletionStageUtil.normalCompletionHandler(isConnected -> {
                        if (isConnected.booleanValue()) {
                            return Boolean.FALSE;
                        }
                        if (stashedException != null) {
                            throw stashedException;
                        }
                        if (packet != null) {
                            throw this.createRefusePacketException(nvf, nvn, this.errorCode(nvf, nvn, (NIORefusePacket)packet), origConnOption);
                        }
                        throw new NetException(12564);
                    }));
                }
                case 11: {
                    this.handleResendPacket((NIOResendPacket)packet);
                    return CompletionStageUtil.completedStage(Boolean.FALSE);
                }
            }
            this.sAtts.cOption.nt.disconnect();
            return CompletionStageUtil.failedStage(new NetException(17905));
        }
        catch (IOException handlingFailure) {
            return CompletionStageUtil.failedStage(handlingFailure);
        }
    }

    private final CompletionStage<Void> redirectConnectionAsync(NIORedirectPacket rdPkt, ConnOption origConnOption, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        String redirectConnectData;
        String rdAddress;
        if ((rdPkt.header.flags & 2) == 2 && rdPkt.redirectData.indexOf(0) != -1) {
            rdAddress = rdPkt.redirectData.substring(0, rdPkt.redirectData.indexOf(0));
            this.sAtts.redirecting = true;
            redirectConnectData = rdPkt.redirectData.substring(rdPkt.redirectData.indexOf(0) + 1, rdPkt.redirectData.length());
        } else {
            rdAddress = rdPkt.redirectData;
            redirectConnectData = null;
        }
        try {
            this.validateRedirectResponse(rdAddress);
            if ("WSS".equalsIgnoreCase(this.sAtts.cOption.protocol)) {
                rdAddress = this.getWSSRedirectAddress(rdAddress, this.sAtts.cOption.addr);
            }
        }
        catch (IOException getAddressFailure) {
            return CompletionStageUtil.failedStage(getAddressFailure);
        }
        return this.establishConnectionAsync(rdAddress, false, this.dmsParent, outboundTimeoutHandler, asyncExecutor).thenAccept(initializedSessionAtts -> {
            this.sAtts.cOption.setOriginalConnOption(origConnOption);
            if (this.sAtts.redirecting) {
                this.sAtts.cOption.conn_data.setLength(0);
                this.sAtts.cOption.conn_data.append(redirectConnectData);
            } else {
                this.sAtts.cOption.conn_data = origConnOption.conn_data;
            }
        });
    }

    private final CompletionStage<Boolean> establishConnectionAfterRefusePacketAsync(AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        try {
            this.sAtts.cOption.nt.disconnect();
        }
        catch (IOException disconnectFailure) {
            return CompletionStageUtil.failedStage(disconnectFailure);
        }
        this.sAtts.cOption = null;
        outboundTimeoutHandler.cancelTimeout();
        return this.establishConnectionAsync(null, true, this.dmsParent, outboundTimeoutHandler, asyncExecutor).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(NetException.class, connectFailure -> null)).thenApply(initializedSessionAttsOrNull -> this.sAtts.cOption != null);
    }

    private final void handleAcceptPacket(NIOAcceptPacket acPkt) throws IOException, NetException {
        this.begin(Metrics.ConnectionEvent.NS_ACCEPT);
        this.sAtts.setNegotiatedSDUAndTDU(acPkt.sduSize, acPkt.tduSize);
        this.sAtts.setNegotiatedOptions(acPkt.options);
        this.sAtts.setConnectData(acPkt.connectData);
        this.addrRes.clearConnStrategyStack();
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleAcceptPacket", "Connection established. Cleared conn strategy stack", null, null, new Object[0]);
        this.sAtts.payloadDataBufferForRead.position(this.sAtts.payloadDataBufferForRead.limit());
        this.sAtts.connected = true;
        this.end(Metrics.ConnectionEvent.NS_ACCEPT);
        if (acPkt.isOOBCheckEnabled) {
            this.tryUrgentByte();
            this.sendMarker(2, (byte)3);
            this.sAtts.setNetProperty("oracle.jdbc.isOOBCheckDone", "true");
        } else {
            this.sAtts.setNetProperty("oracle.jdbc.isOOBCheckDone", "false");
        }
    }

    private final void handleRedirectPacket(NIORedirectPacket rdPkt) throws IOException {
        this.addrRes.connection_redirected = true;
        this.sAtts.cOption.nt.disconnect();
    }

    private String errorCode(NVFactory nvf, NVNavigator nvn, NIORefusePacket rfPkt) {
        if (rfPkt == null) {
            return null;
        }
        try {
            NVPair nvPair;
            NVPair errvp = nvn.findNVPairRecurse(nvf.createNVPair(rfPkt.refuseData), "ERROR");
            if (errvp != null && (nvPair = nvn.findNVPairRecurse(errvp, "CODE")) != null) {
                return nvPair.valueToString();
            }
        }
        catch (NLException exp) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "errorCode", "Failed to parse refuse data.", null, exp, new Object[0]);
        }
        return null;
    }

    private final NetException createRefusePacketException(NVFactory nvf, NVNavigator nvn, String errCode, ConnOption cOption) {
        int errNumber = errCode == null ? 12564 : Integer.parseInt(errCode);
        String serverType = null;
        try {
            NVPair nvpConData = nvf.createNVPair(cOption.conn_data.toString());
            NVPair connDataPairs = nvn.findNVPair(nvpConData, "CONNECT_DATA");
            for (int i = 0; i < connDataPairs.getListSize(); ++i) {
                if (!connDataPairs.getListElement(i).getName().equals("SERVER")) continue;
                serverType = connDataPairs.getListElement(i).getAtom();
            }
        }
        catch (Exception e) {
            return new NetException(18958);
        }
        if (errNumber == 12514) {
            return new NetException(errNumber, null, false, cOption.service_name, "host " + cOption.host + " port " + cOption.port);
        }
        if (errNumber == 12505) {
            return new NetException(errNumber, null, false, cOption.sid, "host " + cOption.host + " port " + cOption.port);
        }
        if (errNumber == 12521) {
            return new NetException(errNumber, null, false, cOption.instanceName(), cOption.service_name, "host " + cOption.host + " port " + cOption.port);
        }
        if (errNumber == 12520) {
            return new NetException(errNumber, null, false, "host " + cOption.host + " port " + cOption.port, serverType, cOption.service_name);
        }
        if (errNumber == 12516) {
            return new NetException(errNumber, null, false, "host " + cOption.host + " port " + cOption.port, cOption.protocol, cOption.service_name);
        }
        return errNumber >= 12000 ? new NetException(errNumber) : new NetException(12564, errCode == null ? "" : "(Oracle Error - " + errCode + ")");
    }

    private final void handleResendPacket(NIOResendPacket rsPkt) throws IOException {
        this.isResending = true;
        if ((rsPkt.header.flags & 8) == 8) {
            this.sAtts.renegotiateSSLSession();
        }
    }

    private String getWSSRedirectAddress(String redirectAddr, String originalAddr) throws IOException {
        try {
            NVNavigator redirectNavigator = new NVNavigator();
            NVPair redirectNVPair = new NVFactory().createNVPair(redirectAddr);
            String redirectHost = redirectNavigator.findNVPair(redirectNVPair, "HOST").getAtom();
            String redirectPort = redirectNavigator.findNVPair(redirectNVPair, "PORT").getAtom();
            NVNavigator origNav = new NVNavigator();
            NVPair originalNVPair = new NVFactory().createNVPair(originalAddr);
            String originalHost = redirectNavigator.findNVPair(originalNVPair, "HOST").getAtom();
            String originalPort = redirectNavigator.findNVPair(originalNVPair, "PORT").getAtom();
            NVPair nvpWebSockUri = origNav.findNVPair(originalNVPair, "WEBSOCK_URI");
            String websocketURI = nvpWebSockUri == null ? "/sqlnet" : nvpWebSockUri.getAtom();
            String redirectWebSocketUri = websocketURI + "/" + redirectHost + ":" + redirectPort;
            return String.format("(ADDRESS=(PROTOCOL=WSS)(HOST=%s)(PORT=%s)(WEBSOCK_URI=%s))", originalHost, originalPort, redirectWebSocketUri);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeZeroCopyIO(byte[] userBuffer, int offset, int length) throws IOException {
        int lengthInDD;
        boolean isLastDD = false;
        for (int nbOfRemainingBytes = length; nbOfRemainingBytes > 0; nbOfRemainingBytes -= lengthInDD) {
            if (nbOfRemainingBytes >= 1703910) {
                lengthInDD = 1703910;
            } else {
                lengthInDD = nbOfRemainingBytes;
                isLastDD = true;
            }
            this.sAtts.prepareWriteBuffer();
            this.sAtts.ddPacket.writeToSocketChannel(lengthInDD, isLastDD);
            ByteBuffer tmpByteBuffer = ByteBuffer.wrap(userBuffer, offset, lengthInDD);
            while (tmpByteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.write(tmpByteBuffer);
            }
            offset += lengthInDD;
        }
    }

    @Override
    public void writeZeroCopyIOHeader(boolean flushBuffer, int lengthInDD, boolean isLastDD) throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.ddPacket.writeToSocketChannel(lengthInDD, isLastDD);
    }

    @Override
    public void writeZeroCopyIOData(byte[] userBuffer, int offset, int length) throws IOException {
        ByteBuffer tmpByteBuffer = ByteBuffer.wrap(userBuffer, offset, length);
        while (tmpByteBuffer.hasRemaining()) {
            this.sAtts.socketChannel.write(tmpByteBuffer);
        }
    }

    @Override
    public boolean readZeroCopyIO(byte[] userBuffer, int offset, int[] bytesRead) throws IOException {
        boolean markIsPresent = false;
        this.sAtts.ddPacket.readFromSocketChannel(true);
        this.sAtts.ddPacket.readPayloadBuffer();
        int nbOfBytes = this.sAtts.ddPacket.totalDataLength;
        if ((this.sAtts.ddPacket.descriptorFLaG & 1) != 0) {
            markIsPresent = true;
        }
        if (userBuffer.length < offset + nbOfBytes) {
            throw new IOException("Assertion Failed");
        }
        int bytesReadSoFar = 0;
        ByteBuffer buffer = this.sAtts.readBuffer;
        if (buffer.hasRemaining()) {
            int copySize = Math.min(buffer.remaining(), nbOfBytes);
            buffer.get(userBuffer, offset, copySize);
            bytesReadSoFar += copySize;
        }
        while (bytesReadSoFar < nbOfBytes) {
            buffer.clear();
            buffer.limit(Math.min(buffer.capacity(), nbOfBytes - bytesReadSoFar));
            while (buffer.hasRemaining()) {
                this.sAtts.socketChannel.read(buffer);
            }
            buffer.rewind();
            buffer.get(userBuffer, offset + bytesReadSoFar, buffer.limit());
            bytesReadSoFar += buffer.limit();
        }
        bytesRead[0] = bytesReadSoFar;
        return markIsPresent;
    }

    @Override
    public void cancelTimeout() {
        TimeoutInterruptHandler.InterruptTask it = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cancelTimeout", "SO_TIMEOUT interrupt timer cancelled {0}", (String)null, null, (Object)it);
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(17900);
        }
        IOException ioException = null;
        try {
            this.sAtts.dataChannel.sendEOF();
        }
        catch (IOException ioe) {
            ioException = ioe;
        }
        this.sAtts.connected = false;
        this.dmsParent = null;
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.releaseWriteBuffer();
        if (ioException != null) {
            throw ioException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(17900);
        }
        TimeoutInterruptHandler.InterruptTask it = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendReset", "SO_TIMEOUT interrupt timer cancelled {0}", null, null, it);
        this.sendMarker(1, (byte)2);
        while (this.sAtts.onBreakReset) {
            this.sAtts.markerPacket.readFromSocketChannel(true, false);
            this.sAtts.markerPacket.readPayloadBuffer();
            if (!this.sAtts.markerPacket.isResetPkt()) continue;
            this.sAtts.onBreakReset = false;
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(17900);
        }
        TimeoutInterruptHandler.InterruptTask it = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, this.sAtts.socketChannel);
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendInterrupt", "SO_TIMEOUT interrupt timer cancelled {0}", null, null, it);
        super.sendInterrupt();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.socketChannel = this.sAtts.nt.getSocketChannel();
        this.sAtts.initializeBuffer();
        this.sAtts.dataEOF = false;
    }

    @Override
    protected void sendMarker(int type, byte markerData) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(17900);
        }
        this.sAtts.markerPacket.writeToSocketChannel(type, markerData);
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendMarker", "Sending break marker, SessionTraceId = {0}", null, null, this.sAtts.traceId);
    }

    @Override
    void sendProbePacket() throws IOException {
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendMarker", "Sending a probe packet, SessionTraceId = {0}", null, null, this.sAtts.traceId);
        if (this.probePacket == null) {
            this.probePacket = new NIONSDataChannel(this.sAtts);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        byte[] connectDataBytes = new byte[26];
        this.probePacket.writeDataToSocketChannel(connectDataBytes);
    }

    void doSocketRead(int minBytesRequired) throws IOException {
        int initialPosition = this.sAtts.readBuffer.position();
        int numberOfRetries = 0;
        while (this.sAtts.readBuffer.position() < minBytesRequired) {
            int numberOfBytesRead = this.sAtts.socketChannel.read(this.sAtts.readBuffer);
            if (numberOfBytesRead < 0) {
                throw new NetException(17800);
            }
            if (numberOfBytesRead == 0) {
                if (++numberOfRetries < 10) continue;
                throw new NetException(17800);
            }
            numberOfRetries = 0;
        }
        this.sAtts.readBuffer.flip();
        this.sAtts.readBuffer.position(initialPosition);
    }

    @Override
    public void sendZDP() throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.dataChannel.header.type = 6;
        this.sAtts.payloadBufferForWrite.clear();
        this.sAtts.payloadBufferForWrite.limit(2);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.dataChannel.writeToSocketChannel();
    }

    @Override
    public boolean needsToBeClosed() {
        return this.sAtts.needsToBeClosed;
    }

    @Override
    public void readInbandNotification() {
        try {
            if (this.sAtts.needsToBeClosed) {
                return;
            }
            this.sAtts.dataChannel.readInbandNotificationCtlPacket();
        }
        catch (IOException ioEx) {
            this.sAtts.needsToBeClosed = true;
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "readInbandNotification", "Received IOException while reading in-band notification, SessionTraceId = {0}", null, ioEx, this.sAtts.traceId);
        }
    }

    @Override
    public final void sendBreak() throws IOException, NetException {
        this.isBreakPending.set(true);
        if (this.isWriting.compareAndSet(false, true)) {
            try {
                this.sendPendingBreak();
            }
            finally {
                this.isWriting.set(false);
            }
        }
    }

    final void beginWrite() throws IOException {
        while (!this.isWriting.compareAndSet(false, true)) {
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException("Socket write interrupted");
        }
        try {
            this.sendPendingBreak();
        }
        catch (Throwable sendBreakError) {
            this.isWriting.set(false);
            if (sendBreakError instanceof IOException) {
                throw (IOException)sendBreakError;
            }
            throw new IOException(sendBreakError);
        }
    }

    final void endWrite(Throwable writeException) throws IOException {
        if (writeException != null) {
            this.isWriting.set(false);
            if (writeException instanceof IOException) {
                throw (IOException)writeException;
            }
            throw new IOException(writeException);
        }
        try {
            this.sendPendingBreak();
        }
        finally {
            this.isWriting.set(false);
        }
        while (this.isBreakPending.get()) {
            if (this.isWriting.compareAndSet(false, true)) {
                try {
                    this.sendPendingBreak();
                    continue;
                }
                finally {
                    this.isWriting.set(false);
                    continue;
                }
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException("Socket write interrupted");
        }
    }

    private void sendPendingBreak() throws IOException {
        assert (this.isWriting.get()) : "Sending break without the write lock";
        if (!this.isBreakPending.get()) {
            return;
        }
        if (!this.sAtts.connected) {
            throw new NetException(17900);
        }
        if (this.sAtts.isExpediatedAttentionEnabled() && !this.sAtts.nt.awaitWriteReadiness(30L)) {
            throw new IOException("Unable to send break without blocking");
        }
        TimeoutInterruptHandler.InterruptTask it = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, this.sAtts.socketChannel);
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "sendPendingBreak", "OUTBOUND interrupt timer cancelled {0}", null, null, it);
        int originalTimeout = this.getSocketReadTimeout();
        this.setSocketReadTimeout(30);
        try {
            super.sendBreak();
            this.isBreakPending.set(false);
        }
        finally {
            this.setSocketReadTimeout(originalTimeout);
        }
    }
}

