/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.util.Vector;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class AddressList
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    protected SchemaObjectFactoryInterface f = null;

    public AddressList(SchemaObjectFactoryInterface f) {
        this.f = f;
    }

    @Override
    public int isA() {
        return 1;
    }

    @Override
    public String isA_String() {
        return "ADDRESS_LIST";
    }

    @Override
    public void initFromString(String s) throws NLException, SOException, NetException {
        NVPair nvp = new NVFactory().createNVPair(s);
        this.initFromNVPair(nvp);
    }

    @Override
    public void initFromNVPair(NVPair nvp) throws SOException, NetException {
        this.init();
        int listsize = nvp.getListSize();
        if (listsize == 0) {
            throw new SOException();
        }
        for (int i = 0; i < listsize; ++i) {
            this.childnv = nvp.getListElement(i);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            throw new SOException();
        }
        if (this.children.size() == 0) {
            throw new SOException();
        }
    }

    @Override
    public String toString() {
        String s = new String("");
        if (this.children.size() < 1) {
            return s;
        }
        s = s + "(ADDRESS_LIST=";
        for (int i = 0; i < this.children.size(); ++i) {
            s = s + ((SchemaObject)this.children.elementAt(i)).toString();
        }
        if (this.sourceRoute) {
            s = s + "(SOURCE_ROUTE=yes)";
        }
        if (this.loadBalance) {
            s = s + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            s = s + "(FAILOVER=false)";
        }
        s = s + ")";
        return s;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
    }
}

