/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import oracle.net.url.common.MalformedURLException;
import oracle.net.url.common.Validators;
import oracle.net.url.parser.ConnectDescriptorAdapter;
import oracle.net.url.parser.EZConnectParseResult;
import oracle.net.url.parser.ExtendedPropertiesParser;
import oracle.net.url.parser.ParserUtils;

final class EZConnectParser {
    public static final int DEFAULT_DATABASE_PORT = 1521;
    private String url;
    private String urlInLowerCase;
    private char[] urlChars;
    private int currentPosition = 0;
    private String protocol = "tcp";
    private String serviceName = null;
    private String serverMode = null;
    private String instanceName = null;
    private boolean hasSeenAddrListDelimiter = false;
    private boolean isSIDFormat = false;
    private boolean hasSeenProtocol = false;
    private int numberOfPortsSeen = 0;
    private int numberOfHostsSeen = 0;
    private LinkedList<List<Address>> addressLists = new LinkedList();
    private Properties properties;
    final boolean strictMode;

    EZConnectParser(boolean strictMode) {
        this.strictMode = strictMode;
    }

    EZConnectParseResult parse(String url) throws MalformedURLException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("url is null or empty");
        }
        this.url = url;
        this.urlInLowerCase = this.url.trim().toLowerCase();
        this.urlChars = this.url.toCharArray();
        this.currentPosition = 0;
        this.ignoreWhitespaces();
        this.parseProtocol();
        this.parseConnectOptions();
        this.parseServiceName();
        this.parseServerMode();
        if (this.instanceName == null) {
            this.parseInstanceName();
        }
        this.parseConnectionProperties();
        ConnectDescriptorAdapter adapter = new ConnectDescriptorAdapter(this);
        return new EZConnectParseResult(adapter.getRootNode(), adapter.getConnectionProperties());
    }

    private void parseProtocol() throws MalformedURLException {
        int parsedLength = 0;
        if (this.urlInLowerCase.startsWith("//")) {
            this.protocol = "tcp";
            parsedLength = 2;
            this.hasSeenProtocol = true;
        } else if (this.urlInLowerCase.indexOf("://") != -1) {
            int idx = this.urlInLowerCase.indexOf("://");
            this.protocol = this.urlInLowerCase.substring(0, idx).trim();
            parsedLength = idx + 3;
            if (!this.protocol.matches("tcp|tcps|ldap|ldaps")) {
                this.throwParseFailure("Invalid protocol '" + this.url.substring(this.currentPosition, this.url.indexOf("://")) + "'");
            }
            this.hasSeenProtocol = true;
        }
        this.currentPosition += parsedLength;
    }

    private void parseConnectOptions() throws MalformedURLException {
        if (this.ignoreWhitespaces()) {
            this.throwParseFailure("No Connect options found");
        }
        if (!this.isHostBeginChar(this.urlChars[this.currentPosition])) {
            this.throwParseFailure(null);
        }
        LinkedList<String> hosts = new LinkedList<String>();
        this.addressLists.addLast(new LinkedList());
        while (!this.isEOS() && !this.ignoreWhitespaces()) {
            if (this.isHostBeginChar(this.urlChars[this.currentPosition])) {
                hosts.add(this.parseHost());
                ++this.numberOfHostsSeen;
                continue;
            }
            if (this.urlChars[this.currentPosition] == ',') {
                if (this.addressLists.getLast().isEmpty() && hosts.isEmpty() && !this.isHostBeginChar(this.peekNextNonWhitespaceChar())) {
                    this.throwParseFailure("Invalid Address");
                }
                ++this.currentPosition;
                continue;
            }
            if (this.urlChars[this.currentPosition] == ':') {
                if (hosts.isEmpty()) break;
                int port = this.parsePort();
                ++this.numberOfPortsSeen;
                hosts.forEach(host -> this.addressLists.getLast().add(new Address((String)host, port)));
                hosts.clear();
                continue;
            }
            if (this.urlChars[this.currentPosition] == ';') {
                char nxtChar;
                if (!hosts.isEmpty()) {
                    hosts.forEach(host -> this.addressLists.getLast().add(new Address((String)host)));
                    hosts.clear();
                }
                if (this.isHostBeginChar(nxtChar = this.peekNextNonWhitespaceChar())) {
                    this.addressLists.addLast(new LinkedList());
                } else if (nxtChar != '/' && nxtChar != '?' && nxtChar != '\u0000') {
                    this.ignoreWhitespaces();
                    this.throwParseFailure("Invalid Address");
                }
                this.hasSeenAddrListDelimiter = true;
                ++this.currentPosition;
                continue;
            }
            if (this.urlChars[this.currentPosition] == '/' || this.urlChars[this.currentPosition] == '?') {
                if (hosts.isEmpty()) break;
                hosts.forEach(host -> this.addressLists.getLast().add(new Address((String)host)));
                hosts.clear();
                break;
            }
            this.throwParseFailure("Invalid Address");
        }
        if (!hosts.isEmpty()) {
            hosts.forEach(host -> this.addressLists.getLast().add(new Address((String)host)));
            hosts.clear();
        }
        if (this.addressLists.getLast().isEmpty()) {
            this.addressLists.removeLast();
        }
    }

    private boolean parseSIDURL() throws MalformedURLException {
        return false;
    }

    private int parsePort() throws MalformedURLException {
        Set<Character> delimiters = ParserUtils.setOf(Character.valueOf(','), Character.valueOf(';'), Character.valueOf('/'), Character.valueOf(':'));
        if (this.urlChars[this.currentPosition] != ':') {
            this.throwParseFailure("Invalid port value");
        }
        ++this.currentPosition;
        this.ignoreWhitespaces();
        StringBuilder portStr = new StringBuilder();
        while (!this.isEOS() && !delimiters.contains(Character.valueOf(this.urlChars[this.currentPosition]))) {
            if (Character.isDigit(this.urlChars[this.currentPosition])) {
                portStr.append(this.urlChars[this.currentPosition++]);
                continue;
            }
            if (Character.isWhitespace(this.urlChars[this.currentPosition]) && this.isTrailingWhitespace(delimiters)) break;
            this.throwParseFailure("Invalid port value");
        }
        if (portStr.length() == 0) {
            this.throwParseFailure("Invalid port value, port value cannot be empty");
        }
        return Integer.parseInt(portStr.toString());
    }

    private String parseHost() throws MalformedURLException {
        String host = null;
        host = this.urlChars[this.currentPosition] == '[' ? this.parseIPv6Address() : this.parseNonIPv6Address();
        return host;
    }

    private String parseIPv6Address() throws MalformedURLException {
        ++this.currentPosition;
        StringBuilder ipv6Address = new StringBuilder();
        while (this.urlChars[this.currentPosition] != ']') {
            if (Character.digit(this.urlChars[this.currentPosition], 16) != -1 || this.urlChars[this.currentPosition] == ':') {
                ipv6Address.append(this.urlChars[this.currentPosition++]);
            } else {
                this.throwParseFailure(null);
            }
            if (this.isEOS()) {
                this.throwParseFailure("Ipv6 address must close with a ']'");
            }
            if (ipv6Address.length() <= 39) continue;
            this.throwParseFailure("Invalid IPv6 value, more than maximum length");
        }
        String ipv6AddressString = "[" + ipv6Address.toString() + "]";
        if (!Validators.IPv6_VALIDATOR.test(ipv6AddressString)) {
            this.throwParseFailure("Invalid IPv6 address : " + ipv6AddressString);
        }
        ++this.currentPosition;
        return ipv6AddressString;
    }

    private String parseNonIPv6Address() throws MalformedURLException {
        String hostStrString;
        Set<Character> delimiters = ParserUtils.setOf(Character.valueOf(','), Character.valueOf(';'), Character.valueOf('/'), Character.valueOf(':'));
        StringBuilder hostStr = new StringBuilder();
        while (!this.isEOS() && !delimiters.contains(Character.valueOf(this.urlChars[this.currentPosition]))) {
            if (Character.isDigit(this.urlChars[this.currentPosition]) || Character.isAlphabetic(this.urlChars[this.currentPosition]) || this.urlChars[this.currentPosition] == '.' || this.urlChars[this.currentPosition] == '-' || this.urlChars[this.currentPosition] == '_') {
                hostStr.append(this.urlChars[this.currentPosition]);
            } else {
                if (Character.isWhitespace(this.urlChars[this.currentPosition]) && this.isTrailingWhitespace(delimiters)) break;
                this.throwParseFailure(null);
            }
            ++this.currentPosition;
        }
        if (!Validators.HOST_VALIDATOR.test(hostStrString = hostStr.toString())) {
            this.throwParseFailure("Invalid Host value : " + hostStrString);
        }
        return hostStr.toString();
    }

    private void parseServiceName() throws MalformedURLException {
        this.serviceName = this.parseToken('/', ParserUtils.setOf(Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('?')), false);
    }

    private void parseServerMode() throws MalformedURLException {
        int initPos = this.currentPosition;
        this.serverMode = this.parseToken(':', ParserUtils.setOf(Character.valueOf('/'), Character.valueOf('?'), Character.valueOf(':')), true);
        if (this.serverMode == null || Validators.SERVER_MODE_VALIDATOR.test(this.serverMode)) {
            return;
        }
        if (!this.isSIDFormatPossible()) {
            throw new MalformedURLException("Invalid server mode '" + this.serverMode + "'", this.url, initPos);
        }
        this.isSIDFormat = true;
        this.instanceName = this.serverMode;
        initPos = this.currentPosition;
        this.serverMode = this.parseToken(':', ParserUtils.setOf(Character.valueOf('?')), true);
        if (this.serverMode != null && !Validators.SERVER_MODE_VALIDATOR.test(this.serverMode)) {
            throw new MalformedURLException("Invalid server mode '" + this.serverMode + "'", this.url, initPos);
        }
        if (!this.isEOS() && this.urlChars[this.currentPosition] != '?') {
            this.throwParseFailure(null);
        }
    }

    private boolean isSIDFormatPossible() {
        if (this.serviceName != null || this.hasSeenProtocol || this.numberOfHostsSeen != 1 || this.numberOfPortsSeen != 1) {
            return false;
        }
        return this.isEOS() || this.urlChars[this.currentPosition] != ':' || this.urlChars[this.currentPosition] != '?';
    }

    private void parseInstanceName() throws MalformedURLException {
        this.instanceName = this.parseToken('/', ParserUtils.setOf(Character.valueOf('?')), true);
    }

    private void parseConnectionProperties() throws MalformedURLException {
        this.ignoreWhitespaces();
        if (this.isEOS() || this.urlChars[this.currentPosition] != '?') {
            return;
        }
        ++this.currentPosition;
        if (this.isEOS()) {
            return;
        }
        this.properties = new ExtendedPropertiesParser(this.urlChars, this.currentPosition).getProperties();
    }

    private String parseToken(char beginChar, Set<Character> endChars, boolean throwErrorOnEmptyValue) throws MalformedURLException {
        this.ignoreWhitespaces();
        if (this.isEOS() || this.urlChars[this.currentPosition] != beginChar) {
            return null;
        }
        ++this.currentPosition;
        this.ignoreWhitespaces();
        if (this.isEOS()) {
            if (throwErrorOnEmptyValue) {
                this.throwParseFailure(null);
            }
            return null;
        }
        StringBuilder tknBuilder = new StringBuilder();
        while (!this.isEOS() && !endChars.contains(Character.valueOf(this.urlChars[this.currentPosition]))) {
            if (Character.isWhitespace(this.urlChars[this.currentPosition])) {
                if (this.isTrailingWhitespace(endChars)) {
                    this.ignoreWhitespaces();
                    break;
                }
                this.throwParseFailure("Invalid whitespace");
            } else {
                tknBuilder.append(this.urlChars[this.currentPosition]);
            }
            ++this.currentPosition;
        }
        return tknBuilder.toString();
    }

    private boolean ignoreWhitespaces() {
        while (!this.isEOS() && Character.isWhitespace(this.urlChars[this.currentPosition])) {
            ++this.currentPosition;
        }
        return this.currentPosition >= this.urlChars.length;
    }

    private boolean isTrailingWhitespace(Set<Character> endChars) {
        char ch = this.peekNextNonWhitespaceChar();
        return endChars.contains(Character.valueOf(ch)) || ch == '\u0000';
    }

    private char peekNextNonWhitespaceChar() {
        for (int pos = this.currentPosition + 1; pos < this.urlChars.length; ++pos) {
            if (Character.isWhitespace(this.urlChars[pos])) {
                continue;
            }
            return this.urlChars[pos];
        }
        return '\u0000';
    }

    private void throwParseFailure(String msg) throws MalformedURLException {
        throw new MalformedURLException(msg, this.url, this.currentPosition);
    }

    private boolean isHostBeginChar(char ch) {
        return Character.isDigit(ch) || Character.isAlphabetic(ch) || ch == '[';
    }

    private boolean isEOS() {
        return this.currentPosition >= this.urlChars.length;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<List<Address>> getAddressList() {
        return this.addressLists;
    }

    public boolean hasSeenAddrListDelimiter() {
        return this.hasSeenAddrListDelimiter;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getServerMode() {
        return this.serverMode;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isSIDFormat() {
        return this.isSIDFormat;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Protocol: ").append(this.protocol);
        sb.append("Service Name: ").append(this.serviceName);
        sb.append("Server Mode: ").append(this.serverMode);
        sb.append("Instance Name: ").append(this.instanceName);
        sb.append("Ext. Properties: ").append(this.properties);
        sb.append("Connect Options : ");
        this.addressLists.forEach(list -> {
            sb.append("Address List: ");
            list.forEach(address -> sb.append("\tAddress: ").append(address.host).append(":").append(address.port));
        });
        return sb.toString();
    }

    static class Address {
        String host;
        int port;

        Address(String host) {
            this.host = host;
            this.port = 1521;
        }

        Address(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

