/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.CharCommonAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class LongAccessor
extends CharCommonAccessor {
    static final int MAXLENGTH = Integer.MAX_VALUE;
    OracleInputStream stream;
    int columnPosition = 0;

    LongAccessor(OracleStatement stmt, int column_pos, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(stmt, max_len > 0 && max_len < Integer.MAX_VALUE ? max_len : Integer.MAX_VALUE, form, isStoredInBindData);
        this.init(stmt, 8, 8, form, isOutBind);
        this.columnPosition = column_pos;
        this.initForDataAccess(external_type, max_len, null);
    }

    LongAccessor(OracleStatement stmt, int column_pos, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, max_len > 0 && max_len < Integer.MAX_VALUE ? max_len : Integer.MAX_VALUE, form, false);
        this.init(stmt, 8, 8, form, false);
        this.columnPosition = column_pos;
        this.initForDescribe(8, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.isStream = true;
        this.isColumnNumberAware = true;
        this.charLength = 0;
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
    }

    @Override
    OracleInputStream initForNewRow() throws SQLException {
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
        return this.stream;
    }

    @Override
    void updateColumnNumber(int colNumber) {
        this.columnPosition = ++colNumber;
        if (this.stream != null) {
            this.stream.columnIndex = colNumber;
        }
    }

    @Override
    byte[] getBytesInternal(int currentRow) throws SQLException {
        if (this.statement.isFetchStreams) {
            return super.getBytesInternal(currentRow);
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.stream == null) {
            return null;
        }
        if (!this.isStream) {
            return super.getBytesInternal(currentRow);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        ByteArrayOutputStream outs = new ByteArrayOutputStream(1024);
        byte[] buffer = this.statement.connection.getByteBuffer(32768);
        try {
            int length;
            while ((length = this.stream.readInternal(buffer, 0, 32768)) != -1) {
                outs.write(buffer, 0, length);
            }
            this.statement.connection.cacheBuffer(buffer);
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        return outs.toByteArray();
    }

    @Override
    String getString(int currentRow) throws SQLException {
        String result = null;
        byte[] b_array = this.getBytes(currentRow);
        if (b_array != null) {
            int repLen = this.statement.maxFieldSize > 0 && this.statement.maxFieldSize < this.representationMaxLength ? this.statement.maxFieldSize : this.representationMaxLength;
            int len = Math.min(b_array.length, repLen);
            assert (len > 0) : "len: " + len;
            result = this.formOfUse == 2 ? this.statement.connection.conversion.NCharBytesToString(b_array, len) : this.statement.connection.conversion.CharBytesToString(b_array, len);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream convertBytesToStream(int currentRow, int conversion) throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(this.getBytesInternal(currentRow));
        try {
            InputStream result;
            InputStream inputStream = result = this.statement.connection.conversion.ConvertStream(is, conversion, this.statement.connection);
            return inputStream;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        PhysicalConnection conn = this.statement.connection;
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return this.convertBytesToStream(currentRow, 0);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        return conn.conversion.ConvertStream(this.stream, 0, conn);
    }

    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        PhysicalConnection conn = this.statement.connection;
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return this.convertBytesToStream(currentRow, 1);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        return conn.conversion.ConvertStream(this.stream, 1, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.getBytesInternal(currentRow));
            try {
                Reader result;
                PhysicalConnection conn = this.statement.connection;
                Reader reader = result = this.statement.connection.conversion.ConvertCharacterStream(is, 9, this.formOfUse, conn);
                return reader;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        PhysicalConnection conn = this.statement.connection;
        return conn.conversion.ConvertCharacterStream(this.stream, 9, this.formOfUse, conn);
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        PhysicalConnection conn = this.statement.connection;
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return this.convertBytesToStream(currentRow, 6);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        return conn.conversion.ConvertStream(this.stream, 6, conn);
    }

    @Override
    public String toString() {
        return "LongAccessor@" + Integer.toHexString(this.hashCode()) + "{columnPosition = " + this.columnPosition + "}";
    }
}

