/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.base.Disposable;
import com.oracle.common.internal.Platform;
import com.oracle.common.internal.net.ipclw.mql.Context;
import com.oracle.common.internal.net.ipclw.mql.KeyRegistry;
import com.oracle.common.internal.net.ipclw.mql.KeyedBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.KeyedMultiBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.KeyedSingleBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.LocalQueue;
import com.oracle.common.internal.net.ipclw.mql.MessageQueue;
import com.oracle.common.internal.net.ipclw.mql.MultiInterfaceKeyRegistry;
import com.oracle.common.internal.net.ipclw.mql.RegistrationKey;
import com.oracle.common.internal.net.ipclw.mql.RemoteQueue;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferManagers;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.net.InetAddresses;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MQLFlowControl;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NTMQProtocolHandler;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class MQLNTAdapter
implements NTAdapter,
LocalQueue.ReadCallback {
    int port;
    String host;
    private SocketChannel socketChannel;
    private Selector selector;
    private SelectionKey selectionKey;
    private long connectTimeout;
    protected Socket socket;
    protected int readTimeout;
    protected Properties socketOptions;
    private final AtomicInteger numberOfMessagesReceived = new AtomicInteger(0);
    private final ByteBuffer wakeupBuffer = ByteBuffer.allocateDirect(1);
    InetAddress localInetAddress;
    private Context mqContext;
    private LocalQueue localQueue;
    private RemoteQueue remoteQueue;
    private static BufferManager bufferManager = null;
    Context.Dependencies.Transport transport = null;
    int busyWait;
    int kernelWait;
    IOException ioExceptionWhileMSGQOp = null;
    Queue<BufferSequence> onMessageBufferList = new LinkedList<BufferSequence>();
    BufferSequence dequedRcvBuf = null;
    NTMQProtocolHandler ntmqProtocolHandler;
    private int headerSizeSend;
    private int sdu = 65518;
    private int tdu = 65536;
    private boolean drainBuffers = false;
    private boolean flowControlEnabled = false;
    private MQLFlowControl flowControl;
    private static final boolean FLOW_CONTROL_ENABLED = true;
    private KeyRegistry keyRegistry;
    private int kernelWaitSend = Integer.MAX_VALUE;
    private int kernelWaitWork = Integer.MAX_VALUE;
    private TimeoutInterruptHandler.InterruptTask interruptTask;
    private byte[] sessionId = null;
    private boolean isConnected = false;
    private int pendingSends;
    private BufferSequence sendOnInterrupt = null;
    private boolean connectResponsePending;
    private int postCount = 0;
    private static final byte MQL_RC_TRANS = 1;
    private static final int MQL_DEFAULT_BUFFER_SPACE = 8;
    private static final int MQL_MAX_MSGSIZE = 65536;
    private static final int IMD_MSG_BUFFER_SPACE = 2;
    private static final int IMD_MAX_MSGSIZE = 65536;
    private static final int MAX_PENDING = 4;
    private static final int USR_WAIT_WORK = 10000;
    private static final int USR_WAIT_SEND = 10000;
    private static final int RDMA_CONNECT_WAIT = 2000;
    private static final int RCV_BUF_COUNT = 1;
    private static final int SEND_BUF_COUNT = 2;
    private static final int HDR_OFFSET_SEND = 0;
    private static final int NS_OFFSET_SEND = 1;
    private static final String FMW_COMMONS_IP_PROP = "com.oracle.common.internal.net.ipclw.mql.Context.defaultAddress";
    private static final String MSGQ_ERR_STATE_MSG = "Message Queue is in an error state.";
    ByteBuffer bufferForDeathDetection = ByteBuffer.allocate(1);
    private static final Monitor BUFFER_MANAGER_INIT_MONITOR = Monitor.newInstance();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static BufferManager getBufferManager() {
        return bufferManager;
    }

    public MQLNTAdapter(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws NLException {
        this.socketOptions = properties;
        this.ntmqProtocolHandler = new NTMQProtocolHandler(1, false, false);
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair2.getAtom();
        if (nVPair3 != null) {
            try {
                this.port = Integer.parseInt(nVPair3.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        String string2 = (String)properties.get(22);
        if (string2 != null) {
            this.transport = Context.Dependencies.Transport.valueOf((String)string2);
        }
        this.busyWait = Integer.parseInt((String)properties.get(23));
        this.kernelWait = Integer.parseInt((String)properties.get(24));
    }

    private void handleConnectPacket() throws IOException {
        if (!this.connectResponsePending) {
            throw new NetException(26, "Received unexpected packet type: 1");
        }
        this.connectResponsePending = false;
        if (this.ntmqProtocolHandler.isSIDRequiredForRqMsg()) {
            this.sessionId = this.ntmqProtocolHandler.getSID();
            this.headerSizeSend = 18;
        } else {
            this.sessionId = null;
            this.headerSizeSend = 2;
        }
        ByteBuffer byteBuffer = this.ntmqProtocolHandler.getRemoteQueueNameBuffer();
        MessageQueue.Name name = new MessageQueue.Name(byteBuffer);
        this.initRemoteQueue();
        this.remoteQueue.connect(name);
        this.flowControlEnabled = this.ntmqProtocolHandler.isFlowControlEnabled();
        if (this.flowControlEnabled) {
            BufferSequence bufferSequence = this.ntmqProtocolHandler.isSIDRequiredForRdmaMsg() ? this.createMqlMessage((byte)6, (byte)4, this.ntmqProtocolHandler.getSID(), true) : this.createMqlMessage((byte)6, (byte)0, null, true);
            short s2 = this.ntmqProtocolHandler.getFcPostCount();
            this.flowControl.onFlowControlEnabled(s2, this.ntmqProtocolHandler.getFcKey(), this.ntmqProtocolHandler.getFcAddr(), this.remoteQueue, bufferSequence);
            this.flowControl.onMessageReceived();
            this.flowControl.onBufferPosted(this.postCount);
            BufferSequence bufferSequence2 = this.createMqlMessage((byte)6, (byte)0);
            this.writeToRemoteQueue(bufferSequence2);
            while (this.flowControl.getAvailableBufferCount() != s2) {
                this.await(this.localQueue.getContext(), 0, 2000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocalQueueNameOnSocket(LocalQueue localQueue) throws IOException {
        ByteBuffer byteBuffer = bufferManager.acquire(this.ntmqProtocolHandler.getHeaderPacketSize());
        this.ntmqProtocolHandler.prepareHeaderPacket(byteBuffer, (byte)1, (byte)1, this.sessionId, false);
        int n2 = 28 + this.mqContext.getNameSize() + 12 + this.mqContext.getKeySize();
        ByteBuffer byteBuffer2 = bufferManager.acquire(n2);
        this.ntmqProtocolHandler.prepareConnectPacket(byteBuffer2, null, this.sdu, ByteOrder.LITTLE_ENDIAN, localQueue);
        this.prepareFlowControlPacket(byteBuffer2);
        ByteBuffer byteBuffer3 = bufferManager.acquire(byteBuffer.limit() + byteBuffer2.limit());
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer3.put(byteBuffer);
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.flip();
        try {
            this.selectionKey.interestOps(4);
            while (byteBuffer3.hasRemaining()) {
                if (this.selector.select(this.readTimeout) == 0) {
                    throw new NetException(23);
                }
                Set<SelectionKey> set = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    if (selectionKey.isWritable()) {
                        int n3 = this.socketChannel.write(byteBuffer3);
                    }
                    iterator.remove();
                }
            }
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            bufferManager.release(byteBuffer3);
            bufferManager.release(byteBuffer2);
            bufferManager.release(byteBuffer);
        }
        this.connectResponsePending = true;
    }

    public ByteBuffer readFromLocalQueue() throws IOException {
        return this.readFromLocalQueue(true);
    }

    public ByteBuffer readFromLocalQueue(boolean bl) throws IOException {
        ByteBuffer byteBuffer;
        this.ensureConnection(false);
        do {
            BufferSequence bufferSequence = this.getNextMessage(bl);
            if (this.dequedRcvBuf != null) {
                this.dequedRcvBuf.dispose();
            }
            this.dequedRcvBuf = bufferSequence;
            if (bufferSequence == null) {
                return null;
            }
            byteBuffer = bufferSequence.getBuffer(0);
            this.processNTMQLayer(byteBuffer);
        } while (!this.ntmqProtocolHandler.isDataPacket());
        int n2 = byteBuffer.remaining();
        byteBuffer.limit(byteBuffer.position() + this.sdu);
        byteBuffer = byteBuffer.slice();
        byteBuffer.limit(n2);
        return byteBuffer;
    }

    private BufferSequence getNextMessage(boolean bl) throws IOException {
        while (this.onMessageBufferList.size() <= 0) {
            this.readNTMQPacketFromLocalQueue(bl);
            if (bl) continue;
            break;
        }
        return this.onMessageBufferList.poll();
    }

    private void readNTMQPacketFromLocalQueue(boolean bl) throws IOException {
        int n2 = 0;
        try {
            this.scheduleInterrupt(this.readTimeout);
            while (this.numberOfMessagesReceived.get() == 0 || this.mqContext.isWorkPending()) {
                this.replenish();
                if (this.remoteQueue != null && this.remoteQueue.getContext().isWorkPending()) {
                    this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitWork);
                } else if (bl) {
                    this.await(this.localQueue.getContext(), n2 == 0 ? this.busyWait : 0, this.kernelWait);
                } else {
                    this.await(this.remoteQueue.getContext(), 0, 0);
                    break;
                }
                if (this.numberOfMessagesReceived.get() != 0 || n2++ <= 5 || !this.isConnectionDead()) continue;
                this.disconnect();
                throw new NetException(0);
            }
        }
        finally {
            this.cancelTimeout();
        }
        this.numberOfMessagesReceived.set(0);
        if (this.flowControlEnabled) {
            this.flowControl.sendCounterUpdate();
        }
    }

    private void processNTMQLayer(ByteBuffer byteBuffer) throws IOException {
        this.ntmqProtocolHandler.processNTMQPacket(byteBuffer);
        if (this.ntmqProtocolHandler.isDisconnectPacket()) {
            this.writeLocalQueueNameOnSocket(this.localQueue);
        } else if (this.ntmqProtocolHandler.isConnectPacket()) {
            this.handleConnectPacket();
        } else if (this.ntmqProtocolHandler.isDataIRPacket()) {
            this.flowControl.onIRMessage(this.ntmqProtocolHandler.getPacketFlag());
        }
    }

    public int writeToRemoteQueue(ByteBuffer byteBuffer, boolean bl) throws IOException {
        this.ensureConnection(true);
        int n2 = byteBuffer.limit();
        KeyedBufferSequence keyedBufferSequence = this.initSendBuffer((byte)4, (byte)0, byteBuffer, bl);
        this.writeToRemoteQueue((BufferSequence)keyedBufferSequence);
        return n2;
    }

    private void writeToRemoteQueue(BufferSequence bufferSequence) throws IOException {
        this.writeToRemoteQueue(bufferSequence, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToRemoteQueue(BufferSequence bufferSequence, boolean bl) throws IOException {
        block14: {
            if (this.flowControlEnabled) {
                if (!this.ensureAvailableReceiveSpace(bufferSequence, bl)) {
                    return bl;
                }
                this.flowControl.onMessageSent();
            }
            if (this.pendingSends >= 4) {
                if (bl) {
                    while (this.pendingSends >= 4) {
                        this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitWork);
                    }
                } else {
                    return false;
                }
            }
            try {
                this.scheduleInterrupt(this.readTimeout);
                ++this.pendingSends;
                if (bl) {
                    try {
                        while (!this.remoteQueue.send(bufferSequence, (Object)bufferSequence, 1)) {
                            this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitSend);
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        --this.pendingSends;
                        throw iOException;
                    }
                }
                if (!this.remoteQueue.send(bufferSequence, (Object)bufferSequence, 1)) {
                    --this.pendingSends;
                    boolean bl2 = false;
                    return bl2;
                }
            }
            finally {
                this.cancelTimeout();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureAvailableReceiveSpace(BufferSequence bufferSequence, boolean bl) throws IOException {
        int n2 = this.flowControl.getAvailableBufferCount();
        if (n2 == 0) {
            if (this.sendOnInterrupt != null || !bl) {
                return false;
            }
            this.sendOnInterrupt = bufferSequence;
            try {
                while (n2 == 0) {
                    this.await(this.localQueue.getContext(), 0, this.kernelWait);
                    if (this.sendOnInterrupt == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    n2 = this.flowControl.getAvailableBufferCount();
                }
            }
            finally {
                this.sendOnInterrupt = null;
            }
        }
        if (n2 == 1) {
            ByteBuffer byteBuffer = bufferSequence.getBuffer(0);
            if (byteBuffer.get(0) == 4) {
                this.wakeupBuffer.put(0, (byte)0);
                if (!this.flowControl.sendInterruptRequest(bl)) {
                    return false;
                }
                if (this.ioExceptionWhileMSGQOp != null) {
                    throw this.ioExceptionWhileMSGQOp;
                }
                this.ntmqProtocolHandler.prepareHeaderPacket(byteBuffer, (byte)7, this.flowControl.getInterruptRequestCount(), this.sessionId, false);
            } else {
                if (!bl) {
                    return false;
                }
                while (n2 <= 1) {
                    this.await(this.remoteQueue.getContext(), 0, this.kernelWait);
                    n2 = this.flowControl.getAvailableBufferCount();
                }
            }
        }
        return true;
    }

    private void await(Context context, int n2, int n3) throws IOException {
        if (this.ioExceptionWhileMSGQOp != null) {
            throw (IOException)new IOException(MSGQ_ERR_STATE_MSG).initCause(this.ioExceptionWhileMSGQOp);
        }
        this.wakeupBuffer.put(0, (byte)0);
        context.await(n2, n3);
        if (this.ioExceptionWhileMSGQOp != null) {
            throw this.ioExceptionWhileMSGQOp;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterrupt();
        }
    }

    private KeyedBufferSequence initSendBuffer(byte by, byte by2, ByteBuffer byteBuffer, boolean bl) throws IOException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[2];
        RegistrationKey[] registrationKeyArray = new RegistrationKey[2];
        final ByteBuffer[] byteBufferArray2 = new ByteBuffer[2];
        ByteBuffer byteBuffer2 = bufferManager.acquire(this.headerSizeSend);
        RegistrationKey registrationKey = this.keyRegistry.getKey(byteBuffer2);
        this.ntmqProtocolHandler.prepareHeaderPacket(byteBuffer2, by, by2, this.sessionId, false);
        byteBufferArray[0] = byteBuffer2;
        registrationKeyArray[0] = registrationKey;
        byteBufferArray2[0] = byteBuffer2;
        if (byteBuffer.isDirect() && (registrationKeyArray[1] = this.keyRegistry.getKey(byteBuffer)) != null) {
            byteBufferArray[1] = byteBuffer;
            if (bl) {
                byteBufferArray2[1] = byteBufferArray[1];
            }
        } else {
            ByteBuffer byteBuffer3 = bufferManager.acquire(byteBuffer.remaining());
            byteBuffer3.put(byteBuffer);
            byteBuffer3.flip();
            byteBufferArray[1] = byteBuffer3;
            registrationKeyArray[1] = this.keyRegistry.getKey(byteBuffer3);
            byteBufferArray2[1] = byteBuffer3;
        }
        return new KeyedMultiBufferSequence(null, byteBufferArray, null, registrationKeyArray){
            private final ByteBuffer[] toRelease;
            {
                super(bufferManager, byteBufferArray, context, registrationKeyArray);
                this.toRelease = byteBufferArray2;
            }

            public void dispose() {
                --MQLNTAdapter.this.pendingSends;
                for (ByteBuffer byteBuffer : this.toRelease) {
                    if (byteBuffer == null) continue;
                    bufferManager.release(byteBuffer);
                }
            }
        };
    }

    private void initLocalQueue(Context.DefaultDependencies defaultDependencies) throws IOException {
        this.mqContext.setWakeupBuffer(this.wakeupBuffer);
        LocalQueue.DefaultDependencies defaultDependencies2 = new LocalQueue.DefaultDependencies(defaultDependencies, null).setMaximumReceiveMessageCount(8).setMaximumMessageSizeBytes(65536).setMaximumMessageBufferCount(1);
        defaultDependencies2.setInitialReceiveMessageCount(0);
        this.localQueue = this.mqContext.openLocalQueue((LocalQueue.Dependencies)defaultDependencies2);
        this.localQueue.setReadCallback((LocalQueue.ReadCallback)this);
        this.localQueue.getContext().setRdmaImmediateCallback(new LocalQueue.ReadCallback(){

            public void onMessage(BufferSequence bufferSequence, IOException iOException) throws IOException {
                bufferSequence.dispose();
                if (iOException != null) {
                    if (MQLNTAdapter.this.ioExceptionWhileMSGQOp != null) {
                        iOException.initCause(MQLNTAdapter.this.ioExceptionWhileMSGQOp);
                    }
                    MQLNTAdapter.this.ioExceptionWhileMSGQOp = iOException;
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                } else if (MQLNTAdapter.this.sendOnInterrupt != null && MQLNTAdapter.this.writeToRemoteQueue(MQLNTAdapter.this.sendOnInterrupt, false)) {
                    MQLNTAdapter.this.sendOnInterrupt = null;
                } else {
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                }
            }
        });
        this.localQueue.bind();
        this.replenish();
    }

    private BufferSequence initReceiveBuffer() throws IOException {
        ByteBuffer byteBuffer = bufferManager.acquire(this.tdu);
        RegistrationKey registrationKey = this.keyRegistry.getKey(byteBuffer);
        return new KeyedSingleBufferSequence(bufferManager, byteBuffer, null, registrationKey);
    }

    private BufferSequence createMqlMessage(byte by, byte by2) throws IOException {
        return this.createMqlMessage(by, by2, null, false);
    }

    private BufferSequence createMqlMessage(byte by, byte by2, byte[] byArray, final boolean bl) throws IOException {
        int n2 = bl && this.ntmqProtocolHandler.isSIDRequiredForRdmaMsg() ? 18 : this.headerSizeSend;
        ByteBuffer byteBuffer = bufferManager.acquire(n2);
        this.ntmqProtocolHandler.prepareHeaderPacket(byteBuffer, by, by2, byArray, bl);
        RegistrationKey registrationKey = this.keyRegistry.getKey(byteBuffer);
        return new KeyedSingleBufferSequence(bufferManager, byteBuffer, null, registrationKey){
            boolean isImmediateMsg;
            {
                super(bufferManager, byteBuffer, context, registrationKey);
                this.isImmediateMsg = bl;
            }

            public void dispose() {
                if (!this.isImmediateMsg) {
                    --MQLNTAdapter.this.pendingSends;
                }
                super.dispose();
            }
        };
    }

    @Override
    public void connect(DMSFactory.DMSNoun dMSNoun) throws IOException {
        try {
            this.connectSocket();
            this.isConnected = true;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        this.setSocketOptions();
        String string = (String)this.socketOptions.get(21);
        this.localInetAddress = string != null ? InetAddress.getByName(string) : InetAddresses.getLocalHost();
        this.initBufferManager(this.localInetAddress);
        this.keyRegistry = ((MultiInterfaceKeyRegistry)bufferManager).getRegistry(this.localInetAddress);
        Context.DefaultDependencies defaultDependencies = new Context.DefaultDependencies().setInetAddress(this.localInetAddress).setBufferManager(bufferManager).setMaximumOutstandingMessageCount(4).setMaximumMessageSizeBytes(65536).setParentContext(this.keyRegistry.getContext()).setTransport(Context.Dependencies.Transport.RC).setFlags(5).setMaximumImmediateReceiveMessageCount(2).setMaximumImmediateReceiveMessageSizeBytes(65536);
        if (this.transport != null) {
            defaultDependencies.setTransport(this.transport);
        }
        this.mqContext = new Context((Context.Dependencies)defaultDependencies);
        this.mqContext.open();
        this.initLocalQueue(defaultDependencies);
        this.connectToRemoteQueue();
    }

    private void connectSocket() throws IOException {
        Boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (!bl.booleanValue()) {
            throw new NetException(20);
        }
        String string = (String)this.socketOptions.get(2);
        this.connectTimeout = Integer.parseInt(string);
        boolean bl2 = Boolean.parseBoolean((String)this.socketOptions.get(18));
        InetAddress[] inetAddressArray = InetAddress.getAllByName(this.host);
        if (bl2 && inetAddressArray.length > 1) {
            inetAddressArray = TcpNTAdapter.getAddressesInCircularOrder(this.host, inetAddressArray);
        }
        DownHostsCache.getInstance().reorderAddresses(inetAddressArray, this.port);
        int n2 = inetAddressArray.length;
        int n3 = 0;
        while (true) {
            InetAddress inetAddress = inetAddressArray[n3];
            ++n3;
            --n2;
            try {
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(false);
                this.selector = Selector.open();
                this.selectionKey = this.socketChannel.register(this.selector, 8);
                this.socketChannel.connect(new InetSocketAddress(inetAddress, this.port));
                if (this.selector.select(this.connectTimeout) == 0) {
                    throw new NetException(22);
                }
                Set<SelectionKey> set = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    if (selectionKey.isConnectable()) {
                        while (!this.socketChannel.finishConnect()) {
                        }
                    } else {
                        throw new NetException(24);
                    }
                    iterator.remove();
                }
                this.socket = this.socketChannel.socket();
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                if (this.selectionKey != null) {
                    this.selectionKey.cancel();
                }
                try {
                    if (this.socketChannel != null) {
                        this.socketChannel.close();
                    }
                }
                catch (Exception exception) {
                }
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                }
                try {
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (Exception exception) {
                }
                if (n2 > 0) continue;
                throw iOException;
                if (n3 < inetAddressArray.length) continue;
            }
            break;
        }
    }

    private void connectToRemoteQueue() throws IOException {
        try {
            if (!this.connectResponsePending) {
                this.writeLocalQueueNameOnSocket(this.localQueue);
            }
            do {
                BufferSequence bufferSequence = this.getNextMessage(true);
                ByteBuffer byteBuffer = bufferSequence.getBuffer(0);
                this.processNTMQLayer(byteBuffer);
                bufferSequence.dispose();
                if (!this.ntmqProtocolHandler.isDataPacket()) continue;
                throw new NetException(26, "ConnectPacket was expected");
            } while (!this.ntmqProtocolHandler.isConnectPacket());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new NetException(23);
        }
    }

    public void setSocketOptions() throws IOException {
        String string = (String)this.socketOptions.get(0);
        if (string != null) {
            this.setOption(0, string);
        }
        if ((string = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        if (this.remoteQueue != null) {
            try {
                while (this.remoteQueue.isWorkPending()) {
                    this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitWork);
                }
            }
            catch (IOException iOException) {
            }
            try {
                this.remoteQueue.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.remoteQueue = null;
            }
        }
        if (this.localQueue != null) {
            try {
                this.localQueue.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.localQueue = null;
            }
        }
        if (this.flowControl != null) {
            this.flowControl.onDisconnect(this.mqContext);
            this.flowControl = null;
        }
        if (this.dequedRcvBuf != null) {
            this.dequedRcvBuf.dispose();
            this.dequedRcvBuf = null;
        }
        if (this.socketChannel != null) {
            try {
                this.socketChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socketChannel = null;
            }
        }
        if (this.socket != null) {
            try {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.selector = null;
            }
        }
        if (this.mqContext != null) {
            try {
                this.mqContext.close();
            }
            catch (IOException iOException) {
            }
        }
        this.isConnected = false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 0: {
                String string = (String)object;
                this.socket.setTcpNoDelay(string.equals("YES"));
                break;
            }
            case 1: {
                String string = (String)object;
                if (!string.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: 
            case 101: {
                this.readTimeout = Integer.parseInt((String)object);
                this.socket.setSoTimeout(this.readTimeout);
                this.kernelWaitWork = this.readTimeout == 0 ? Integer.MAX_VALUE : this.readTimeout;
                this.kernelWaitSend = this.kernelWaitWork;
                break;
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 101: {
                return "" + this.readTimeout;
            }
            case 3: {
                return Integer.toString(this.socket.getSoTimeout());
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        this.ntmqProtocolHandler.prepareHeaderPacket(byteBuffer, (byte)5, (byte)0, null, false);
        this.socketChannel.write(byteBuffer);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.readTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return null;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.MSGQ;
    }

    public void onMessage(BufferSequence bufferSequence, IOException iOException) throws IOException {
        if (iOException != null) {
            if (this.ioExceptionWhileMSGQOp != null) {
                iOException.initCause(this.ioExceptionWhileMSGQOp);
            }
            this.ioExceptionWhileMSGQOp = iOException;
        }
        this.onMessageBufferList.add(bufferSequence);
        this.numberOfMessagesReceived.incrementAndGet();
        if (this.flowControlEnabled) {
            this.flowControl.onMessageReceived();
        } else {
            this.wakeupBuffer.put(0, (byte)1);
        }
        this.replenish();
    }

    private boolean isConnectionDead() throws IOException {
        if (!this.socketChannel.isOpen()) {
            return true;
        }
        if (this.socket.isClosed()) {
            return true;
        }
        if (this.socket.isInputShutdown()) {
            return true;
        }
        if (this.socket.isOutputShutdown()) {
            return true;
        }
        this.selectionKey.interestOps(1);
        if (this.selector.selectNow() > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                if (selectionKey.isReadable()) {
                    int n2 = this.socketChannel.read(this.bufferForDeathDetection);
                    if (n2 == -1) {
                        return true;
                    }
                    if (n2 > 0) {
                        throw new NetException(24);
                    }
                }
                iterator.remove();
            }
        }
        return false;
    }

    public void setNegotiatedSDUAndTDU(int n2, int n3) {
        this.sdu = n2;
        int n4 = Math.max(n3, n2 + 18);
        if (this.tdu != n4) {
            this.tdu = n4;
            this.drainBuffers = true;
        }
    }

    private int replenish() throws IOException {
        if (this.onMessageBufferList.size() >= 8) {
            return 0;
        }
        int n2 = this.localQueue.getAvailableReceiveSpaceMessageCount();
        if (this.drainBuffers) {
            if (n2 > 0) {
                return 0;
            }
            this.drainBuffers = false;
        }
        int n3 = 8 - n2;
        int n4 = 0;
        if (n3 > 0) {
            BufferSequence[] bufferSequenceArray = new BufferSequence[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                bufferSequenceArray[i2] = this.initReceiveBuffer();
            }
            n4 = this.localQueue.addMessageBuffers(bufferSequenceArray, 0, n3);
            if (n4 < n3) {
                for (BufferSequence bufferSequence : bufferSequenceArray) {
                    if (bufferSequence == null) continue;
                    bufferSequence.dispose();
                }
            }
            if (n4 > 0) {
                if (this.flowControlEnabled) {
                    this.flowControl.onBufferPosted(n4);
                }
                this.postCount += n4;
            }
        }
        return n4;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    private void prepareFlowControlPacket(ByteBuffer byteBuffer) throws IOException {
        if (this.flowControl == null) {
            this.flowControl = new MQLFlowControl(this.localQueue.getContext(), this.keyRegistry.getContext());
        }
        short s2 = (short)this.localQueue.getAvailableReceiveSpaceMessageCount();
        if (this.ntmqProtocolHandler.getPacketType() == 2 && this.ntmqProtocolHandler.getPacketFlag() == 8) {
            s2 = (short)(s2 - 1);
        }
        this.flowControl.setLocalPostCount(s2);
        this.flowControl.resetLocalFCB();
        RegistrationKey registrationKey = this.flowControl.getLocalFCBKey();
        this.ntmqProtocolHandler.appendFlowControlPacket(byteBuffer, true, s2, registrationKey.getRemoteVirtualAddress(), registrationKey.getKeyBuffer());
        this.postCount = 0;
    }

    private void scheduleInterrupt(int n2) {
        if (n2 > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread());
        }
    }

    private void handleInterrupt() throws IOException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("MSGQ read timed out");
        }
        throw new InterruptedIOException("Operation interrupted");
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    private void initBufferManager(InetAddress inetAddress) throws IOException {
        block10: {
            if (bufferManager != null) {
                return;
            }
            try (Monitor.CloseableLock closeableLock = BUFFER_MANAGER_INIT_MONITOR.acquireCloseableLock();){
                BufferManager bufferManager;
                if (MQLNTAdapter.bufferManager != null) break block10;
                if (null == System.getProperty(FMW_COMMONS_IP_PROP)) {
                    System.setProperty(FMW_COMMONS_IP_PROP, inetAddress.getHostAddress());
                }
                if ((bufferManager = BufferManagers.getNetworkDirectManager()) instanceof MultiInterfaceKeyRegistry) {
                    MQLNTAdapter.bufferManager = bufferManager;
                    break block10;
                }
                if (!Platform.getPlatform().isExaEnabled()) {
                    throw new IOException("This system is not recognized as an Exadirect enabled platform.");
                }
                throw new IOException("IP: " + inetAddress.getHostAddress() + " is not recognized as an RDMA enabled adapter.");
            }
        }
    }

    private void ensureConnection(boolean bl) throws IOException {
        if (this.ioExceptionWhileMSGQOp != null) {
            throw (IOException)new IOException(MSGQ_ERR_STATE_MSG).initCause(this.ioExceptionWhileMSGQOp);
        }
        if (bl && this.connectResponsePending) {
            this.connectToRemoteQueue();
        }
        if (!this.isConnected) {
            throw new NetException(200);
        }
    }

    private void initRemoteQueue() throws IOException {
        if (this.remoteQueue != null) {
            this.remoteQueue.close();
        }
        this.remoteQueue = this.mqContext.openRemoteQueue();
        this.remoteQueue.setWriteCallback(new RemoteQueue.WriteCallback(){

            public void onCompletion(Object object, IOException iOException) {
                if (iOException != null) {
                    if (MQLNTAdapter.this.ioExceptionWhileMSGQOp != null) {
                        iOException.initCause(MQLNTAdapter.this.ioExceptionWhileMSGQOp);
                    }
                    MQLNTAdapter.this.ioExceptionWhileMSGQOp = iOException;
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                }
                if (object != null) {
                    ((Disposable)object).dispose();
                }
                if (MQLNTAdapter.this.pendingSends == 0) {
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                }
            }
        });
    }

    public static final String packetToString(ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        char[] cArray = new char[8];
        int n3 = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            Object object = Integer.toHexString(by & 0xFF);
            if (((String)(object = ((String)object).toUpperCase())).length() == 1) {
                object = "0" + (String)object;
            }
            stringBuffer.append((String)object);
            stringBuffer.append(' ');
            cArray[n2] = by > 32 && by < 127 ? (int)by : 46;
            if (++n2 != 8) continue;
            stringBuffer.append('|');
            stringBuffer.append(cArray);
            stringBuffer.append('|');
            stringBuffer.append('\n');
            n2 = 0;
        }
        if (n2 != 0) {
            int n4;
            int n5 = 8 - n2;
            for (n4 = 0; n4 < n5 * 3; ++n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('|');
            stringBuffer.append(cArray, 0, n2);
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('|');
            stringBuffer.append('\n');
        }
        byteBuffer.position(n3);
        return stringBuffer.toString();
    }

    private static String dump(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        char[] cArray = new char[byteBuffer2.limit() * 3];
        int n2 = 0;
        String string = System.getProperty("line.separator");
        for (int i2 = 0; i2 < byteBuffer2.limit(); ++i2) {
            int n3 = byteBuffer2.get(i2) & 0xFF;
            cArray[i2 * 3] = hexArray[n3 >>> 4];
            cArray[i2 * 3 + 1] = hexArray[n3 & 0xF];
            if (++n2 % 8 == 0) {
                cArray[i2 * 3 + 2 + 0] = 10;
                continue;
            }
            cArray[i2 * 3 + 2] = 32;
        }
        return new String(cArray);
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

