/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.security.auth.DestroyFailedException;
import oracle.jdbc.AccessToken;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.sql.json.OracleJsonFactory;

public final class JsonWebToken
implements AccessToken {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private final OpaqueString token;
    private final OpaqueString privateKey;
    private final long exp;
    private static final byte[] BEGIN_PRIVATE_KEY_UTF8 = "-----BEGIN PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
    private static final byte[] END_PRIVATE_KEY_UTF8 = "-----END PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LINE_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);

    private JsonWebToken(@Blind OpaqueString opaqueString, @Blind OpaqueString opaqueString2) {
        this.token = opaqueString;
        this.privateKey = opaqueString2;
        this.exp = opaqueString.map(JsonWebToken::parseExp);
    }

    public OpaqueString token() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    public byte[] sign(@Blind byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        if (this.privateKey == null) {
            return null;
        }
        PrivateKey privateKey = JsonWebToken.decodeKey(this.privateKey);
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return byArray2;
        }
        finally {
            JsonWebToken.tryDestroyKey(privateKey);
        }
    }

    public long exp() {
        return this.exp;
    }

    @Blind
    public String toString() {
        return super.toString();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JsonWebToken && Objects.equals(this.token, ((JsonWebToken)object).token) && Objects.equals(this.privateKey, ((JsonWebToken)object).privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.privateKey);
    }

    @Blind
    static JsonWebToken fromFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(JsonWebToken.readTokenFile(path.resolve("token")), JsonWebToken.readPemFile(path.resolve("oci_db_key.pem")));
    }

    @Blind
    public static JsonWebToken createProofOfPossessionToken(@Blind char[] cArray, @Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(OpaqueString.newOpaqueString(cArray), JsonWebToken.encodeKey(privateKey));
    }

    @Blind
    public static JsonWebToken createBearerToken(@Blind char[] cArray) {
        return new JsonWebToken(OpaqueString.newOpaqueString(cArray), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString readTokenFile(Path path) throws IOException {
        byte[] byArray = Files.readAllBytes(path);
        try {
            OpaqueString opaqueString;
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byArray));
            try {
                char[] cArray = new char[charBuffer.remaining()];
                charBuffer.get(cArray);
                opaqueString = OpaqueString.newOpaqueString(cArray);
                charBuffer.clear().put(new char[charBuffer.remaining()]);
            }
            catch (Throwable throwable) {
                charBuffer.clear().put(new char[charBuffer.remaining()]);
                throw throwable;
            }
            return opaqueString;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString readPemFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] byArray = Files.readAllBytes(path);
        try {
            OpaqueString opaqueString;
            int n2 = JsonWebToken.findTag(byArray, 0, BEGIN_PRIVATE_KEY_UTF8);
            if (n2 == -1) {
                throw new IOException(path + " does not contain: " + new String(BEGIN_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            int n3 = n2 + BEGIN_PRIVATE_KEY_UTF8.length + LINE_SEPARATOR.length;
            int n4 = JsonWebToken.findTag(byArray, n3, END_PRIVATE_KEY_UTF8);
            if (n4 == -1) {
                throw new IOException(path + " does not contain: " + new String(END_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            byte[] byArray2 = Arrays.copyOfRange(byArray, n3, n4);
            try {
                opaqueString = JsonWebToken.decodeBase64Key(byArray2);
            }
            catch (Throwable throwable) {
                Arrays.fill(byArray2, (byte)0);
                throw throwable;
            }
            Arrays.fill(byArray2, (byte)0);
            return opaqueString;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString decodeBase64Key(@Blind byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] byArray2 = Base64.getMimeDecoder().decode(byArray);
        try {
            OpaqueString opaqueString;
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            try {
                opaqueString = JsonWebToken.encodeKey(privateKey);
            }
            catch (Throwable throwable) {
                JsonWebToken.tryDestroyKey(privateKey);
                throw throwable;
            }
            JsonWebToken.tryDestroyKey(privateKey);
            return opaqueString;
        }
        finally {
            Arrays.fill(byArray2, (byte)0);
        }
    }

    private static int findTag(@Blind byte[] byArray, int n2, byte[] byArray2) {
        while (n2 < byArray.length) {
            if (JsonWebToken.arrayEquals(byArray, n2, byArray2)) {
                return n2;
            }
            int n3 = JsonWebToken.arrayIndexOf(byArray, n2, LINE_SEPARATOR);
            if (n3 == -1) break;
            n2 = n3 + 1;
        }
        return -1;
    }

    private static int arrayIndexOf(@Blind byte[] byArray, int n2, byte[] byArray2) {
        for (int i2 = n2; i2 < byArray.length; ++i2) {
            if (!JsonWebToken.arrayEquals(byArray, i2, byArray2)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean arrayEquals(@Blind byte[] byArray, int n2, byte[] byArray2) {
        if (n2 + byArray2.length > byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2 + n2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString encodeKey(@Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] byArray = KeyFactory.getInstance("RSA").getKeySpec(privateKey, PKCS8EncodedKeySpec.class).getEncoded();
        try {
            char[] cArray = new char[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                cArray[i2] = (char)byArray[i2];
            }
            OpaqueString opaqueString = OpaqueString.newOpaqueString(cArray);
            return opaqueString;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static PrivateKey decodeKey(@Blind OpaqueString opaqueString) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] cArray = opaqueString.getChars();
        try {
            PrivateKey privateKey;
            byte[] byArray = new byte[cArray.length];
            try {
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    byArray[i2] = (byte)cArray[i2];
                }
                privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (Throwable throwable) {
                Arrays.fill(byArray, (byte)0);
                throw throwable;
            }
            Arrays.fill(byArray, (byte)0);
            return privateKey;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    private static void tryDestroyKey(@Blind PrivateKey privateKey) {
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static long parseExp(@Blind char[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

