/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.util;

import java.io.IOException;
import java.util.Enumeration;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public final class WalletUtils {
    private static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
    private static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
    private static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
    private static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
    private static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";

    private WalletUtils() {
    }

    public static Credentials getCredentials(byte[] walletBytes, char[] walletPassword, String connectionStringIndex) {
        OracleWallet wallet = new OracleWallet();
        try {
            wallet.setWalletArray(walletBytes, walletPassword);
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failed to open wallet", ioException);
        }
        try {
            OracleSecretStore secretStore = wallet.getSecretStore();
            String username = null;
            char[] password = null;
            if (connectionStringIndex == null && secretStore.containsAlias(SECRET_STORE_DEFAULT_USERNAME) && secretStore.containsAlias(SECRET_STORE_DEFAULT_PASSWORD)) {
                username = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_USERNAME));
                password = secretStore.getSecret(SECRET_STORE_DEFAULT_PASSWORD);
                return new Credentials(username, password);
            }
            Enumeration aliases = secretStore.internalAliases();
            int connectionCount = 0;
            while (aliases.hasMoreElements()) {
                String alias = (String)aliases.nextElement();
                if (!alias.startsWith(SECRET_STORE_CONNECT)) continue;
                String idx = alias.substring(SECRET_STORE_CONNECT.length());
                if (connectionStringIndex != null) {
                    if (!idx.equals(connectionStringIndex)) continue;
                    username = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                    password = secretStore.getSecret(SECRET_STORE_PASSWORD + idx);
                    return new Credentials(username, password);
                }
                if (++connectionCount == 1) {
                    username = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                    password = secretStore.getSecret(SECRET_STORE_PASSWORD + idx);
                    continue;
                }
                throw new IllegalStateException("Multiple connection strings found in wallet. Specify a connectionStringIndex to select one.");
            }
            if (connectionStringIndex != null) {
                throw new IllegalStateException("No connection string found with index: " + connectionStringIndex);
            }
            return new Credentials(username, password);
        }
        catch (IOException | OracleSecretStoreException exception) {
            throw new IllegalStateException("Failed to extract credentials from wallet", exception);
        }
    }

    public static final class Credentials {
        final String username;
        final char[] password;

        Credentials(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        public String username() {
            return this.username;
        }

        public char[] password() {
            return this.password;
        }
    }
}

