/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.factory;

import java.time.OffsetDateTime;
import java.util.Objects;
import oracle.jdbc.provider.factory.ExpiringResource;
import oracle.jdbc.provider.factory.PermanentResource;

public interface Resource<T> {
    public T getContent();

    public boolean isSensitive();

    public boolean isValid();

    public static <T> Resource<T> createExpiringResource(T content, OffsetDateTime expireTime, boolean isSensitive) {
        Objects.requireNonNull(content, "value is null");
        Objects.requireNonNull(expireTime, "expireTime is null");
        return new ExpiringResource<T>(content, expireTime, isSensitive);
    }

    public static <T> Resource<T> createPermanentResource(T value, boolean isSensitive) {
        Objects.requireNonNull(value, "value is null");
        return new PermanentResource<T>(value, isSensitive);
    }
}

