/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.scope.CoreUtilsCommand;
import com.opera.core.systems.scope.DesktopWindowManagerCommand;
import com.opera.core.systems.scope.ESDebuggerCommand;
import com.opera.core.systems.scope.SelftestCommand;
import com.opera.core.systems.scope.WindowManagerCommand;
import com.opera.core.systems.scope.handlers.AbstractEventHandler;
import com.opera.core.systems.scope.protos.ConsoleLoggerProtos;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.HttpLoggerProtos;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.protos.WmProtos;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmsEventParser {
    private AbstractEventHandler eventHandler;

    public UmsEventParser(AbstractEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void handleEvent(UmsProtos.Event event) {
        String service = event.getService();
        int eventId = event.getCommandID();
        if (service.equals("ecmascript-debugger")) {
            switch (ESDebuggerCommand.get(eventId)) {
                case RUNTIME_STARTED: {
                    EsdbgProtos.RuntimeInfo.Builder infoBuilder = EsdbgProtos.RuntimeInfo.newBuilder();
                    this.buildPayload(event, infoBuilder);
                    this.eventHandler.onRuntimeStarted(infoBuilder.build());
                    break;
                }
                case RUNTIME_STOPPED: {
                    EsdbgProtos.RuntimeID.Builder idBuilder = EsdbgProtos.RuntimeID.newBuilder();
                    this.buildPayload(event, idBuilder);
                    Integer id = idBuilder.build().getRuntimeID();
                    this.eventHandler.onRuntimeStopped(id);
                    break;
                }
            }
        } else if (service.equals("window-manager")) {
            switch (WindowManagerCommand.get(eventId)) {
                case WINDOW_ACTIVATED: {
                    WmProtos.WindowID.Builder activeWindowIdBuilder = WmProtos.WindowID.newBuilder();
                    this.buildPayload(event, activeWindowIdBuilder);
                    Integer activeWindowID = activeWindowIdBuilder.build().getWindowID();
                    this.eventHandler.onActiveWindow(activeWindowID);
                    break;
                }
                case WINDOW_CLOSED: {
                    WmProtos.WindowID.Builder closedWindowBuilder = WmProtos.WindowID.newBuilder();
                    this.buildPayload(event, closedWindowBuilder);
                    Integer closedWindowID = closedWindowBuilder.build().getWindowID();
                    this.eventHandler.onWindowClosed(closedWindowID);
                    break;
                }
                case WINDOW_UPDATED: {
                    WmProtos.WindowInfo.Builder windowInfoBuilder = WmProtos.WindowInfo.newBuilder();
                    this.buildPayload(event, windowInfoBuilder);
                    WmProtos.WindowInfo info = windowInfoBuilder.build();
                    this.eventHandler.onUpdatedWindow(info);
                    break;
                }
                case WINDOW_LOADED: {
                    WmProtos.WindowID.Builder loadedWindowBuilder = WmProtos.WindowID.newBuilder();
                    this.buildPayload(event, loadedWindowBuilder);
                    Integer loadedWindowID = loadedWindowBuilder.build().getWindowID();
                    this.eventHandler.onWindowLoaded(loadedWindowID);
                    break;
                }
            }
        } else if (service.equals("desktop-window-manager")) {
            switch (DesktopWindowManagerCommand.get(eventId)) {
                case WINDOW_SHOWN: {
                    DesktopWmProtos.DesktopWindowInfo.Builder shownDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, shownDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_shown = shownDWBuilder.build();
                    this.eventHandler.onDesktopWindowShown(info_shown);
                    break;
                }
                case WINDOW_UPDATED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder updatedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, updatedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_updated = updatedDWBuilder.build();
                    this.eventHandler.onDesktopWindowUpdated(info_updated);
                    break;
                }
                case WINDOW_ACTIVATED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder activatedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, activatedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_activated = activatedDWBuilder.build();
                    this.eventHandler.onDesktopWindowActivated(info_activated);
                    break;
                }
                case WINDOW_CLOSED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder closedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, closedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_closed = closedDWBuilder.build();
                    this.eventHandler.onDesktopWindowClosed(info_closed);
                    break;
                }
                case WINDOW_LOADED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder loadedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, loadedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_loaded = loadedDWBuilder.build();
                    this.eventHandler.onDesktopWindowLoaded(info_loaded);
                    break;
                }
                case MENU_SHOWN: {
                    DesktopWmProtos.QuickMenuInfo.Builder shownQMBuilder = DesktopWmProtos.QuickMenuInfo.newBuilder();
                    this.buildPayload(event, shownQMBuilder);
                    DesktopWmProtos.QuickMenuInfo menuInfoShown = shownQMBuilder.build();
                    this.eventHandler.onQuickMenuShown(menuInfoShown);
                    break;
                }
                case MENU_CLOSED: {
                    DesktopWmProtos.QuickMenuID.Builder closedQMBuilder = DesktopWmProtos.QuickMenuID.newBuilder();
                    this.buildPayload(event, closedQMBuilder);
                    DesktopWmProtos.QuickMenuID menuId = closedQMBuilder.build();
                    this.eventHandler.onQuickMenuClosed(menuId);
                    break;
                }
                case MENU_PRESSED: {
                    DesktopWmProtos.QuickMenuItemID.Builder pressedQMIBuilder = DesktopWmProtos.QuickMenuItemID.newBuilder();
                    this.buildPayload(event, pressedQMIBuilder);
                    DesktopWmProtos.QuickMenuItemID menuItemID = pressedQMIBuilder.build();
                    this.eventHandler.onQuickMenuItemPressed(menuItemID);
                    break;
                }
            }
        } else if (service.equals("console-logger")) {
            ConsoleLoggerProtos.ConsoleMessage.Builder messageBuilder = ConsoleLoggerProtos.ConsoleMessage.newBuilder();
            this.buildPayload(event, messageBuilder);
            this.eventHandler.onMessage(messageBuilder.build());
        } else if (service.equals("ecmascript")) {
            EcmascriptProtos.ReadyStateChange.Builder builder = EcmascriptProtos.ReadyStateChange.newBuilder();
            this.buildPayload(event, builder);
            this.eventHandler.onReadyStateChange(builder.build());
        } else if (service.equals("http-logger") && eventId == 1) {
            HttpLoggerProtos.Header header;
            try {
                header = HttpLoggerProtos.Header.parseFrom(event.getPayload());
            }
            catch (InvalidProtocolBufferException e) {
                throw new WebDriverException("Exception while parsing event");
            }
            this.eventHandler.onRequest(header.getWindowID());
        } else if (service.equals("core")) {
            switch (CoreUtilsCommand.get(eventId)) {
                case ONACTIVE: {
                    break;
                }
                case ONIDLE: {
                    this.eventHandler.onOperaIdle();
                }
            }
        } else if (service.equals("selftest")) {
            switch (SelftestCommand.get(eventId)) {
                case OUTPUT: {
                    SelftestProtos.SelftestOutput.Builder builder = SelftestProtos.SelftestOutput.newBuilder();
                    this.buildPayload(event, builder);
                    this.eventHandler.onSelftestOutput(builder.build());
                    break;
                }
                case FINISHED: {
                    this.eventHandler.onSelftestDone();
                }
            }
        }
    }

    private final GeneratedMessage.Builder<?> buildPayload(UmsProtos.Event event, GeneratedMessage.Builder<?> builder) {
        return this.buildMessage(builder, event.getPayload().toByteArray());
    }

    private final GeneratedMessage.Builder<?> buildMessage(GeneratedMessage.Builder<?> builder, byte[] message) {
        try {
            return (GeneratedMessage.Builder)builder.mergeFrom(message);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new WebDriverException("Could not build " + builder.getDescriptorForType().getFullName() + " : " + ex.getMessage());
        }
    }
}

