/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WindowManagerCommand implements ICommand
{
    GET_ACTIVE_WINDOW(1),
    LIST_WINDOWS(2),
    MODIFY_FILTER(3),
    WINDOW_UPDATED(4),
    WINDOW_CLOSED(5),
    WINDOW_ACTIVATED(6),
    WINDOW_LOADED(7),
    CREATE_WINDOW(8),
    CLOSE_WINDOW(9),
    OPEN_URL(10),
    MODIFY_TYPE_FILTER(11),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, WindowManagerCommand> lookup;

    private WindowManagerCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "window-manager";
    }

    public static WindowManagerCommand get(int code) {
        WindowManagerCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, WindowManagerCommand>();
        for (WindowManagerCommand command : EnumSet.allOf(WindowManagerCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

