/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.Point;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.internal.Coordinates;

public class OperaMouse
implements Mouse {
    private final OperaDriver parent;
    private Point lastMousePosition;

    public OperaMouse(OperaDriver parent) {
        this.parent = parent;
    }

    public void click(Coordinates where) {
        Point p = this.getPoint(where, "click");
        this.parent.exec.mouseAction(p.x, p.y, OperaMouseKeys.LEFT);
    }

    public void contextClick(Coordinates where) {
        Point p = this.getPoint(where, "context click");
        this.parent.exec.mouseAction(p.x, p.y, OperaMouseKeys.RIGHT);
    }

    public void doubleClick(Coordinates where) {
        Point p = this.getPoint(where, "double click");
        this.parent.exec.mouseAction(p.x, p.y, 2, OperaMouseKeys.LEFT);
    }

    public void mouseDown(Coordinates where) {
        Point p = this.getPoint(where, "mouse down");
        this.parent.exec.mouseAction(p.x, p.y, OperaMouseKeys.LEFT_DOWN);
    }

    public void mouseUp(Coordinates where) {
        Point p = this.getPoint(where, "mouse up");
        this.parent.exec.mouseAction(p.x, p.y, OperaMouseKeys.LEFT_DOWN);
    }

    public void mouseMove(Coordinates where) {
        Point p = this.getPoint(where, "mouse move");
        this.parent.exec.mouseAction(p.x, p.y, new OperaMouseKeys[0]);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        Point p = this.getPoint(where, "mouse move");
        int xO = (int)xOffset;
        int yO = (int)yOffset;
        this.lastMousePosition = new Point(p.x + xO, p.y + yO);
        this.parent.exec.mouseAction(p.x + xO, p.y + yO, new OperaMouseKeys[0]);
    }

    private Point getPoint(Coordinates where, String action) {
        if (where != null) {
            this.lastMousePosition = where.getLocationInViewPort();
        }
        if (this.lastMousePosition != null) {
            return this.lastMousePosition;
        }
        throw new InvalidCoordinatesException("Invalid coordinates to " + action + " on");
    }
}

