/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.handlers.AbstractEventHandler;
import com.opera.core.systems.scope.protos.ConsoleLoggerProtos;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.WmProtos;

public class EventHandler
extends AbstractEventHandler {
    protected ScopeServices services;

    public EventHandler(ScopeServices services) {
        super(services);
        this.services = services;
    }

    public void onActiveWindow(Integer id) {
        this.services.getWindowManager().setActiveWindowId(id);
    }

    public void onRuntimeStopped(Integer id) {
        this.services.getDebugger().removeRuntime(id);
    }

    public void onRequest(int windowId) {
        this.services.onRequest(windowId);
    }

    public void onWindowClosed(Integer id) {
        this.services.onWindowClosed(id);
        this.services.getWindowManager().removeWindow(id);
        this.services.getDebugger().cleanUpRuntimes(id);
    }

    public void onWindowLoaded(int windowId) {
        this.services.getDebugger().cleanUpRuntimes(windowId);
        this.services.onWindowLoaded(windowId);
    }

    public void onOperaIdle() {
        this.services.onOperaIdle();
    }

    public void onRuntimeStarted(EsdbgProtos.RuntimeInfo started) {
        throw new UnsupportedOperationException("Not supported in STP/0");
    }

    public void onUpdatedWindow(WmProtos.WindowInfo window) {
        throw new UnsupportedOperationException("Not supported in STP/0");
    }

    public void onMessage(ConsoleLoggerProtos.ConsoleMessage message) {
        throw new UnsupportedOperationException("Not supported in STP/0");
    }

    public void onHttpResponse(int responseCode) {
        this.services.getWindowManager().getLastHttpResponseCode().compareAndSet(0, responseCode);
    }

    public void onReadyStateChange(EcmascriptProtos.ReadyStateChange change) {
        throw new UnsupportedOperationException("Not supported in STP/0");
    }

    public void onDesktopWindowShown(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowShown(info);
    }

    public void onDesktopWindowUpdated(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowUpdated(info);
    }

    public void onDesktopWindowActivated(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowActivated(info);
    }

    public void onDesktopWindowClosed(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowClosed(info);
    }

    public void onDesktopWindowLoaded(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowLoaded(info);
    }

    public void onQuickMenuShown(DesktopWmProtos.QuickMenuInfo menuInfoShown) {
        this.services.onQuickMenuShown(menuInfoShown);
    }

    public void onQuickMenuClosed(DesktopWmProtos.QuickMenuID menuId) {
        this.services.onQuickMenuClosed(menuId);
    }

    public void onQuickMenuItemPressed(DesktopWmProtos.QuickMenuItemID menuItemID) {
        this.services.onQuickMenuItemPressed(menuItemID);
    }

    public void onSelftestOutput(SelftestProtos.SelftestOutput output) {
        this.services.onSelftestOutput(output);
    }

    public void onSelftestDone() {
        this.services.onSelftestDone();
    }
}

