/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorFactory {
    private static Map validators = new HashMap();
    private static Log LOG = LogFactory.getLog(ValidatorFactory.class);

    private ValidatorFactory() {
    }

    public static Validator getValidator(ValidatorConfig cfg) {
        return ValidatorFactory.getValidator(cfg, ObjectFactory.getObjectFactory());
    }

    public static Validator getValidator(ValidatorConfig cfg, ObjectFactory objectFactory) {
        Validator validator;
        String className = ValidatorFactory.lookupRegisteredValidatorType(cfg.getType());
        try {
            validator = objectFactory.buildValidator(className, cfg.getParams(), null);
        }
        catch (Exception e) {
            String msg = "There was a problem creating a Validator of type " + className + " : caused by " + e.getMessage();
            throw new XWorkException(msg, e, cfg);
        }
        validator.setMessageKey(cfg.getMessageKey());
        validator.setDefaultMessage(cfg.getDefaultMessage());
        if (validator instanceof ShortCircuitableValidator) {
            ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(cfg.isShortCircuit());
        }
        return validator;
    }

    public static void registerValidator(String name, String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering validator of class " + className + " with name " + name));
        }
        validators.put(name, className);
    }

    public static String lookupRegisteredValidatorType(String name) {
        String className = (String)validators.get(name);
        if (className == null) {
            throw new IllegalArgumentException("There is no validator class mapped to the name " + name);
        }
        return className;
    }

    private static void parseValidators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading validator definitions.");
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            Iterator<URL> urls = ClassLoaderUtil.getResources("", ValidatorFactory.class, false);
            while (urls.hasNext()) {
                URL u = urls.next();
                try {
                    URI uri = new URI(u.toExternalForm().replaceAll(" ", "%20"));
                    if (!"file".equalsIgnoreCase(uri.getScheme())) continue;
                    File f = new File(uri);
                    FilenameFilter filter = new FilenameFilter(){

                        public boolean accept(File file, String fileName) {
                            return fileName.contains("-validators.xml");
                        }
                    };
                    files.addAll(Arrays.asList(f.listFiles(filter)));
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to load " + u.toString()), (Throwable)ex);
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load validator files", e);
        }
        String resourceName = "com/opensymphony/xwork2/validator/validators/default.xml";
        ValidatorFactory.retrieveValidatorConfiguration(resourceName);
        resourceName = "validators.xml";
        ValidatorFactory.retrieveValidatorConfiguration(resourceName);
        for (File file : files) {
            ValidatorFactory.retrieveValidatorConfiguration(file.getName());
        }
    }

    private static void retrieveValidatorConfiguration(String resourceName) {
        InputStream is = ClassLoaderUtil.getResourceAsStream(resourceName, ValidatorFactory.class);
        if (is != null) {
            ValidatorFileParser.parseValidatorDefinitions(is, resourceName);
        }
    }

    static {
        ValidatorFactory.parseValidators();
    }
}

