/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.layout.CollapsedBorderSide;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.newtable.CollapsedBorderValue;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListOperation;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.render.displaylist.PaintBackgroundAndBorders;
import com.openhtmltopdf.render.displaylist.PaintFixedLayer;
import com.openhtmltopdf.render.displaylist.PaintInlineContent;
import com.openhtmltopdf.render.displaylist.PaintLayerBackgroundAndBorder;
import com.openhtmltopdf.render.displaylist.PaintListMarkers;
import com.openhtmltopdf.render.displaylist.PaintPopClipLayer;
import com.openhtmltopdf.render.displaylist.PaintPopTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintPushClipLayer;
import com.openhtmltopdf.render.displaylist.PaintPushTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintReplacedElement;
import com.openhtmltopdf.render.displaylist.PaintReplacedElements;
import com.openhtmltopdf.render.displaylist.PaintRootElementBackground;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DisplayListCollector {
    private final List<PageBox> _pages;

    public DisplayListCollector(List<PageBox> pages) {
        this._pages = pages;
    }

    private void collectLayers(RenderingContext c, List<Layer> layers, DisplayListContainer dlPages, boolean includeFixed) {
        for (Layer layer : layers) {
            this.collect(c, layer, dlPages, includeFixed);
        }
    }

    protected void addItem(DisplayListOperation item, int pgStart, int pgEnd, DisplayListContainer dlPages) {
        for (int i = pgStart; i <= pgEnd; ++i) {
            if (i < 0 || i >= dlPages.getNumPages()) continue;
            dlPages.getPageInstructions(i).addOp(item);
        }
    }

    public DisplayListContainer collectRoot(RenderingContext c, Layer rootLayer) {
        if (!rootLayer.isRootLayer()) {
            return null;
        }
        rootLayer.propagateCurrentTransformationMatrix(c);
        DisplayListContainer displayList = new DisplayListContainer(this._pages.size());
        this.collect(c, rootLayer, displayList, false);
        return displayList;
    }

    protected void collect(RenderingContext c, Layer layer, DisplayListContainer dlPages, boolean includeFixed) {
        DisplayListOperation dlo;
        if (layer.getMaster().getStyle().isFixed() && !includeFixed) {
            PaintFixedLayer dlo2 = new PaintFixedLayer(layer);
            this.addItem(dlo2, 0, this._pages.size() - 1, dlPages);
            return;
        }
        int layerPageStart = -1;
        int layerPageEnd = -1;
        if (!layer.getClipBoxes().isEmpty() && !layer.getMaster().getStyle().isPositioned() || layer.hasLocalTransform()) {
            layerPageStart = this.findStartPage(c, layer);
            layerPageEnd = this.findEndPage(c, layer);
        }
        if (!layer.getMaster().getStyle().isPositioned() && !layer.getClipBoxes().isEmpty()) {
            dlo = new PaintPushClipLayer(layer.getClipBoxes());
            this.addItem(dlo, layerPageStart, layerPageEnd, dlPages);
        }
        if (layer.hasLocalTransform()) {
            dlo = new PaintPushTransformLayer(layer.getMaster());
            this.addItem(dlo, layerPageStart, layerPageEnd, dlPages);
        }
        if (layer.isRootLayer() && layer.getMaster().hasRootElementBackground(c)) {
            dlo = new PaintRootElementBackground(layer.getMaster());
            this.addItem(dlo, 0, dlPages.getNumPages() - 1, dlPages);
        }
        if (!layer.isInline() && ((BlockBox)layer.getMaster()).isReplaced()) {
            this.collectReplacedElementLayer(c, layer, dlPages);
        } else {
            PagedBoxCollector collector = this.createBoxCollector();
            collector.collect(c, layer);
            if (!layer.isInline() && layer.getMaster() instanceof BlockBox) {
                this.collectLayerBackgroundAndBorder(c, layer, dlPages);
            }
            if (layer.isRootLayer() || layer.isStackingContext()) {
                this.collectLayers(c, layer.getSortedLayers(3), dlPages, includeFixed);
            }
            List<PagedBoxCollector.PageResult> pgResults = collector.getCollectedPageResults();
            for (int i = 0; i < pgResults.size(); ++i) {
                PagedBoxCollector.PageResult pg = pgResults.get(i);
                DisplayListContainer.DisplayListPageContainer dlPageList = dlPages.getPageInstructions(i);
                this.processPage(c, layer, dlPages, pg, dlPageList, true);
            }
            if (layer.isRootLayer() || layer.isStackingContext()) {
                this.collectLayers(c, layer.collectLayers(4), dlPages, includeFixed);
                this.collectLayers(c, layer.getSortedLayers(2), dlPages, includeFixed);
                this.collectLayers(c, layer.getSortedLayers(1), dlPages, includeFixed);
            }
        }
        if (layer.hasLocalTransform()) {
            dlo = new PaintPopTransformLayer(layer.getMaster());
            this.addItem(dlo, layerPageStart, layerPageEnd, dlPages);
        }
        if (!layer.getMaster().getStyle().isPositioned() && !layer.getClipBoxes().isEmpty()) {
            dlo = new PaintPopClipLayer(layer.getClipBoxes());
            this.addItem(dlo, layerPageStart, layerPageEnd, dlPages);
        }
    }

    private void processPage(RenderingContext c, Layer layer, DisplayListContainer dlPages, PagedBoxCollector.PageResult pg, DisplayListContainer.DisplayListPageContainer dlPageList, boolean includeFloats) {
        DisplayListOperation dlo;
        if (!pg.blocks().isEmpty()) {
            Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders = pg.tcells().isEmpty() ? null : this.collectCollapsedTableBorders(c, pg.tcells());
            PaintBackgroundAndBorders dlo2 = new PaintBackgroundAndBorders(pg.blocks(), collapsedTableBorders);
            dlPageList.addOp(dlo2);
        }
        if (includeFloats && layer.getFloats() != null && !layer.getFloats().isEmpty()) {
            for (int iflt = layer.getFloats().size() - 1; iflt >= 0; --iflt) {
                BlockBox floater = (BlockBox)layer.getFloats().get(iflt);
                this.collectFloatAsLayer(c, layer, floater, dlPages);
            }
        }
        if (!pg.listItems().isEmpty()) {
            dlo = new PaintListMarkers(pg.listItems());
            dlPageList.addOp(dlo);
        }
        if (!pg.inlines().isEmpty()) {
            dlo = new PaintInlineContent(pg.inlines());
            dlPageList.addOp(dlo);
        }
        if (!pg.replaceds().isEmpty()) {
            dlo = new PaintReplacedElements(pg.replaceds());
            dlPageList.addOp(dlo);
        }
    }

    private void collectFloatAsLayer(RenderingContext c, Layer layer, BlockBox startingPoint, DisplayListContainer dlPages) {
        PagedBoxCollector collector = this.createBoxCollector();
        collector.collect(c, layer, startingPoint);
        List<PagedBoxCollector.PageResult> pgResults = collector.getCollectedPageResults();
        for (int i = 0; i < pgResults.size(); ++i) {
            PagedBoxCollector.PageResult pg = pgResults.get(i);
            DisplayListContainer.DisplayListPageContainer dlPageList = dlPages.getPageInstructions(i);
            this.processPage(c, layer, dlPages, pg, dlPageList, false);
        }
    }

    private void collectLayerBackgroundAndBorder(RenderingContext c, Layer layer, DisplayListContainer dlPages) {
        PaintLayerBackgroundAndBorder dlo = new PaintLayerBackgroundAndBorder(layer.getMaster());
        int pgStart = this.findStartPage(c, layer);
        int pgEnd = this.findEndPage(c, layer);
        this.addItem(dlo, pgStart, pgEnd, dlPages);
    }

    private void collectReplacedElementLayer(RenderingContext c, Layer layer, DisplayListContainer dlPages) {
        PaintLayerBackgroundAndBorder dlo = new PaintLayerBackgroundAndBorder(layer.getMaster());
        int pgStart = this.findStartPage(c, layer);
        int pgEnd = this.findEndPage(c, layer);
        this.addItem(dlo, pgStart, pgEnd, dlPages);
        PaintReplacedElement dlo2 = new PaintReplacedElement((BlockBox)layer.getMaster());
        this.addItem(dlo2, pgStart, pgEnd, dlPages);
    }

    private Map<TableCellBox, List<CollapsedBorderSide>> collectCollapsedTableBorders(RenderingContext c, List<TableCellBox> tcells) {
        HashMap<TableBox, ArrayList<CollapsedBorderSide>> cellBordersByTable = new HashMap<TableBox, ArrayList<CollapsedBorderSide>>();
        HashMap<TableBox, TableCellBox> triggerCellsByTable = new HashMap<TableBox, TableCellBox>();
        HashSet<CollapsedBorderValue> all = new HashSet<CollapsedBorderValue>(0);
        for (TableCellBox cell : tcells) {
            ArrayList<CollapsedBorderSide> borders = (ArrayList<CollapsedBorderSide>)cellBordersByTable.get(cell.getTable());
            if (borders == null) {
                borders = new ArrayList<CollapsedBorderSide>();
                cellBordersByTable.put(cell.getTable(), borders);
            }
            triggerCellsByTable.put(cell.getTable(), cell);
            cell.addCollapsedBorders(all, borders);
        }
        if (triggerCellsByTable.isEmpty()) {
            return null;
        }
        HashMap<TableCellBox, List<CollapsedBorderSide>> result = new HashMap<TableCellBox, List<CollapsedBorderSide>>(triggerCellsByTable.size());
        for (TableCellBox cell : triggerCellsByTable.values()) {
            List borders = (List)cellBordersByTable.get(cell.getTable());
            Collections.sort(borders);
            result.put(cell, borders);
        }
        return result;
    }

    protected PagedBoxCollector createBoxCollector() {
        return new PagedBoxCollector(this._pages);
    }

    protected int findStartPage(RenderingContext c, Layer layer) {
        return PagedBoxCollector.findStartPage(c, layer.getMaster(), this._pages);
    }

    protected int findEndPage(RenderingContext c, Layer layer) {
        return PagedBoxCollector.findEndPage(c, layer.getMaster(), this._pages);
    }
}

