/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface.interpolator;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.surface.interpolator.BoundSurfaceInterpolator;
import com.opengamma.strata.market.surface.interpolator.SurfaceInterpolator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class GridSurfaceInterpolator
implements SurfaceInterpolator,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final CurveInterpolator xInterpolator;
    @PropertyDefinition
    private final CurveExtrapolator xExtrapolatorLeft;
    @PropertyDefinition
    private final CurveExtrapolator xExtrapolatorRight;
    @PropertyDefinition
    private final CurveInterpolator yInterpolator;
    @PropertyDefinition
    private final CurveExtrapolator yExtrapolatorLeft;
    @PropertyDefinition
    private final CurveExtrapolator yExtrapolatorRight;
    private static final long serialVersionUID = 1L;

    public static GridSurfaceInterpolator of(CurveInterpolator xInterpolator, CurveInterpolator yInterpolator) {
        return new GridSurfaceInterpolator(xInterpolator, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, yInterpolator, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT);
    }

    public static GridSurfaceInterpolator of(CurveInterpolator xInterpolator, CurveExtrapolator xExtrapolator, CurveInterpolator yInterpolator, CurveExtrapolator yExtrapolator) {
        return new GridSurfaceInterpolator(xInterpolator, xExtrapolator, xExtrapolator, yInterpolator, yExtrapolator, yExtrapolator);
    }

    public static GridSurfaceInterpolator of(CurveInterpolator xInterpolator, CurveExtrapolator xExtrapolatorLeft, CurveExtrapolator xExtrapolatorRight, CurveInterpolator yInterpolator, CurveExtrapolator yExtrapolatorLeft, CurveExtrapolator yExtrapolatorRight) {
        return new GridSurfaceInterpolator(xInterpolator, xExtrapolatorLeft, xExtrapolatorRight, yInterpolator, yExtrapolatorLeft, yExtrapolatorRight);
    }

    @Override
    public BoundSurfaceInterpolator bind(DoubleArray xValues, DoubleArray yValues, DoubleArray zValues) {
        int size = xValues.size();
        int countUniqueX = 0;
        double[] uniqueX = new double[size];
        double[] tempY = new double[size];
        double[] tempZ = new double[size];
        ImmutableList.Builder yInterpBuilder = ImmutableList.builder();
        int i = 0;
        while (i < size) {
            double currentX;
            uniqueX[countUniqueX] = currentX = xValues.get(i);
            if (countUniqueX > 0 && uniqueX[countUniqueX - 1] > uniqueX[countUniqueX]) {
                throw new IllegalArgumentException("Array of x-values must be sorted");
            }
            int countSameX = 0;
            while (i < size && xValues.get(i) == currentX) {
                tempY[countSameX] = yValues.get(i);
                tempZ[countSameX] = zValues.get(i);
                if (countSameX > 0 && tempY[countSameX - 1] >= tempY[countSameX]) {
                    throw new IllegalArgumentException("Array of y-values must be sorted and unique within x-values");
                }
                ++countSameX;
                ++i;
            }
            if (countSameX == 1) {
                yInterpBuilder.add((Object)new ConstantCurveInterpolator(tempZ[0]));
            } else {
                DoubleArray yValuesSameX = DoubleArray.ofUnsafe((double[])Arrays.copyOf(tempY, countSameX));
                DoubleArray zValuesSameX = DoubleArray.ofUnsafe((double[])Arrays.copyOf(tempZ, countSameX));
                yInterpBuilder.add((Object)this.yInterpolator.bind(yValuesSameX, zValuesSameX, this.yExtrapolatorLeft, this.yExtrapolatorRight));
            }
            ++countUniqueX;
        }
        if (countUniqueX == 1) {
            throw new IllegalArgumentException("Surface interpolator requires at least two different x-values");
        }
        DoubleArray uniqueXArray = DoubleArray.ofUnsafe((double[])Arrays.copyOf(uniqueX, countUniqueX));
        BoundCurveInterpolator[] yInterps = (BoundCurveInterpolator[])yInterpBuilder.build().toArray((Object[])new BoundCurveInterpolator[0]);
        return new Bound(this.xInterpolator, this.xExtrapolatorLeft, this.xExtrapolatorRight, size, uniqueXArray, yInterps);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private GridSurfaceInterpolator(CurveInterpolator xInterpolator, CurveExtrapolator xExtrapolatorLeft, CurveExtrapolator xExtrapolatorRight, CurveInterpolator yInterpolator, CurveExtrapolator yExtrapolatorLeft, CurveExtrapolator yExtrapolatorRight) {
        this.xInterpolator = xInterpolator;
        this.xExtrapolatorLeft = xExtrapolatorLeft;
        this.xExtrapolatorRight = xExtrapolatorRight;
        this.yInterpolator = yInterpolator;
        this.yExtrapolatorLeft = yExtrapolatorLeft;
        this.yExtrapolatorRight = yExtrapolatorRight;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurveInterpolator getXInterpolator() {
        return this.xInterpolator;
    }

    public CurveExtrapolator getXExtrapolatorLeft() {
        return this.xExtrapolatorLeft;
    }

    public CurveExtrapolator getXExtrapolatorRight() {
        return this.xExtrapolatorRight;
    }

    public CurveInterpolator getYInterpolator() {
        return this.yInterpolator;
    }

    public CurveExtrapolator getYExtrapolatorLeft() {
        return this.yExtrapolatorLeft;
    }

    public CurveExtrapolator getYExtrapolatorRight() {
        return this.yExtrapolatorRight;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GridSurfaceInterpolator other = (GridSurfaceInterpolator)obj;
            return JodaBeanUtils.equal((Object)this.xInterpolator, (Object)other.xInterpolator) && JodaBeanUtils.equal((Object)this.xExtrapolatorLeft, (Object)other.xExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.xExtrapolatorRight, (Object)other.xExtrapolatorRight) && JodaBeanUtils.equal((Object)this.yInterpolator, (Object)other.yInterpolator) && JodaBeanUtils.equal((Object)this.yExtrapolatorLeft, (Object)other.yExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.yExtrapolatorRight, (Object)other.yExtrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.xInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.xExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.xExtrapolatorRight);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yExtrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("GridSurfaceInterpolator{");
        buf.append("xInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.xInterpolator)).append(',').append(' ');
        buf.append("xExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.xExtrapolatorLeft)).append(',').append(' ');
        buf.append("xExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.xExtrapolatorRight)).append(',').append(' ');
        buf.append("yInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.yInterpolator)).append(',').append(' ');
        buf.append("yExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.yExtrapolatorLeft)).append(',').append(' ');
        buf.append("yExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.yExtrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<GridSurfaceInterpolator> {
        private CurveInterpolator xInterpolator;
        private CurveExtrapolator xExtrapolatorLeft;
        private CurveExtrapolator xExtrapolatorRight;
        private CurveInterpolator yInterpolator;
        private CurveExtrapolator yExtrapolatorLeft;
        private CurveExtrapolator yExtrapolatorRight;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1411950943: {
                    return this.xInterpolator;
                }
                case -382665134: {
                    return this.xExtrapolatorLeft;
                }
                case 1027943729: {
                    return this.xExtrapolatorRight;
                }
                case 1118547936: {
                    return this.yInterpolator;
                }
                case 970644563: {
                    return this.yExtrapolatorLeft;
                }
                case 30871376: {
                    return this.yExtrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1411950943: {
                    this.xInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -382665134: {
                    this.xExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 1027943729: {
                    this.xExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                case 1118547936: {
                    this.yInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case 970644563: {
                    this.yExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 30871376: {
                    this.yExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public GridSurfaceInterpolator build() {
            return new GridSurfaceInterpolator(this.xInterpolator, this.xExtrapolatorLeft, this.xExtrapolatorRight, this.yInterpolator, this.yExtrapolatorLeft, this.yExtrapolatorRight);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("GridSurfaceInterpolator.Builder{");
            buf.append("xInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.xInterpolator)).append(',').append(' ');
            buf.append("xExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.xExtrapolatorLeft)).append(',').append(' ');
            buf.append("xExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.xExtrapolatorRight)).append(',').append(' ');
            buf.append("yInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.yInterpolator)).append(',').append(' ');
            buf.append("yExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.yExtrapolatorLeft)).append(',').append(' ');
            buf.append("yExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.yExtrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveInterpolator> xInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xInterpolator", GridSurfaceInterpolator.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> xExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xExtrapolatorLeft", GridSurfaceInterpolator.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> xExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xExtrapolatorRight", GridSurfaceInterpolator.class, CurveExtrapolator.class);
        private final MetaProperty<CurveInterpolator> yInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yInterpolator", GridSurfaceInterpolator.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> yExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yExtrapolatorLeft", GridSurfaceInterpolator.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> yExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yExtrapolatorRight", GridSurfaceInterpolator.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"xInterpolator", "xExtrapolatorLeft", "xExtrapolatorRight", "yInterpolator", "yExtrapolatorLeft", "yExtrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1411950943: {
                    return this.xInterpolator;
                }
                case -382665134: {
                    return this.xExtrapolatorLeft;
                }
                case 1027943729: {
                    return this.xExtrapolatorRight;
                }
                case 1118547936: {
                    return this.yInterpolator;
                }
                case 970644563: {
                    return this.yExtrapolatorLeft;
                }
                case 30871376: {
                    return this.yExtrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends GridSurfaceInterpolator> builder() {
            return new Builder();
        }

        public Class<? extends GridSurfaceInterpolator> beanType() {
            return GridSurfaceInterpolator.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveInterpolator> xInterpolator() {
            return this.xInterpolator;
        }

        public MetaProperty<CurveExtrapolator> xExtrapolatorLeft() {
            return this.xExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> xExtrapolatorRight() {
            return this.xExtrapolatorRight;
        }

        public MetaProperty<CurveInterpolator> yInterpolator() {
            return this.yInterpolator;
        }

        public MetaProperty<CurveExtrapolator> yExtrapolatorLeft() {
            return this.yExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> yExtrapolatorRight() {
            return this.yExtrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1411950943: {
                    return ((GridSurfaceInterpolator)bean).getXInterpolator();
                }
                case -382665134: {
                    return ((GridSurfaceInterpolator)bean).getXExtrapolatorLeft();
                }
                case 1027943729: {
                    return ((GridSurfaceInterpolator)bean).getXExtrapolatorRight();
                }
                case 1118547936: {
                    return ((GridSurfaceInterpolator)bean).getYInterpolator();
                }
                case 970644563: {
                    return ((GridSurfaceInterpolator)bean).getYExtrapolatorLeft();
                }
                case 30871376: {
                    return ((GridSurfaceInterpolator)bean).getYExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }

    static class ConstantCurveInterpolator
    implements BoundCurveInterpolator {
        private final double value;

        public ConstantCurveInterpolator(double value) {
            this.value = value;
        }

        @Override
        public double interpolate(double x) {
            return this.value;
        }

        @Override
        public double firstDerivative(double x) {
            return 0.0;
        }

        @Override
        public DoubleArray parameterSensitivity(double x) {
            return DoubleArray.of((double)1.0);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return this;
        }
    }

    static class Bound
    implements BoundSurfaceInterpolator {
        private final CurveInterpolator xInterpolator;
        private final CurveExtrapolator xExtrapolatorLeft;
        private final CurveExtrapolator xExtrapolatorRight;
        private final DoubleArray xValuesUnique;
        private final int paramSize;
        private final BoundCurveInterpolator[] yInterpolators;

        Bound(CurveInterpolator xInterpolator, CurveExtrapolator xExtrapolatorLeft, CurveExtrapolator xExtrapolatorRight, int paramSize, DoubleArray xValuesUnique, BoundCurveInterpolator[] yInterpolators) {
            this.xInterpolator = xInterpolator;
            this.xExtrapolatorLeft = xExtrapolatorLeft;
            this.xExtrapolatorRight = xExtrapolatorRight;
            this.xValuesUnique = xValuesUnique;
            this.paramSize = paramSize;
            this.yInterpolators = yInterpolators;
        }

        @Override
        public double interpolate(double x, double y) {
            DoubleArray zValuesEffective = DoubleArray.of((int)this.yInterpolators.length, i -> this.yInterpolators[i].interpolate(y));
            return this.xInterpolator.bind(this.xValuesUnique, zValuesEffective, this.xExtrapolatorLeft, this.xExtrapolatorRight).interpolate(x);
        }

        @Override
        public DoubleArray parameterSensitivity(double x, double y) {
            int uniqueX = this.yInterpolators.length;
            DoubleArray[] ySens = new DoubleArray[uniqueX];
            for (int i2 = 0; i2 < uniqueX; ++i2) {
                ySens[i2] = this.yInterpolators[i2].parameterSensitivity(y);
            }
            DoubleArray zValuesEffective = DoubleArray.of((int)uniqueX, i -> this.yInterpolators[i].interpolate(y));
            DoubleArray xSens = this.xInterpolator.bind(this.xValuesUnique, zValuesEffective, this.xExtrapolatorLeft, this.xExtrapolatorRight).parameterSensitivity(x);
            return this.project(xSens, ySens);
        }

        @Override
        public ValueDerivatives firstPartialDerivatives(double x, double y) {
            int uniqueX = this.yInterpolators.length;
            DoubleArray zValuesEffective = DoubleArray.of((int)uniqueX, i -> this.yInterpolators[i].interpolate(y));
            this.yInterpolators[0].interpolate(y);
            double xDerivative = this.xInterpolator.bind(this.xValuesUnique, zValuesEffective, this.xExtrapolatorLeft, this.xExtrapolatorRight).firstDerivative(x);
            DoubleArray yDerivatives = DoubleArray.of((int)uniqueX, i -> this.yInterpolators[i].firstDerivative(y));
            double yDerivative = this.xInterpolator.bind(this.xValuesUnique, yDerivatives, this.xExtrapolatorLeft, this.xExtrapolatorRight).interpolate(x);
            double zValue = this.interpolate(x, y);
            return ValueDerivatives.of((double)zValue, (DoubleArray)DoubleArray.of((double)xDerivative, (double)yDerivative));
        }

        private DoubleArray project(DoubleArray xSens, DoubleArray[] ySens) {
            int countParam = 0;
            double[] paramSens = new double[this.paramSize];
            for (int i = 0; i < xSens.size(); ++i) {
                double xs = xSens.get(i);
                DoubleArray ys = ySens[i];
                for (int j = 0; j < ys.size(); ++j) {
                    paramSens[countParam++] = xs * ys.get(j);
                }
            }
            return DoubleArray.ofUnsafe((double[])paramSens);
        }
    }
}

