/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.model.MoneynessType;
import com.opengamma.strata.market.surface.DefaultSurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceName;

public final class Surfaces {
    private Surfaces() {
    }

    public static SurfaceMetadata blackVolatilityByExpiryTenor(String name, DayCount dayCount) {
        return Surfaces.blackVolatilityByExpiryTenor(SurfaceName.of(name), dayCount);
    }

    public static SurfaceMetadata blackVolatilityByExpiryTenor(SurfaceName name, DayCount dayCount) {
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.YEAR_FRACTION).zValueType(ValueType.BLACK_VOLATILITY).dayCount(dayCount).build();
    }

    public static SurfaceMetadata blackVolatilityByExpiryStrike(String name, DayCount dayCount) {
        return Surfaces.blackVolatilityByExpiryStrike(SurfaceName.of(name), dayCount);
    }

    public static SurfaceMetadata blackVolatilityByExpiryStrike(SurfaceName name, DayCount dayCount) {
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.STRIKE).zValueType(ValueType.BLACK_VOLATILITY).dayCount(dayCount).build();
    }

    public static SurfaceMetadata blackVolatilityByExpiryLogMoneyness(String name, DayCount dayCount) {
        return Surfaces.blackVolatilityByExpiryLogMoneyness(SurfaceName.of(name), dayCount);
    }

    public static SurfaceMetadata blackVolatilityByExpiryLogMoneyness(SurfaceName name, DayCount dayCount) {
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.LOG_MONEYNESS).zValueType(ValueType.BLACK_VOLATILITY).dayCount(dayCount).build();
    }

    public static SurfaceMetadata normalVolatilityByExpiryTenor(String name, DayCount dayCount) {
        return Surfaces.normalVolatilityByExpiryTenor(SurfaceName.of(name), dayCount);
    }

    public static SurfaceMetadata normalVolatilityByExpiryTenor(SurfaceName name, DayCount dayCount) {
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.YEAR_FRACTION).zValueType(ValueType.NORMAL_VOLATILITY).dayCount(dayCount).build();
    }

    public static SurfaceMetadata normalVolatilityByExpiryStrike(String name, DayCount dayCount) {
        return Surfaces.normalVolatilityByExpiryStrike(SurfaceName.of(name), dayCount);
    }

    public static SurfaceMetadata normalVolatilityByExpiryStrike(SurfaceName name, DayCount dayCount) {
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.STRIKE).zValueType(ValueType.NORMAL_VOLATILITY).dayCount(dayCount).build();
    }

    public static SurfaceMetadata normalVolatilityByExpirySimpleMoneyness(String name, DayCount dayCount, MoneynessType moneynessType) {
        return Surfaces.normalVolatilityByExpirySimpleMoneyness(SurfaceName.of(name), dayCount, moneynessType);
    }

    public static SurfaceMetadata normalVolatilityByExpirySimpleMoneyness(SurfaceName name, DayCount dayCount, MoneynessType moneynessType) {
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.SIMPLE_MONEYNESS).zValueType(ValueType.NORMAL_VOLATILITY).dayCount(dayCount).addInfo(SurfaceInfoType.MONEYNESS_TYPE, moneynessType).build();
    }

    public static SurfaceMetadata sabrParameterByExpiryTenor(String name, DayCount dayCount, ValueType zType) {
        return Surfaces.sabrParameterByExpiryTenor(SurfaceName.of(name), dayCount, zType);
    }

    public static SurfaceMetadata sabrParameterByExpiryTenor(SurfaceName name, DayCount dayCount, ValueType zType) {
        if (!(zType.equals((Object)ValueType.SABR_ALPHA) || zType.equals((Object)ValueType.SABR_BETA) || zType.equals((Object)ValueType.SABR_RHO) || zType.equals((Object)ValueType.SABR_NU))) {
            throw new IllegalArgumentException("SABR z-value type must be SabrAlpha, SabrBeta, SabrRho or SabrNu");
        }
        return DefaultSurfaceMetadata.builder().surfaceName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.YEAR_FRACTION).zValueType(zType).dayCount(dayCount).build();
    }
}

