/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.surface.DefaultSurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.market.surface.SurfaceName;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public interface SurfaceMetadata {
    public SurfaceName getSurfaceName();

    public ValueType getXValueType();

    public ValueType getYValueType();

    public ValueType getZValueType();

    default public <T> T getInfo(SurfaceInfoType<T> type) {
        return this.findInfo(type).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Surface info not found for type '{}'", (Object)type)));
    }

    public <T> Optional<T> findInfo(SurfaceInfoType<T> var1);

    default public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.getParameterMetadata().map(pm -> (ParameterMetadata)pm.get(parameterIndex)).orElse(ParameterMetadata.empty());
    }

    public Optional<List<ParameterMetadata>> getParameterMetadata();

    default public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        int index;
        Optional<List<ParameterMetadata>> pmOpt;
        if (!ParameterMetadata.empty().equals(metadata) && (pmOpt = this.getParameterMetadata()).isPresent() && (index = pmOpt.get().indexOf(metadata)) >= 0) {
            return OptionalInt.of(index);
        }
        return OptionalInt.empty();
    }

    public <T> DefaultSurfaceMetadata withInfo(SurfaceInfoType<T> var1, T var2);

    public SurfaceMetadata withParameterMetadata(List<? extends ParameterMetadata> var1);
}

