/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.DoublesPair;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceName;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public interface Surface
extends ParameterizedData {
    public SurfaceMetadata getMetadata();

    public Surface withMetadata(SurfaceMetadata var1);

    default public SurfaceName getName() {
        return this.getMetadata().getSurfaceName();
    }

    @Override
    default public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.getMetadata().getParameterMetadata(parameterIndex);
    }

    @Override
    default public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.getMetadata().findParameterIndex(metadata);
    }

    @Override
    public Surface withParameter(int var1, double var2);

    @Override
    default public Surface withPerturbation(ParameterPerturbation perturbation) {
        return (Surface)ParameterizedData.super.withPerturbation(perturbation);
    }

    public double zValue(double var1, double var3);

    default public double zValue(DoublesPair xyPair) {
        return this.zValue(xyPair.getFirst(), xyPair.getSecond());
    }

    public UnitParameterSensitivity zValueParameterSensitivity(double var1, double var3);

    default public UnitParameterSensitivity zValueParameterSensitivity(DoublesPair xyPair) {
        return this.zValueParameterSensitivity(xyPair.getFirst(), xyPair.getSecond());
    }

    public ValueDerivatives firstPartialDerivatives(double var1, double var3);

    default public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        List paramMeta = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> this.getParameterMetadata(i)).collect(Guavate.toImmutableList());
        return UnitParameterSensitivity.of(this.getName(), paramMeta, sensitivities);
    }

    default public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        List paramMeta = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> this.getParameterMetadata(i)).collect(Guavate.toImmutableList());
        return CurrencyParameterSensitivity.of(this.getName(), paramMeta, currency, sensitivities);
    }
}

