/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.tuple.DoublesPair;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class DeformedSurface
implements Surface,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SurfaceMetadata metadata;
    @PropertyDefinition(validate="notNull")
    private final Surface originalSurface;
    @PropertyDefinition(validate="notNull")
    private final Function<DoublesPair, ValueDerivatives> deformationFunction;
    private static final long serialVersionUID = 1L;

    @Override
    public int getParameterCount() {
        return this.originalSurface.getParameterCount();
    }

    @Override
    public DeformedSurface withMetadata(SurfaceMetadata metadata) {
        return new DeformedSurface(metadata, this.originalSurface, this.deformationFunction);
    }

    @Override
    public double getParameter(int parameterIndex) {
        return this.originalSurface.getParameter(parameterIndex);
    }

    @Override
    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.originalSurface.getParameterMetadata(parameterIndex);
    }

    @Override
    public Surface withParameter(int parameterIndex, double newValue) {
        throw new IllegalArgumentException("deformationFunction must be redefined with the new value");
    }

    @Override
    public double zValue(double x, double y) {
        return this.deformationFunction.apply(DoublesPair.of((double)x, (double)y)).getValue();
    }

    @Override
    public UnitParameterSensitivity zValueParameterSensitivity(double x, double y) {
        return this.getMetadata().getParameterMetadata().isPresent() ? UnitParameterSensitivity.of(this.getMetadata().getSurfaceName(), this.getMetadata().getParameterMetadata().get(), this.deformationFunction.apply(DoublesPair.of((double)x, (double)y)).getDerivatives()) : UnitParameterSensitivity.of(this.getMetadata().getSurfaceName(), this.deformationFunction.apply(DoublesPair.of((double)x, (double)y)).getDerivatives());
    }

    @Override
    public ValueDerivatives firstPartialDerivatives(double x, double y) {
        throw new UnsupportedOperationException("First partial derivatives not supported for deformed surfaces");
    }

    public static DeformedSurface of(SurfaceMetadata metadata, Surface originalSurface, Function<DoublesPair, ValueDerivatives> deformationFunction) {
        return DeformedSurface.builder().metadata(metadata).originalSurface(originalSurface).deformationFunction(deformationFunction).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DeformedSurface(SurfaceMetadata metadata, Surface originalSurface, Function<DoublesPair, ValueDerivatives> deformationFunction) {
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        JodaBeanUtils.notNull((Object)originalSurface, (String)"originalSurface");
        JodaBeanUtils.notNull(deformationFunction, (String)"deformationFunction");
        this.metadata = metadata;
        this.originalSurface = originalSurface;
        this.deformationFunction = deformationFunction;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SurfaceMetadata getMetadata() {
        return this.metadata;
    }

    public Surface getOriginalSurface() {
        return this.originalSurface;
    }

    public Function<DoublesPair, ValueDerivatives> getDeformationFunction() {
        return this.deformationFunction;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DeformedSurface other = (DeformedSurface)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((Object)this.originalSurface, (Object)other.originalSurface) && JodaBeanUtils.equal(this.deformationFunction, other.deformationFunction);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.originalSurface);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.deformationFunction);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("DeformedSurface{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("originalSurface").append('=').append(JodaBeanUtils.toString((Object)this.originalSurface)).append(',').append(' ');
        buf.append("deformationFunction").append('=').append(JodaBeanUtils.toString(this.deformationFunction));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<DeformedSurface> {
        private SurfaceMetadata metadata;
        private Surface originalSurface;
        private Function<DoublesPair, ValueDerivatives> deformationFunction;

        private Builder() {
        }

        private Builder(DeformedSurface beanToCopy) {
            this.metadata = beanToCopy.getMetadata();
            this.originalSurface = beanToCopy.getOriginalSurface();
            this.deformationFunction = beanToCopy.getDeformationFunction();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 1982430620: {
                    return this.originalSurface;
                }
                case -360086200: {
                    return this.deformationFunction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (SurfaceMetadata)newValue;
                    break;
                }
                case 1982430620: {
                    this.originalSurface = (Surface)newValue;
                    break;
                }
                case -360086200: {
                    this.deformationFunction = (Function)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public DeformedSurface build() {
            return new DeformedSurface(this.metadata, this.originalSurface, this.deformationFunction);
        }

        public Builder metadata(SurfaceMetadata metadata) {
            JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
            this.metadata = metadata;
            return this;
        }

        public Builder originalSurface(Surface originalSurface) {
            JodaBeanUtils.notNull((Object)originalSurface, (String)"originalSurface");
            this.originalSurface = originalSurface;
            return this;
        }

        public Builder deformationFunction(Function<DoublesPair, ValueDerivatives> deformationFunction) {
            JodaBeanUtils.notNull(deformationFunction, (String)"deformationFunction");
            this.deformationFunction = deformationFunction;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("DeformedSurface.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("originalSurface").append('=').append(JodaBeanUtils.toString((Object)this.originalSurface)).append(',').append(' ');
            buf.append("deformationFunction").append('=').append(JodaBeanUtils.toString(this.deformationFunction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SurfaceMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", DeformedSurface.class, SurfaceMetadata.class);
        private final MetaProperty<Surface> originalSurface = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"originalSurface", DeformedSurface.class, Surface.class);
        private final MetaProperty<Function<DoublesPair, ValueDerivatives>> deformationFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"deformationFunction", DeformedSurface.class, Function.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "originalSurface", "deformationFunction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 1982430620: {
                    return this.originalSurface;
                }
                case -360086200: {
                    return this.deformationFunction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends DeformedSurface> beanType() {
            return DeformedSurface.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SurfaceMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<Surface> originalSurface() {
            return this.originalSurface;
        }

        public MetaProperty<Function<DoublesPair, ValueDerivatives>> deformationFunction() {
            return this.deformationFunction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((DeformedSurface)bean).getMetadata();
                }
                case 1982430620: {
                    return ((DeformedSurface)bean).getOriginalSurface();
                }
                case -360086200: {
                    return ((DeformedSurface)bean).getDeformationFunction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

