/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.surface.DefaultSurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.market.surface.SurfaceName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DefaultSurfaceMetadataBuilder {
    private SurfaceName surfaceName;
    private ValueType xValueType = ValueType.UNKNOWN;
    private ValueType yValueType = ValueType.UNKNOWN;
    private ValueType zValueType = ValueType.UNKNOWN;
    private final Map<SurfaceInfoType<?>, Object> info = new HashMap();
    private List<ParameterMetadata> parameterMetadata;

    DefaultSurfaceMetadataBuilder() {
    }

    DefaultSurfaceMetadataBuilder(DefaultSurfaceMetadata beanToCopy) {
        this.surfaceName = beanToCopy.getSurfaceName();
        this.xValueType = beanToCopy.getXValueType();
        this.yValueType = beanToCopy.getYValueType();
        this.zValueType = beanToCopy.getZValueType();
        this.info.putAll((Map<SurfaceInfoType<?>, Object>)beanToCopy.getInfo());
        this.parameterMetadata = beanToCopy.getParameterMetadata().orElse(null);
    }

    public DefaultSurfaceMetadataBuilder surfaceName(String surfaceName) {
        this.surfaceName = SurfaceName.of(surfaceName);
        return this;
    }

    public DefaultSurfaceMetadataBuilder surfaceName(SurfaceName surfaceName) {
        this.surfaceName = (SurfaceName)ArgChecker.notNull((Object)surfaceName, (String)"surfaceName");
        return this;
    }

    public DefaultSurfaceMetadataBuilder xValueType(ValueType xValueType) {
        this.xValueType = (ValueType)((Object)ArgChecker.notNull((Object)((Object)xValueType), (String)"xValueType"));
        return this;
    }

    public DefaultSurfaceMetadataBuilder yValueType(ValueType yValueType) {
        this.yValueType = (ValueType)((Object)ArgChecker.notNull((Object)((Object)yValueType), (String)"yValueType"));
        return this;
    }

    public DefaultSurfaceMetadataBuilder zValueType(ValueType zValueType) {
        this.zValueType = (ValueType)((Object)ArgChecker.notNull((Object)((Object)zValueType), (String)"zValueType"));
        return this;
    }

    public DefaultSurfaceMetadataBuilder dayCount(DayCount dayCount) {
        return this.addInfo(SurfaceInfoType.DAY_COUNT, dayCount);
    }

    public <T> DefaultSurfaceMetadataBuilder addInfo(SurfaceInfoType<T> type, T value) {
        ArgChecker.notNull(type, (String)"type");
        if (value != null) {
            this.info.put(type, value);
        } else {
            this.info.remove(type);
        }
        return this;
    }

    public DefaultSurfaceMetadataBuilder parameterMetadata(List<? extends ParameterMetadata> parameterMetadata) {
        this.parameterMetadata = ImmutableList.copyOf(parameterMetadata);
        return this;
    }

    public DefaultSurfaceMetadataBuilder parameterMetadata(ParameterMetadata ... parameterMetadata) {
        this.parameterMetadata = ImmutableList.copyOf((Object[])parameterMetadata);
        return this;
    }

    public DefaultSurfaceMetadataBuilder clearParameterMetadata() {
        this.parameterMetadata = null;
        return this;
    }

    public DefaultSurfaceMetadata build() {
        return new DefaultSurfaceMetadata(this.surfaceName, this.xValueType, this.yValueType, this.zValueType, this.info, this.parameterMetadata);
    }
}

