/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.surface.DefaultSurfaceMetadataBuilder;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceName;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class DefaultSurfaceMetadata
implements SurfaceMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SurfaceName surfaceName;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType xValueType;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType yValueType;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType zValueType;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<SurfaceInfoType<?>, Object> info;
    @PropertyDefinition(get="optional", overrideGet=true, type="List<>", builderType="List<? extends ParameterMetadata>")
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    private static final long serialVersionUID = 1L;

    public static DefaultSurfaceMetadata of(String name) {
        return DefaultSurfaceMetadata.of(SurfaceName.of(name));
    }

    public static DefaultSurfaceMetadata of(SurfaceName name) {
        return new DefaultSurfaceMetadata(name, ValueType.UNKNOWN, ValueType.UNKNOWN, ValueType.UNKNOWN, (Map<SurfaceInfoType<?>, Object>)ImmutableMap.of(), null);
    }

    public static DefaultSurfaceMetadataBuilder builder() {
        return new DefaultSurfaceMetadataBuilder();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.xValueType = ValueType.UNKNOWN;
        builder.yValueType = ValueType.UNKNOWN;
        builder.zValueType = ValueType.UNKNOWN;
    }

    @Override
    public <T> T getInfo(SurfaceInfoType<T> type) {
        Object value = this.info.get(type);
        if (value == null) {
            throw new IllegalArgumentException(Messages.format((String)"Surface info not found for type '{}'", type));
        }
        return (T)value;
    }

    @Override
    public <T> Optional<T> findInfo(SurfaceInfoType<T> type) {
        return Optional.ofNullable(this.info.get(type));
    }

    @Override
    public <T> DefaultSurfaceMetadata withInfo(SurfaceInfoType<T> type, T value) {
        return this.toBuilder().addInfo(type, value).build();
    }

    @Override
    public DefaultSurfaceMetadata withParameterMetadata(List<? extends ParameterMetadata> parameterMetadata) {
        if (parameterMetadata == null) {
            return this.parameterMetadata != null ? this.toBuilder().clearParameterMetadata().build() : this;
        }
        return this.toBuilder().parameterMetadata(parameterMetadata).build();
    }

    public DefaultSurfaceMetadataBuilder toBuilder() {
        return new DefaultSurfaceMetadataBuilder(this);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    DefaultSurfaceMetadata(SurfaceName surfaceName, ValueType xValueType, ValueType yValueType, ValueType zValueType, Map<SurfaceInfoType<?>, Object> info, List<? extends ParameterMetadata> parameterMetadata) {
        JodaBeanUtils.notNull((Object)surfaceName, (String)"surfaceName");
        JodaBeanUtils.notNull((Object)((Object)xValueType), (String)"xValueType");
        JodaBeanUtils.notNull((Object)((Object)yValueType), (String)"yValueType");
        JodaBeanUtils.notNull((Object)((Object)zValueType), (String)"zValueType");
        JodaBeanUtils.notNull(info, (String)"info");
        this.surfaceName = surfaceName;
        this.xValueType = xValueType;
        this.yValueType = yValueType;
        this.zValueType = zValueType;
        this.info = ImmutableMap.copyOf(info);
        this.parameterMetadata = parameterMetadata != null ? ImmutableList.copyOf(parameterMetadata) : null;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SurfaceName getSurfaceName() {
        return this.surfaceName;
    }

    @Override
    public ValueType getXValueType() {
        return this.xValueType;
    }

    @Override
    public ValueType getYValueType() {
        return this.yValueType;
    }

    @Override
    public ValueType getZValueType() {
        return this.zValueType;
    }

    public ImmutableMap<SurfaceInfoType<?>, Object> getInfo() {
        return this.info;
    }

    @Override
    public Optional<List<ParameterMetadata>> getParameterMetadata() {
        return Optional.ofNullable(this.parameterMetadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultSurfaceMetadata other = (DefaultSurfaceMetadata)obj;
            return JodaBeanUtils.equal((Object)this.surfaceName, (Object)other.surfaceName) && JodaBeanUtils.equal((Object)((Object)this.xValueType), (Object)((Object)other.xValueType)) && JodaBeanUtils.equal((Object)((Object)this.yValueType), (Object)((Object)other.yValueType)) && JodaBeanUtils.equal((Object)((Object)this.zValueType), (Object)((Object)other.zValueType)) && JodaBeanUtils.equal(this.info, other.info) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.surfaceName);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.xValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.zValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("DefaultSurfaceMetadata{");
        buf.append("surfaceName").append('=').append(JodaBeanUtils.toString((Object)this.surfaceName)).append(',').append(' ');
        buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
        buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
        buf.append("zValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.zValueType))).append(',').append(' ');
        buf.append("info").append('=').append(JodaBeanUtils.toString(this.info)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DefaultSurfaceMetadata> {
        private SurfaceName surfaceName;
        private ValueType xValueType;
        private ValueType yValueType;
        private ValueType zValueType;
        private Map<SurfaceInfoType<?>, Object> info = ImmutableMap.of();
        private List<? extends ParameterMetadata> parameterMetadata;

        private Builder() {
            DefaultSurfaceMetadata.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1403077416: {
                    return this.surfaceName;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case -1261536015: {
                    return this.zValueType;
                }
                case 3237038: {
                    return this.info;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1403077416: {
                    this.surfaceName = (SurfaceName)newValue;
                    break;
                }
                case -868509005: {
                    this.xValueType = (ValueType)((Object)newValue);
                    break;
                }
                case -1065022510: {
                    this.yValueType = (ValueType)((Object)newValue);
                    break;
                }
                case -1261536015: {
                    this.zValueType = (ValueType)((Object)newValue);
                    break;
                }
                case 3237038: {
                    this.info = (Map)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DefaultSurfaceMetadata build() {
            return new DefaultSurfaceMetadata(this.surfaceName, this.xValueType, this.yValueType, this.zValueType, this.info, this.parameterMetadata);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("DefaultSurfaceMetadata.Builder{");
            buf.append("surfaceName").append('=').append(JodaBeanUtils.toString((Object)this.surfaceName)).append(',').append(' ');
            buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
            buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
            buf.append("zValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.zValueType))).append(',').append(' ');
            buf.append("info").append('=').append(JodaBeanUtils.toString(this.info)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SurfaceName> surfaceName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"surfaceName", DefaultSurfaceMetadata.class, SurfaceName.class);
        private final MetaProperty<ValueType> xValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValueType", DefaultSurfaceMetadata.class, ValueType.class);
        private final MetaProperty<ValueType> yValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValueType", DefaultSurfaceMetadata.class, ValueType.class);
        private final MetaProperty<ValueType> zValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"zValueType", DefaultSurfaceMetadata.class, ValueType.class);
        private final MetaProperty<ImmutableMap<SurfaceInfoType<?>, Object>> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", DefaultSurfaceMetadata.class, ImmutableMap.class);
        private final MetaProperty<List<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", DefaultSurfaceMetadata.class, List.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"surfaceName", "xValueType", "yValueType", "zValueType", "info", "parameterMetadata"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1403077416: {
                    return this.surfaceName;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case -1261536015: {
                    return this.zValueType;
                }
                case 3237038: {
                    return this.info;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DefaultSurfaceMetadata> builder() {
            return new Builder();
        }

        public Class<? extends DefaultSurfaceMetadata> beanType() {
            return DefaultSurfaceMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SurfaceName> surfaceName() {
            return this.surfaceName;
        }

        public MetaProperty<ValueType> xValueType() {
            return this.xValueType;
        }

        public MetaProperty<ValueType> yValueType() {
            return this.yValueType;
        }

        public MetaProperty<ValueType> zValueType() {
            return this.zValueType;
        }

        public MetaProperty<ImmutableMap<SurfaceInfoType<?>, Object>> info() {
            return this.info;
        }

        public MetaProperty<List<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1403077416: {
                    return ((DefaultSurfaceMetadata)bean).getSurfaceName();
                }
                case -868509005: {
                    return ((DefaultSurfaceMetadata)bean).getXValueType();
                }
                case -1065022510: {
                    return ((DefaultSurfaceMetadata)bean).getYValueType();
                }
                case -1261536015: {
                    return ((DefaultSurfaceMetadata)bean).getZValueType();
                }
                case 3237038: {
                    return ((DefaultSurfaceMetadata)bean).getInfo();
                }
                case -1169106440: {
                    return ((DefaultSurfaceMetadata)bean).parameterMetadata;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

