/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.sensitivity;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;

public interface PointSensitivity
extends FxConvertible<PointSensitivity> {
    public Currency getCurrency();

    public double getSensitivity();

    public PointSensitivity withCurrency(Currency var1);

    public PointSensitivity withSensitivity(double var1);

    public int compareKey(PointSensitivity var1);

    default public PointSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.getCurrency().equals((Object)resultCurrency)) {
            return this;
        }
        double fxRate = rateProvider.fxRate(this.getCurrency(), resultCurrency);
        return this.withCurrency(resultCurrency).withSensitivity(fxRate * this.getSensitivity());
    }
}

