/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.sensitivity;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class PointSensitivities
implements FxConvertible<PointSensitivities>,
ImmutableBean,
Serializable {
    private static final PointSensitivities EMPTY = new PointSensitivities((List<PointSensitivity>)ImmutableList.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<PointSensitivity> sensitivities;
    private static final long serialVersionUID = 1L;

    public static PointSensitivities empty() {
        return EMPTY;
    }

    public static PointSensitivities of(PointSensitivity ... sensitivity) {
        return PointSensitivities.of((List<? extends PointSensitivity>)ImmutableList.copyOf((Object[])sensitivity));
    }

    public static PointSensitivities of(List<? extends PointSensitivity> sensitivities) {
        return new PointSensitivities(sensitivities);
    }

    public int size() {
        return this.sensitivities.size();
    }

    public PointSensitivities combinedWith(PointSensitivities other) {
        return new PointSensitivities((List<PointSensitivity>)ImmutableList.builder().addAll(this.sensitivities).addAll(other.sensitivities).build());
    }

    public PointSensitivities multipliedBy(double factor) {
        return this.mapSensitivities(s -> s * factor);
    }

    public PointSensitivities mapSensitivities(DoubleUnaryOperator operator) {
        return this.sensitivities.stream().map(s -> s.withSensitivity(operator.applyAsDouble(s.getSensitivity()))).collect(Collectors.collectingAndThen(Guavate.toImmutableList(), PointSensitivities::new));
    }

    public PointSensitivities normalized() {
        if (this.sensitivities.isEmpty()) {
            return this;
        }
        ArrayList<PointSensitivity> mutable = new ArrayList<PointSensitivity>();
        for (PointSensitivity sensi : this.sensitivities) {
            PointSensitivities.insert(mutable, sensi);
        }
        return new PointSensitivities(mutable);
    }

    public MutablePointSensitivities toMutable() {
        return new MutablePointSensitivities((List<? extends PointSensitivity>)this.sensitivities);
    }

    public boolean equalWithTolerance(PointSensitivities other, double tolerance) {
        int nbList2;
        ImmutableList<PointSensitivity> list1 = this.getSensitivities();
        ImmutableList<PointSensitivity> list2 = other.getSensitivities();
        int nbList1 = list1.size();
        if (nbList1 != (nbList2 = list2.size())) {
            return false;
        }
        for (int i1 = 0; i1 < nbList1; ++i1) {
            if (((PointSensitivity)list1.get(i1)).compareKey((PointSensitivity)list2.get(i1)) == 0) {
                if (!(Math.abs(((PointSensitivity)list1.get(i1)).getSensitivity() - ((PointSensitivity)list2.get(i1)).getSensitivity()) > tolerance)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public PointSensitivities convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        ArrayList<PointSensitivity> mutable = new ArrayList<PointSensitivity>();
        for (PointSensitivity sensi : this.sensitivities) {
            PointSensitivities.insert(mutable, sensi.convertedTo(resultCurrency, rateProvider));
        }
        return new PointSensitivities(mutable);
    }

    private static void insert(List<PointSensitivity> mutable, PointSensitivity addition) {
        int index = Collections.binarySearch(mutable, addition, PointSensitivity::compareKey);
        if (index >= 0) {
            PointSensitivity base = mutable.get(index);
            double combined = base.getSensitivity() + addition.getSensitivity();
            mutable.set(index, base.withSensitivity(combined));
        } else {
            int insertionPoint = -(index + 1);
            mutable.add(insertionPoint, addition);
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private PointSensitivities(List<PointSensitivity> sensitivities) {
        JodaBeanUtils.notNull(sensitivities, (String)"sensitivities");
        this.sensitivities = ImmutableList.copyOf(sensitivities);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<PointSensitivity> getSensitivities() {
        return this.sensitivities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PointSensitivities other = (PointSensitivities)obj;
            return JodaBeanUtils.equal(this.sensitivities, other.sensitivities);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.sensitivities);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("PointSensitivities{");
        buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<PointSensitivities> {
        private List<PointSensitivity> sensitivities = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    this.sensitivities = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public PointSensitivities build() {
            return new PointSensitivities(this.sensitivities);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("PointSensitivities.Builder{");
            buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<PointSensitivity>> sensitivities = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivities", PointSensitivities.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"sensitivities"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends PointSensitivities> builder() {
            return new Builder();
        }

        public Class<? extends PointSensitivities> beanType() {
            return PointSensitivities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<PointSensitivity>> sensitivities() {
            return this.sensitivities;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return ((PointSensitivities)bean).getSensitivities();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

